/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.DataFormatException;
import lev.LImport;
import lev.LShrinkArray;
import lev.Ln;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SPGlobal;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class AltTextures
extends SubRecordTyped {
    ArrayList<AltTexture> altTextures = new ArrayList();

    AltTextures(String t) {
        super(t);
    }

    @Override
    void export(ModExporter out) throws IOException {
        super.export(out);
        if (this.isValid()) {
            out.write(this.altTextures.size());
            for (AltTexture t : this.altTextures) {
                t.export(out);
            }
        }
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        int numTextures = in.extractInt(4);
        int i = 0;
        while (i < numTextures) {
            int strLength = Ln.arrayToInt((int[])in.getInts(0, 4));
            AltTexture newText = new AltTexture(new LShrinkArray(in.extract(12 + strLength)), srcMod);
            this.altTextures.add(newText);
            if (SPGlobal.logMods) {
                AltTextures.logMod(srcMod, "", "New Texture Alt -- Name: " + newText.name + ", texture: " + newText.texture + ", index: " + newText.index);
            }
            ++i;
        }
    }

    @Override
    ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> out = new ArrayList<FormID>(this.altTextures.size());
        for (AltTexture t : this.altTextures) {
            out.add(t.texture);
        }
        return out;
    }

    @Override
    SubRecord getNew(String type) {
        return new AltTextures(type);
    }

    @Override
    boolean isValid() {
        return !this.altTextures.isEmpty();
    }

    @Override
    int getContentLength(ModExporter out) {
        int len = 4;
        for (AltTexture t : this.altTextures) {
            len += t.getTotalLength();
        }
        return len;
    }

    public static boolean equal(ArrayList<AltTexture> alts, ArrayList<AltTexture> rhsAlts) {
        if (alts.size() != rhsAlts.size()) {
            return false;
        }
        if (alts.isEmpty() && rhsAlts.isEmpty()) {
            return true;
        }
        HashSet<AltTexture> altSet = new HashSet<AltTexture>(alts);
        for (AltTexture t : rhsAlts) {
            if (altSet.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static class AltTexture
    implements Serializable {
        String name;
        FormID texture = new FormID();
        int index;

        public AltTexture(String name, FormID txst, int index) {
            this.name = name;
            this.texture = txst;
            this.index = index;
        }

        AltTexture(LShrinkArray in, Mod srcMod) {
            this.parseData(in, srcMod);
        }

        final void parseData(LShrinkArray in, Mod srcMod) {
            int strLength = in.extractInt(4);
            this.name = in.extractString(strLength);
            this.texture.parseData((LImport)in, srcMod);
            this.index = in.extractInt(4);
        }

        void export(ModExporter out) throws IOException {
            out.write(this.name.length());
            out.write(this.name);
            this.texture.export(out);
            out.write(this.index);
        }

        int getTotalLength() {
            return this.name.length() + 12;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setTexture(FormID txst) {
            this.texture = txst;
        }

        public FormID getTexture() {
            return this.texture;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AltTexture other = (AltTexture)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.index == other.index;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 29 * hash + (this.texture != null ? this.texture.hashCode() : 0);
            hash = 29 * hash + this.index;
            return hash;
        }
    }
}

