/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.AltTextures;
import skyproc.BodyTemplate;
import skyproc.DestructionData;
import skyproc.FormID;
import skyproc.KeywordSet;
import skyproc.MajorRecordDescription;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.ScriptPackage;
import skyproc.SubData;
import skyproc.SubForm;
import skyproc.SubInt;
import skyproc.SubList;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.Gender;

public class ARMO
extends MajorRecordDescription {
    static final SubPrototype ARMOprototype = new SubPrototype(MajorRecordDescription.descProto){

        @Override
        protected void addRecords() {
            this.add(new ScriptPackage());
            this.add(new SubData("OBND", new byte[12]));
            this.reposition("FULL");
            this.add(new SubForm("EITM"));
            this.add(new SubInt("EAMT", 2));
            this.add(SubString.getNew("MOD2", true));
            this.add(new SubData("MO2T"));
            this.add(new AltTextures("MO2S"));
            this.add(SubString.getNew("ICON", true));
            this.add(SubString.getNew("MICO", true));
            this.add(SubString.getNew("MOD4", true));
            this.add(new SubData("MO4T"));
            this.add(new AltTextures("MO4S"));
            this.add(SubString.getNew("ICO2", true));
            this.add(SubString.getNew("MIC2", true));
            this.add(new BodyTemplate());
            this.add(new DestructionData());
            this.add(new SubForm("YNAM"));
            this.add(new SubForm("ZNAM"));
            this.add(new SubString("BMCT"));
            this.add(new SubForm("ETYP"));
            this.add(new SubForm("BIDS"));
            this.add(new SubForm("BAMT"));
            this.add(new SubForm("RNAM"));
            this.add(new KeywordSet());
            this.reposition("DESC");
            this.add(new SubList(new SubForm("MODL")));
            this.add(new DATA());
            this.add(new SubData("DNAM"));
            this.add(new SubForm("TNAM"));
        }
    };

    ARMO() {
        this.subRecords.setPrototype(ARMOprototype);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("ARMO");
    }

    @Override
    Record getNew() {
        return new ARMO();
    }

    public KeywordSet getKeywordSet() {
        return this.subRecords.getKeywords();
    }

    public ArrayList<FormID> getArmatures() {
        return this.subRecords.getSubList("MODL").toPublic();
    }

    public void addArmature(FormID id) {
        this.subRecords.getSubList("MODL").add(id);
    }

    public void removeArmature(FormID id) {
        this.subRecords.getSubList("MODL").remove(id);
    }

    public void setEnchantment(FormID id) {
        this.subRecords.setSubForm("EITM", id);
    }

    public FormID getEnchantment() {
        return this.subRecords.getSubForm("EITM").getForm();
    }

    String getAltTexType(Gender gender) {
        switch (gender) {
            case MALE: {
                return "MO2S";
            }
        }
        return "MO4S";
    }

    public ArrayList<AltTextures.AltTexture> getAltTextures(Gender gender) {
        AltTextures t = (AltTextures)this.subRecords.get(this.getAltTexType(gender));
        return t.altTextures;
    }

    public boolean equalAltTextures(ARMO rhs, Gender gender) {
        return AltTextures.equal(this.getAltTextures(gender), rhs.getAltTextures(gender));
    }

    public void setModel(String path, Gender g) {
        switch (g) {
            case MALE: {
                this.subRecords.setSubString("MOD2", path);
                break;
            }
            case FEMALE: {
                this.subRecords.setSubString("MOD4", path);
            }
        }
    }

    public String getModel(Gender g) {
        switch (g) {
            case MALE: {
                return this.subRecords.getSubString("MOD2").print();
            }
        }
        return this.subRecords.getSubString("MOD4").print();
    }

    public void setPickupSound(FormID sound) {
        this.subRecords.setSubForm("YNAM", sound);
    }

    public FormID getPickupSound() {
        return this.subRecords.getSubForm("YNAM").getForm();
    }

    public void setDropSound(FormID sound) {
        this.subRecords.setSubForm("ZNAM", sound);
    }

    public FormID getDropSound() {
        return this.subRecords.getSubForm("ZNAM").getForm();
    }

    public void setEquipSlot(FormID slot) {
        this.subRecords.setSubForm("ETYP", slot);
    }

    public FormID getEquipSet() {
        return this.subRecords.getSubForm("ETYP").getForm();
    }

    public void setBashImpactData(FormID set) {
        this.subRecords.setSubForm("BIDS", set);
    }

    public FormID getBashImpactData() {
        return this.subRecords.getSubForm("BIDS").getForm();
    }

    public void setRace(FormID race) {
        this.subRecords.setSubForm("RNAM", race);
    }

    public FormID getRace() {
        return this.subRecords.getSubForm("RNAM").getForm();
    }

    DATA getDATA() {
        return (DATA)this.subRecords.get("DATA");
    }

    public void setValue(int value) {
        this.getDATA().value = value;
    }

    public int getValue() {
        return this.getDATA().value;
    }

    public void setWeight(float weight) {
        this.getDATA().weight = weight;
    }

    public float getWeight() {
        return this.getDATA().weight;
    }

    public void setArmorRatingFloat(float rating) {
        this.subRecords.setSubData("DNAM", (int)rating * 100);
    }

    public float getArmorRatingFloat() {
        return (float)((double)this.subRecords.getSubData("DNAM").toInt() / 100.0);
    }

    public void setArmorRating(int rating) {
        this.subRecords.setSubData("DNAM", rating);
    }

    public int getArmorRating() {
        return this.subRecords.getSubData("DNAM").toInt();
    }

    public void setTemplate(FormID template) {
        if (template.isNull()) {
            FormID formID = this.subRecords.getSubForm("TNAM").getForm();
        }
        this.subRecords.setSubForm("TNAM", template);
    }

    public FormID getTemplate() {
        return this.subRecords.getSubForm("TNAM").getForm();
    }

    public ScriptPackage getScriptPackage() {
        return this.subRecords.getScripts();
    }

    public BodyTemplate getBodyTemplate() {
        return this.subRecords.getBodyTemplate();
    }

    public boolean isTemplated() {
        return !this.getTemplate().isNull();
    }

    public FormID getAlternateBlockMaterial() {
        return this.subRecords.getSubForm("BAMT").getForm();
    }

    public void setAlternateBlockMaterial(FormID materialFormID) {
        this.subRecords.setSubForm("BAMT", materialFormID);
    }

    public void updateBodyTemplate() {
        this.getBodyTemplate().makeBod2(this);
    }

    static class DATA
    extends SubRecord {
        int value;
        float weight;

        DATA() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.value);
            out.write(this.weight);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.value = in.extractInt(4);
            this.weight = in.extractFloat();
            if (SPGlobal.logMods) {
                DATA.logMod(srcMod, "", "Value: " + this.value + ", weight " + this.weight);
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 8;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }
}

