/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.AltTextures;
import skyproc.BodyTemplate;
import skyproc.FormID;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.SubData;
import skyproc.SubForm;
import skyproc.SubList;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.Gender;
import skyproc.genenums.Perspective;

public class ARMA
extends MajorRecord {
    static final SubPrototype ARMAprototype = new SubPrototype(MajorRecord.majorProto){

        @Override
        protected void addRecords() {
            this.add(new BodyTemplate());
            this.add(new SubForm("RNAM"));
            this.add(new DNAM());
            this.add(SubString.getNew("MOD2", true));
            this.add(new SubList(new SubData("MO2T")));
            this.add(new AltTextures("MO2S"));
            this.add(SubString.getNew("MOD3", true));
            this.add(new SubList(new SubData("MO3T")));
            this.add(new AltTextures("MO3S"));
            this.add(SubString.getNew("MOD4", true));
            this.add(new SubList(new SubData("MO4T")));
            this.add(new AltTextures("MO4S"));
            this.add(SubString.getNew("MOD5", true));
            this.add(new SubList(new SubData("MO5T")));
            this.add(new AltTextures("MO5S"));
            this.add(new SubForm("NAM0"));
            this.add(new SubForm("NAM1"));
            this.add(new SubForm("NAM2"));
            this.add(new SubForm("NAM3"));
            this.add(new SubList(new SubForm("MODL")));
            this.add(new SubForm("SNDD"));
            this.add(new SubForm("ONAM"));
        }
    };

    ARMA() {
        this.subRecords.setPrototype(ARMAprototype);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("ARMA");
    }

    @Override
    Record getNew() {
        return new ARMA();
    }

    String getModelPathType(Gender gender, Perspective perspective) {
        switch (gender) {
            case MALE: {
                switch (perspective) {
                    case THIRD_PERSON: {
                        return "MOD2";
                    }
                    case FIRST_PERSON: {
                        return "MOD4";
                    }
                }
            }
            case FEMALE: {
                switch (perspective) {
                    case THIRD_PERSON: {
                        return "MOD3";
                    }
                    case FIRST_PERSON: {
                        return "MOD5";
                    }
                }
            }
        }
        return "MOD2";
    }

    public void setModelPath(String path, Gender gender, Perspective perspective) {
        this.subRecords.setSubString(this.getModelPathType(gender, perspective), path);
    }

    public String getModelPath(Gender gender, Perspective perspective) {
        return this.subRecords.getSubString(this.getModelPathType(gender, perspective)).print();
    }

    String getAltTexType(Gender gender, Perspective perspective) {
        switch (gender) {
            case MALE: {
                switch (perspective) {
                    case THIRD_PERSON: {
                        return "MO2S";
                    }
                    case FIRST_PERSON: {
                        return "MO4S";
                    }
                }
            }
        }
        switch (perspective) {
            case THIRD_PERSON: {
                return "MO3S";
            }
        }
        return "MO5S";
    }

    public ArrayList<AltTextures.AltTexture> getAltTextures(Gender gender, Perspective perspective) {
        AltTextures t = (AltTextures)this.subRecords.get(this.getAltTexType(gender, perspective));
        return t.altTextures;
    }

    public boolean equalAltTextures(ARMA rhs, Gender gender, Perspective perspective) {
        return AltTextures.equal(this.getAltTextures(gender, perspective), rhs.getAltTextures(gender, perspective));
    }

    public void setRace(FormID race) {
        this.subRecords.setSubForm("RNAM", race);
    }

    public FormID getRace() {
        return this.subRecords.getSubForm("RNAM").getForm();
    }

    public void setSkinTexture(FormID skin, Gender gender) {
        switch (gender) {
            case MALE: {
                this.subRecords.setSubForm("NAM0", skin);
                return;
            }
            case FEMALE: {
                this.subRecords.setSubForm("NAM1", skin);
                return;
            }
        }
    }

    public FormID getSkinTexture(Gender gender) {
        switch (gender) {
            case MALE: {
                return this.subRecords.getSubForm("NAM0").getForm();
            }
        }
        return this.subRecords.getSubForm("NAM1").getForm();
    }

    public void setSkinSwap(FormID swapList, Gender gender) {
        switch (gender) {
            case MALE: {
                this.subRecords.getSubForm("NAM2").setForm(swapList);
                return;
            }
            case FEMALE: {
                this.subRecords.getSubForm("NAM3").setForm(swapList);
            }
        }
    }

    public FormID getSkinSwap(Gender gender) {
        switch (gender) {
            case MALE: {
                return this.subRecords.getSubForm("NAM2").getForm();
            }
        }
        return this.subRecords.getSubForm("NAM3").getForm();
    }

    public void addAdditionalRace(FormID addRace) {
        this.subRecords.getSubList("MODL").add(addRace);
    }

    public void removeAdditionalRace(FormID addRace) {
        this.subRecords.getSubList("MODL").remove(addRace);
    }

    public ArrayList<FormID> getAdditionalRaces() {
        return this.subRecords.getSubList("MODL").toPublic();
    }

    public void clearAdditionalRaces() {
        this.subRecords.getSubList("MODL").clear();
    }

    public void setFootstepSound(FormID footstep) {
        this.subRecords.setSubForm("SNDD", footstep);
    }

    public FormID getFootstepSound() {
        return this.subRecords.getSubForm("SNDD").getForm();
    }

    DNAM getDNAM() {
        return (DNAM)this.subRecords.get("DNAM");
    }

    public void setPriority(int priority, Gender gender) {
        switch (gender) {
            case MALE: {
                this.getDNAM().malePriority = priority;
                return;
            }
            case FEMALE: {
                this.getDNAM().femalePriority = priority;
                return;
            }
        }
    }

    public int getPriority(Gender gender) {
        switch (gender) {
            case MALE: {
                return this.getDNAM().malePriority;
            }
        }
        return this.getDNAM().femalePriority;
    }

    public void setDetectionSoundValue(int value) {
        this.getDNAM().detectionSoundValue = value;
    }

    public int getDetectionSoundValue() {
        return this.getDNAM().detectionSoundValue;
    }

    public void setWeaponAdjust(float adjust) {
        this.getDNAM().weaponAdjust = adjust;
    }

    public float getWeaponAdjust() {
        return this.getDNAM().weaponAdjust;
    }

    public BodyTemplate getBodyTemplate() {
        return this.subRecords.getBodyTemplate();
    }

    static final class DNAM
    extends SubRecord {
        int malePriority;
        int femalePriority;
        byte[] unknown;
        int detectionSoundValue;
        byte[] unknown2;
        float weaponAdjust;

        DNAM() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.malePriority, 1);
            out.write(this.femalePriority, 1);
            out.write(this.unknown, 4);
            out.write(this.detectionSoundValue, 1);
            out.write(this.unknown2, 1);
            out.write(this.weaponAdjust);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.malePriority = in.extractInt(1);
            this.femalePriority = in.extractInt(1);
            this.unknown = in.extract(4);
            this.detectionSoundValue = in.extractInt(1);
            this.unknown2 = in.extract(1);
            this.weaponAdjust = in.extractFloat();
            if (SPGlobal.logMods) {
                DNAM.logMod(srcMod, "", "M-Priority: " + this.malePriority + ", F-Priority: " + this.femalePriority + ", DetectionValue: " + this.detectionSoundValue + ", weaponAdjust: " + this.weaponAdjust);
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new DNAM();
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 12;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DNAM");
        }
    }
}

