/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.AltTextures;
import skyproc.DestructionData;
import skyproc.FormID;
import skyproc.KeywordSet;
import skyproc.MajorRecordDescription;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.Record;
import skyproc.SubData;
import skyproc.SubForm;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class AMMO
extends MajorRecordDescription {
    static final SubPrototype AMMOprototype = new SubPrototype(MajorRecordDescription.descProto){

        @Override
        protected void addRecords() {
            this.add(new SubData("OBND", new byte[12]));
            this.reposition("FULL");
            this.add(new Model());
            this.add(new SubString("ICON"));
            this.add(new SubString("MICO"));
            this.add(new DestructionData());
            this.add(new SubForm("YNAM"));
            this.add(new SubForm("ZNAM"));
            this.reposition("DESC");
            this.add(new KeywordSet());
            this.add(new DATA());
            this.add(SubString.getNew("ONAM", true));
        }
    };

    AMMO() {
        this.subRecords.setPrototype(AMMOprototype);
    }

    @Override
    Record getNew() {
        return new AMMO();
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("AMMO");
    }

    public KeywordSet getKeywordSet() {
        return this.subRecords.getKeywords();
    }

    public void setModel(String path) {
        this.subRecords.getModel().setFileName(path);
    }

    public String getModel() {
        return this.subRecords.getModel().getFileName();
    }

    public void setPickupSound(FormID sound) {
        this.subRecords.setSubForm("YNAM", sound);
    }

    public FormID getPickupSound() {
        return this.subRecords.getSubForm("YNAM").getForm();
    }

    public void setDropSound(FormID sound) {
        this.subRecords.setSubForm("ZNAM", sound);
    }

    public FormID getDropSound() {
        return this.subRecords.getSubForm("ZNAM").getForm();
    }

    DATA getData() {
        return (DATA)this.subRecords.get("DATA");
    }

    public void setProjectile(FormID projectile) {
        this.getData().projectile = projectile;
    }

    public FormID getProjectile() {
        return this.getData().projectile;
    }

    public void set(AMMOFlag flag, boolean on) {
        this.getData().flags.set(flag.ordinal(), on);
    }

    public boolean get(AMMOFlag flag) {
        return this.getData().flags.get(flag.ordinal());
    }

    public void setDamage(float damage) {
        this.getData().damage = damage;
    }

    public float getDamage() {
        return this.getData().damage;
    }

    public void setValue(int gold) {
        this.getData().value = gold;
    }

    public int getValue() {
        return this.getData().value;
    }

    public ArrayList<AltTextures.AltTexture> getAltTextures() {
        return this.subRecords.getModel().getAltTextures();
    }

    public Model getModelData() {
        return this.subRecords.getModel();
    }

    public static enum AMMOFlag {
        IgnoresWeaponResistance,
        NonPlayable,
        NonBolt;

    }

    static final class DATA
    extends SubRecord {
        FormID projectile = new FormID();
        LFlags flags = new LFlags(1);
        float damage = 0.0f;
        int value = 0;

        DATA() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            this.projectile.export(out);
            out.write(this.flags.export(), 4);
            out.write(this.damage);
            out.write(this.value);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.projectile.parseData(in, srcMod);
            this.flags.set(in.extract(4));
            this.damage = in.extractFloat();
            this.value = in.extractInt(4);
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 16;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(1);
            out.add(this.projectile);
            return out;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }
}

