/*
 * Decompiled with CFR 0.152.
 */
package skyprocstarter;

import skyproc.ARMO;
import skyproc.COBJ;
import skyproc.Condition;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.WEAP;
import skyprocstarter.Etch;
import skyprocstarter.Forms;

public final class Recipe {
    private Recipe() {
        new AssertionError();
    }

    public static void makeWeapon(Mod patch, WEAP weapon, int materialType, WEAP newWeapon) {
        COBJ recipe = Recipe.makeItem(weapon.getForm(), materialType, 1, newWeapon.getForm(), newWeapon.getEDID(), Forms.BENCH_FORGE);
        if (recipe != null) {
            patch.addRecord(recipe);
        }
        int bestMaterialType = Etch.getBestMaterialType(newWeapon.getKeywordSet().getKeywordRefs());
        COBJ temper = Recipe.temperItem(newWeapon.getForm(), bestMaterialType, newWeapon.getEDID(), Forms.BENCH_GRINDSTONE);
        if (temper != null) {
            patch.addRecord(temper);
        }
    }

    public static void makeArmor(Mod patch, ARMO armor, int materialType, ARMO newArmor) {
        COBJ recipe = Recipe.makeItem(armor.getForm(), materialType, 2, newArmor.getForm(), newArmor.getEDID(), Forms.BENCH_FORGE);
        if (recipe != null) {
            patch.addRecord(recipe);
        }
        int bestMaterialType = Etch.getBestMaterialType(newArmor.getKeywordSet().getKeywordRefs());
        COBJ temper = Recipe.temperItem(newArmor.getForm(), bestMaterialType, newArmor.getEDID(), Forms.BENCH_TABLE);
        if (temper != null) {
            patch.addRecord(temper);
        }
    }

    private static COBJ makeItem(FormID oldItem, int materialType, int quantity, FormID newItem, String newItemEDID, FormID bench) {
        COBJ recipe = new COBJ("EtchRecipe" + newItemEDID);
        switch (materialType) {
            case 0: {
                Recipe.configureRecipe(recipe, Forms.INGOT_SILVER, quantity, oldItem, Forms.PERK_STEEL);
                break;
            }
            case 1: {
                Recipe.configureRecipe(recipe, Forms.INGOT_ORICHALCUM, quantity, oldItem, Forms.PERK_ORCISH);
                break;
            }
            case 2: {
                Recipe.configureRecipe(recipe, Forms.INGOT_MALACHITE, quantity, oldItem, Forms.PERK_GLASS);
                break;
            }
            case 3: {
                Recipe.configureRecipe(recipe, Forms.INGOT_EBONY, quantity, oldItem, Forms.PERK_EBONY);
                break;
            }
            case 4: {
                Recipe.configureRecipe(recipe, Forms.DRAGON_SCALE, quantity, oldItem, Forms.PERK_DRAGON);
                break;
            }
            case 5: {
                Recipe.configureRecipe(recipe, Forms.DRAGON_BONE, quantity, oldItem, Forms.PERK_DRAGON);
                break;
            }
            case 6: {
                Recipe.configureRecipe(recipe, Forms.DAEDRA_HEART, quantity, oldItem, Forms.PERK_DAEDRIC);
                break;
            }
            default: {
                return null;
            }
        }
        recipe.setResultFormID(newItem);
        recipe.setOutputQuantity(1);
        recipe.setBenchKeywordFormID(bench);
        return recipe;
    }

    private static COBJ temperItem(FormID newItem, int bestMaterialType, String newItemEDID, FormID bench) {
        COBJ recipe = new COBJ("EtchTemper" + newItemEDID);
        Recipe.configureRecipe(recipe, Etch.TEMPER_BEST_MATERIAL[bestMaterialType], 1, null, Etch.TEMPER_BEST_PERK[bestMaterialType]);
        recipe.setResultFormID(newItem);
        recipe.setOutputQuantity(1);
        recipe.setBenchKeywordFormID(bench);
        return recipe;
    }

    private static void configureRecipe(COBJ recipe, FormID ingredient1, int quantity, FormID ingredient2, FormID perk) {
        recipe.addIngredient(ingredient1, quantity);
        if (ingredient2 != null) {
            recipe.addIngredient(ingredient2, 1);
        }
        Condition c1 = new Condition(Condition.P_FormID.HasPerk, perk);
        c1.setOperator(Condition.Operator.EqualTo);
        c1.setRunOnType(Condition.RunOnType.Subject);
        c1.setValue(1.0f);
        recipe.addCondition(c1);
        if (ingredient2 != null) {
            Condition c2 = new Condition(Condition.P_FormID.GetItemCount, ingredient2);
            c2.setOperator(Condition.Operator.GreaterThanOrEqual);
            c2.setRunOnType(Condition.RunOnType.Subject);
            c2.setValue(1.0f);
            recipe.addCondition(c2);
        }
    }
}

