/*
 * Decompiled with CFR 0.152.
 */
package skyproc.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import lev.gui.LButton;
import lev.gui.LTextPane;
import skyproc.gui.SPMainMenuPanel;
import skyproc.gui.SPSettingPanel;
import skyproc.gui.SUMGUI;

public abstract class SPQuestionPanel
extends SPSettingPanel {
    protected LTextPane question;
    protected LButton cancelButton;
    protected SPSettingPanel cancelPanel;
    protected LButton backButton;
    protected SPSettingPanel backPanel;
    protected LButton nextButton;
    protected SPSettingPanel nextPanel;

    public SPQuestionPanel(SPMainMenuPanel parent_, String title, Color headerColor, SPSettingPanel cancel, SPSettingPanel back) {
        super(parent_, title, headerColor);
        this.cancelPanel = cancel;
        this.backPanel = back;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.question = new LTextPane(this.settingsPanel.getWidth() - 20, 20, SUMGUI.light);
        this.question.setEditable(false);
        this.question.centerIn((Component)this.settingsPanel, this.header.getBottom() + 10);
        this.settingsPanel.add((Component)this.question);
        this.last = new Point(this.last.x, this.question.getBottom());
        this.cancelButton = new LButton("Cancel");
        this.cancelButton.setLocation(15, this.settingsPanel.getHeight() - this.cancelButton.getHeight() - 10);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int answer;
                if (SPQuestionPanel.this.testCancel() && (answer = JOptionPane.showConfirmDialog(null, "Are you sure you want to cancel?", "Confirm Cancel", 0)) == 0) {
                    SPQuestionPanel.this.onCancel();
                    SPQuestionPanel.this.cancelPanel.open();
                }
            }
        });
        this.settingsPanel.add((Component)this.cancelButton);
        this.backButton = new LButton("Back");
        this.backButton.setLocation(this.settingsPanel.getWidth() / 2 - this.backButton.getWidth() / 2, this.settingsPanel.getHeight() - this.backButton.getHeight() - 10);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SPQuestionPanel.this.testBack()) {
                    SPQuestionPanel.this.onBack();
                    SPQuestionPanel.this.backPanel.open();
                }
            }
        });
        this.settingsPanel.add((Component)this.backButton);
        this.nextButton = new LButton("Next");
        this.nextButton.setLocation(this.settingsPanel.getWidth() - this.nextButton.getWidth() - 15, this.settingsPanel.getHeight() - this.cancelButton.getHeight() - 10);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SPQuestionPanel.this.testNext()) {
                    SPQuestionPanel.this.onNext();
                    SPQuestionPanel.this.nextPanel.open();
                }
            }
        });
        this.settingsPanel.add((Component)this.nextButton);
        this.setCancel(this.cancelPanel);
        this.setBack(this.backPanel);
        this.setNext(this.nextPanel);
    }

    public void setCancel(SPSettingPanel in) {
        this.cancelPanel = in;
        this.cancelButton.setVisible(in != null);
    }

    public void setBack(SPSettingPanel in) {
        this.backPanel = in;
        this.backButton.setVisible(in != null);
    }

    public void setNext(SPSettingPanel in) {
        this.nextPanel = in;
        this.nextButton.setVisible(in != null);
    }

    public boolean testCancel() {
        return true;
    }

    public boolean testBack() {
        return true;
    }

    public boolean testNext() {
        return true;
    }

    public void onCancel() {
    }

    public void onBack() {
    }

    public void onNext() {
    }

    public void setQuestionFont(Font f) {
        this.question.setFont(f);
    }

    public void setQuestionCentered() {
        this.question.setCentered();
    }

    public void setQuestionColor(Color c) {
        this.question.setForeground(c);
    }

    public void setQuestionText(String t) {
        this.question.setText(t);
        this.question.setSize(this.question.getWidth(), (int)this.question.getPreferredSize().getHeight());
        this.updateLast((Component)this.question);
    }

    public String getQuestionText() {
        return this.question.getText();
    }
}

