/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.util.ArrayList;
import java.util.Iterator;
import skyproc.MajorRecord;
import skyproc.Record;
import skyproc.SubData;
import skyproc.SubFlag;
import skyproc.SubPrototype;
import skyproc.SubString;

public class TXST
extends MajorRecord
implements Iterable<String> {
    static final SubPrototype TXSTproto = new SubPrototype(MajorRecord.majorProto){

        @Override
        protected void addRecords() {
            this.add(new SubData("OBND", new byte[12]));
            this.add(SubString.getNew("TX00", true));
            this.add(SubString.getNew("TX01", true));
            this.add(SubString.getNew("TX02", true));
            this.add(SubString.getNew("TX03", true));
            this.add(SubString.getNew("TX04", true));
            this.add(SubString.getNew("TX05", true));
            this.add(SubString.getNew("TX06", true));
            this.add(SubString.getNew("TX07", true));
            this.add(new SubData("DODT"));
            this.add(new SubFlag("DNAM", 2));
        }
    };
    static int NUM_MAPS = 8;

    public TXST(String edid) {
        this();
        this.originateFromPatch(edid);
    }

    TXST() {
        this.subRecords.setPrototype(TXSTproto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("TXST");
    }

    @Override
    Record getNew() {
        return new TXST();
    }

    public void setNthMap(int i, String path) {
        SubString map = this.getNthMapInternal(i);
        if (map != null) {
            map.setString(path);
        }
    }

    SubString getNthMapInternal(int i) {
        switch (i) {
            case 0: {
                return this.subRecords.getSubString("TX00");
            }
            case 1: {
                return this.subRecords.getSubString("TX01");
            }
            case 2: {
                return this.subRecords.getSubString("TX02");
            }
            case 3: {
                return this.subRecords.getSubString("TX03");
            }
            case 4: {
                return this.subRecords.getSubString("TX04");
            }
            case 5: {
                return this.subRecords.getSubString("TX05");
            }
            case 6: {
                return this.subRecords.getSubString("TX06");
            }
            case 7: {
                return this.subRecords.getSubString("TX07");
            }
        }
        return null;
    }

    public String getNthMap(int i) {
        SubString map = this.getNthMapInternal(i);
        if (map != null) {
            return map.print();
        }
        return "";
    }

    public void setColorMap(String path) {
        this.setNthMap(0, path);
    }

    public String getColorMap() {
        return this.getNthMap(0);
    }

    public void setNormalMap(String path) {
        this.setNthMap(1, path);
    }

    public String getNormalMap() {
        return this.getNthMap(1);
    }

    public void setMaskMap(String path) {
        this.setNthMap(2, path);
    }

    public String getMaskMap() {
        return this.getNthMap(2);
    }

    public void setToneMap(String path) {
        this.setNthMap(3, path);
    }

    public String getToneMap() {
        return this.getNthMap(3);
    }

    public void setDetailMap(String path) {
        this.setNthMap(4, path);
    }

    public String getDetailMap() {
        return this.getNthMap(4);
    }

    public void setEnvironmentMap(String path) {
        this.setNthMap(5, path);
    }

    public String getEnvironmentMap() {
        return this.getNthMap(5);
    }

    public void setSpecularityMap(String path) {
        this.setNthMap(7, path);
    }

    public String getSpecularityMap() {
        return this.getNthMap(7);
    }

    public boolean get(TXSTflag flag) {
        return this.subRecords.getSubFlag("DNAM").is(flag.ordinal());
    }

    public void set(TXSTflag flag, boolean to) {
        this.subRecords.setSubFlag("DNAM", flag.ordinal(), to);
    }

    public ArrayList<String> getTextures() {
        ArrayList<String> temp = new ArrayList<String>();
        int i = 0;
        while (i < NUM_MAPS) {
            temp.add(this.getNthMap(i));
            ++i;
        }
        return temp;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getTextures().iterator();
    }

    public static enum TXSTflag {
        SPECULAR_MAP_OFF,
        FACEGEN_TEXTURES;

    }
}

