/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import skyproc.FormID;
import skyproc.ModExporter;
import skyproc.Record;

abstract class SubRecord<T>
extends Record {
    SubRecord() {
    }

    @Override
    public String print() {
        return "No " + this.getType().toString();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getType().toString()) + "[" + this.getClass().getSimpleName() + "]";
    }

    @Override
    int getSizeLength() {
        return 2;
    }

    @Override
    int getFluffLength() {
        return 0;
    }

    @Override
    void export(ModExporter out) throws IOException {
        out.write(this.getType().toString());
        out.write(this.getContentLength(out), this.getSizeLength());
    }

    abstract SubRecord getNew(String var1);

    boolean confirmLink() {
        return true;
    }

    ArrayList<FormID> allFormIDs() {
        return new ArrayList<FormID>(0);
    }

    T translate() {
        return (T)this;
    }

    SubRecord<T> translate(T in) {
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubRecord other = (SubRecord)obj;
        if (!other.getType().equals(this.getType())) {
            return false;
        }
        return this.subRecordEquals(other);
    }

    boolean subRecordEquals(SubRecord subRecord) {
        throw new UnsupportedOperationException("Equals functionality not yet supported for subrecord: " + this.getClass().getSimpleName());
    }

    @Override
    Record getNew() {
        return this.getNew("NULL");
    }
}

