/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.RGBA;
import skyproc.SPGlobal;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubRGBshort
extends SubRecordTyped {
    short r;
    short g;
    short b;
    short a;

    SubRGBshort(String type, short red, short green, short blue, short alpha) {
        this(type);
        this.r = red;
        this.g = green;
        this.b = blue;
    }

    SubRGBshort(String type) {
        super(type);
    }

    @Override
    SubRecord getNew(String type) {
        return new SubRGBshort(type);
    }

    @Override
    int getContentLength(ModExporter out) {
        return 4;
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.r = (short)in.extractInt(1);
        this.g = (short)in.extractInt(1);
        this.b = (short)in.extractInt(1);
        this.a = (short)in.extractInt(1);
        if (SPGlobal.logMods) {
            SubRGBshort.logMod(srcMod, this.toString(), "Setting " + this.toString() + " to : " + this.print());
        }
    }

    @Override
    public String print() {
        return "R: " + this.r + " G: " + this.g + " B: " + this.b + " A: " + this.a;
    }

    @Override
    void export(ModExporter out) throws IOException {
        if (this.isValid()) {
            super.export(out);
            out.write(this.r, 1);
            out.write(this.g, 1);
            out.write(this.b, 1);
            out.write(this.a, 1);
        }
    }

    public void set(RGBA color, short val) {
        switch (color) {
            case Red: {
                this.r = val;
                break;
            }
            case Green: {
                this.g = val;
                break;
            }
            case Blue: {
                this.b = val;
                break;
            }
            case Alpha: {
                this.a = val;
            }
        }
    }

    public short get(RGBA color) {
        if (!this.isValid()) {
            return 0;
        }
        switch (color) {
            case Red: {
                return this.r;
            }
            case Green: {
                return this.g;
            }
            case Blue: {
                return this.b;
            }
        }
        return this.a;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.r;
        hash = 97 * hash + this.g;
        hash = 97 * hash + this.b;
        hash = 97 * hash + this.a;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubRGBshort other = (SubRGBshort)obj;
        if (this.r != other.r) {
            return false;
        }
        if (this.g != other.g) {
            return false;
        }
        if (this.b != other.b) {
            return false;
        }
        return this.a == other.a;
    }
}

