/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.Mod;
import skyproc.SubList;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubListMulti<T extends SubRecord>
extends SubList {
    Map<String, SubRecord> prototypes = new HashMap<String, SubRecord>(2);

    SubListMulti(SubRecord ... prototypes) {
        super(prototypes[0]);
        SubRecord[] subRecordArray = prototypes;
        int n = prototypes.length;
        int n2 = 0;
        while (n2 < n) {
            SubRecord s = subRecordArray[n2];
            this.prototypes.put(s.getType(), s);
            ++n2;
        }
    }

    SubListMulti(SubListMulti<T> rhs) {
        super(rhs);
        for (SubRecord s : rhs.prototypes.values()) {
            this.prototypes.put(s.getType(), s);
        }
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        this.parseData(in, srcMod, SubListMulti.getNextType(in));
    }

    @Override
    void parseData(LImport in, Mod srcMod, String nextType) throws BadRecord, DataFormatException, BadParameter {
        if (this.prototypes.containsKey(nextType)) {
            SubRecord newRecord = this.prototypes.get(nextType).getNew(nextType);
            newRecord.parseData(in, srcMod);
            this.last = newRecord;
            this.add(newRecord);
        } else {
            this.last.parseData(in, srcMod);
        }
    }

    @Override
    ArrayList<String> getTypes() {
        HashSet<String> set = new HashSet<String>();
        for (SubRecord s : this.prototypes.values()) {
            set.addAll(s.getTypes());
        }
        return new ArrayList<String>(set);
    }

    @Override
    SubRecord getNew(String type) {
        return new SubListMulti<T>(this);
    }
}

