/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.TreeSet;
import java.util.zip.DataFormatException;
import lev.LImport;
import lev.Ln;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SubForm;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubList<S extends SubRecord<T>, T>
extends SubRecord<ArrayList<S>>
implements Iterable<S> {
    ArrayList<T> collection = new ArrayList();
    S prototype;
    S last;
    boolean unique = false;

    SubList(S prototype_) {
        this.prototype = prototype_;
    }

    SubList(S prototype_, boolean unique) {
        this(prototype_);
        this.setUnique(unique);
    }

    SubList(SubList rhs) {
        this.prototype = rhs.prototype;
        this.unique = rhs.unique;
        this.collection.addAll(rhs.collection);
    }

    @Override
    int getHeaderLength() {
        return 0;
    }

    @Override
    boolean isValid() {
        return !this.collection.isEmpty();
    }

    public boolean contains(T s) {
        return this.collection.contains(s);
    }

    public T get(int i) {
        return this.collection.get(i);
    }

    public boolean add(T item) {
        if (this.allow(item)) {
            this.collection.add(item);
            return true;
        }
        return false;
    }

    boolean allow(T item) {
        return !this.unique || !this.contains(item);
    }

    public boolean addAtIndex(T item, int i) {
        if (this.allow(item)) {
            this.collection.add(i, item);
            return true;
        }
        return false;
    }

    public boolean remove(T item) {
        return this.collection.remove(item);
    }

    public void remove(int i) {
        this.collection.remove(i);
    }

    public int size() {
        return this.collection.size();
    }

    public final void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void sort() {
        TreeSet<T> sorter = new TreeSet<T>();
        sorter.addAll(this.collection);
        this.collection.clear();
        this.collection.addAll(sorter);
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    public void setRecordsTo(ArrayList<T> in) {
        this.collection = in;
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        this.parseData(in, srcMod, SubList.getNextType(in));
    }

    void parseData(LImport in, Mod srcMod, String nextType) throws BadRecord, DataFormatException, BadParameter {
        if (nextType.equals(this.getType())) {
            SubRecord newRecord = ((SubRecord)this.prototype).getNew(this.getType());
            this.last = newRecord;
            newRecord.parseData(in, srcMod);
            this.add(newRecord.translate());
        } else {
            ((Record)this.last).parseData(in, srcMod);
        }
    }

    @Override
    SubRecord getNew(String type) {
        return new SubList<S, T>(this);
    }

    @Override
    int getContentLength(ModExporter out) {
        int length = 0;
        Iterator iterator = ((ArrayList)this.translate()).iterator();
        while (iterator.hasNext()) {
            SubRecord s = (SubRecord)iterator.next();
            length += s.getTotalLength(out);
        }
        return length;
    }

    @Override
    void export(ModExporter out) throws IOException {
        if (this.isValid()) {
            Iterator iterator = ((ArrayList)this.translate()).iterator();
            while (iterator.hasNext()) {
                SubRecord s = (SubRecord)iterator.next();
                s.export(out);
            }
        }
    }

    ArrayList<T> toPublic() {
        return this.collection;
    }

    @Override
    public Iterator<S> iterator() {
        return ((ArrayList)this.translate()).iterator();
    }

    public void addAll(Collection<T> items) {
        this.collection.addAll(items);
    }

    @Override
    ArrayList<FormID> allFormIDs() {
        if (this.prototype.getClass().equals(SubForm.class)) {
            return this.collection;
        }
        ArrayList<FormID> out = new ArrayList<FormID>();
        Iterator iterator = ((ArrayList)this.translate()).iterator();
        while (iterator.hasNext()) {
            SubRecord item = (SubRecord)iterator.next();
            out.addAll(item.allFormIDs());
        }
        return out;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.collection);
        return hash;
    }

    @Override
    public int getRecordLength(LImport in) {
        return ((Record)this.prototype).getRecordLength(in);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof SubList)) {
            return false;
        }
        SubList s = (SubList)o;
        return Ln.equals(this.collection, s.collection, (boolean)true);
    }

    @Override
    ArrayList<String> getTypes() {
        return ((Record)this.prototype).getTypes();
    }

    @Override
    ArrayList<S> translate() {
        Object trans = ((SubRecord)this.prototype).translate();
        if (trans != null && this.prototype.getClass().equals(trans.getClass())) {
            return this.collection;
        }
        ArrayList<SubRecord<T>> out = new ArrayList<SubRecord<T>>(this.collection.size());
        for (T t : this.collection) {
            out.add(((SubRecord)this.prototype).translate(t));
        }
        return out;
    }

    @Override
    SubRecord<ArrayList<S>> translate(ArrayList<S> in) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

