/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.ModListing;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubFormData
extends SubRecordTyped {
    FormID ID = new FormID();
    byte[] data;

    SubFormData(String type, FormID id, byte[] data) {
        super(type);
        this.ID = id;
        this.data = data;
    }

    SubFormData(String in) {
        super(in);
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.ID.parseData(in, srcMod);
        this.setData(in.extract(4));
    }

    @Override
    int getContentLength(ModExporter out) {
        return this.data.length + this.ID.getContentLength();
    }

    @Override
    SubRecord getNew(String type_) {
        return new SubFormData(type_);
    }

    @Override
    void export(ModExporter out) throws IOException {
        super.export(out);
        this.ID.export(out);
        out.write(this.data, 0);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] in) {
        this.data = in;
    }

    @Override
    ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> out = new ArrayList<FormID>(1);
        out.add(this.ID);
        return out;
    }

    void copyForm(FormID in) {
        this.ID = new FormID(in);
    }

    public void setForm(FormID id) {
        this.ID = id;
    }

    public String getFormStr() {
        return this.ID.getArrayStr(true);
    }

    public ModListing getFormMaster() {
        return this.ID.getMaster();
    }

    FormID copyOfForm() {
        return new FormID(this.ID);
    }

    public FormID getForm() {
        return this.ID;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubFormData other = (SubFormData)obj;
        return this.ID == other.ID || this.ID != null && this.ID.equals(other.ID);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.ID != null ? this.ID.hashCode() : 0);
        return hash;
    }
}

