/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SPGlobal;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubFloat
extends SubRecordTyped {
    float data;

    SubFloat(String type) {
        super(type);
    }

    @Override
    SubRecord getNew(String type) {
        return new SubFloat(type);
    }

    @Override
    int getContentLength(ModExporter out) {
        return 4;
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.data = in.extractFloat();
        if (SPGlobal.logMods) {
            SubFloat.logMod(srcMod, this.toString(), "Setting " + this.toString() + " to : " + this.print());
        }
    }

    @Override
    public String print() {
        if (this.isValid()) {
            return String.valueOf(this.data);
        }
        return super.toString();
    }

    @Override
    void export(ModExporter out) throws IOException {
        if (this.isValid()) {
            super.export(out);
            out.write(this.data);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof SubFloat)) {
            return false;
        }
        SubFloat s = (SubFloat)o;
        return Float.compare(this.data, s.data) == 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Float.floatToIntBits(this.data);
        return hash;
    }

    public void set(float in) {
        this.data = in;
    }

    public float get() {
        return this.data;
    }
}

