/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import lev.Ln;
import lev.debug.LDebug;
import skyproc.EmbeddedScripts;
import skyproc.FormID;
import skyproc.GRUP;
import skyproc.GRUP_TYPE;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModListing;
import skyproc.NiftyFunc;
import skyproc.SPDatabase;
import skyproc.SPGlobal;
import skyproc.SPImporter;
import skyproc.SubStringPointer;
import skyproc.exceptions.BadMod;
import skyproc.exceptions.BadRecord;
import skyproc.gui.SPDefaultGUI;
import skyproc.gui.SPProgressBarPlug;

public class SkyProcTester {
    static ArrayList<FormID> badIDs;
    static GRUP_TYPE[] types;
    static boolean streaming;
    static ArrayList<GRUP_TYPE> skip;

    static {
        types = GRUP_TYPE.values();
        streaming = false;
        skip = new ArrayList<GRUP_TYPE>(Arrays.asList(GRUP_TYPE.BOOK));
    }

    public static void runTests(int test) {
        SkyProcTester.setSkyProcGlobal();
        badIDs = new ArrayList();
        ModListing skyrim = new ModListing("Skyrim.esm");
        badIDs.add(new FormID("018A45", skyrim));
        badIDs.add(new FormID("00001E", skyrim));
        SPGlobal.testing = true;
        SPDefaultGUI gui = new SPDefaultGUI("Tester Program", "A tester program meant to flex SkyProc.");
        try {
            switch (test) {
                case 1: {
                    SkyProcTester.validateAll();
                    break;
                }
                case 2: {
                    SkyProcTester.importTest();
                    break;
                }
                case 3: {
                    SkyProcTester.copyTest();
                }
            }
            gui.finished();
        }
        catch (Exception e) {
            System.out.println("EXCEPTION THROWN");
            gui.finished();
            SPGlobal.logException(e);
        }
        LDebug.wrapUp();
    }

    private static void validateAll() throws Exception {
        ModTestPackage[] mods = new ModTestPackage[]{new ModTestPackage("Skyrim.esm", "Skyrim.esm", "Update.esm"), new ModTestPackage("Dawnguard.esm", "Skyrim.esm", "Update.esm", "Dawnguard.esm"), new ModTestPackage("Dragonborn.esm", "Skyrim.esm", "Update.esm", "Dragonborn.esm")};
        SPGlobal.checkMissingMasters = false;
        ModTestPackage[] modTestPackageArray = mods;
        int n = mods.length;
        int n2 = 0;
        while (n2 < n) {
            ModTestPackage p = modTestPackageArray[n2];
            if (!SkyProcTester.validate(p)) break;
            ++n2;
        }
        System.out.println("TESTING COMPLETE");
    }

    private static boolean validate(ModTestPackage p) throws Exception {
        SubStringPointer.shortNull = false;
        FormID.allIDs.clear();
        SPProgressBarPlug.reset();
        SPProgressBarPlug.setMax(types.length);
        boolean exportPass = true;
        boolean idPass = true;
        GRUP_TYPE[] gRUP_TYPEArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            GRUP_TYPE g = gRUP_TYPEArray[n2];
            if (!(GRUP_TYPE.unfinished(g) || GRUP_TYPE.internal(g) || skip.contains((Object)g))) {
                ModListing[] modListingArray = p.importList;
                int n3 = p.importList.length;
                int n4 = 0;
                while (n4 < n3) {
                    ModListing m = modListingArray[n4];
                    SPImporter.importMod(m, SPGlobal.pathToData, g);
                    ++n4;
                }
                if (!SkyProcTester.test(g, p)) {
                    SPProgressBarPlug.setStatus("FAILED: " + (Object)((Object)g));
                    exportPass = false;
                    break;
                }
                SPProgressBarPlug.setStatus("Validating DONE");
                for (FormID id : FormID.allIDs) {
                    if (id.isNull() || id.getMaster() != null || badIDs.contains(id)) continue;
                    System.out.println("A bad id: " + id);
                    System.out.println("Some FormIDs were unstandardized!!");
                    return false;
                }
                SPGlobal.reset();
            }
            ++n2;
        }
        SPGlobal.reset();
        return exportPass && idPass;
    }

    private static boolean test(GRUP_TYPE type, ModTestPackage p) throws IOException, BadRecord, BadMod {
        System.out.println("Testing " + (Object)((Object)type) + " in " + p.main);
        SPProgressBarPlug.setStatus("Validating " + (Object)((Object)type));
        SPProgressBarPlug.pause(true);
        boolean passed = true;
        Mod patch = new Mod(new ModListing("Test.esp"));
        patch.setFlag(Mod.Mod_Flags.STRING_TABLED, false);
        SPGlobal.getDB();
        patch.addAsOverrides(SPDatabase.getMod(p.main), type);
        if (SPGlobal.streamMode && type != GRUP_TYPE.NPC_) {
            GRUP g = patch.GRUPs.get((Object)type);
            if (!g.listRecords.isEmpty()) {
                MajorRecord m = (MajorRecord)g.listRecords.get(0);
                if (m.subRecords.map.size() > 2) {
                    System.out.println("Premature streaming occured: " + m);
                    return false;
                }
            }
        }
        for (FormID f : badIDs) {
            patch.remove(f);
        }
        patch.setAuthor("Leviathan1753");
        ModListing[] modListingArray = p.importList;
        int n = p.importList.length;
        int n2 = 0;
        while (n2 < n) {
            ModListing depend = modListingArray[n2];
            patch.addMaster(depend);
            ++n2;
        }
        try {
            patch.export(new File(String.valueOf(SPGlobal.pathToData) + patch.getName()));
        }
        catch (BadRecord ex) {
            SPGlobal.logException(ex);
            System.out.println("Record Lengths were off.");
        }
        passed = passed && NiftyFunc.validateRecordLengths(String.valueOf(SPGlobal.pathToData) + "Test.esp", 10);
        File validF = new File("Validation Files/" + type.toString() + "_" + p.main.printNoSuffix() + ".esp");
        if (validF.isFile()) {
            passed = Ln.validateCompare((String)(String.valueOf(SPGlobal.pathToData) + "Test.esp"), (String)validF.getPath(), (int)10) && passed;
        } else {
            System.out.println("Didn't have a source file to validate bytes to.");
        }
        SPProgressBarPlug.pause(false);
        SPProgressBarPlug.incrementBar();
        return passed;
    }

    private static boolean copyTest() throws IOException, BadRecord {
        SPProgressBarPlug.pause(true);
        boolean passed = true;
        Mod merger = new Mod(new ModListing("tmpMerge.esp"));
        merger.addAsOverrides(SPGlobal.getDB(), new GRUP_TYPE[0]);
        for (FormID f : badIDs) {
            merger.remove(f);
        }
        Mod patch = new Mod(new ModListing("Test.esp"));
        patch.setFlag(Mod.Mod_Flags.STRING_TABLED, false);
        patch.setAuthor("Leviathan1753");
        for (GRUP g : merger) {
            for (Object o : g) {
                MajorRecord m = (MajorRecord)o;
                m.copyOf(patch);
            }
        }
        patch.export(new File(String.valueOf(SPGlobal.pathToData) + patch.getName()));
        passed = passed && NiftyFunc.validateRecordLengths(String.valueOf(SPGlobal.pathToData) + "Test.esp", 10);
        SPProgressBarPlug.pause(false);
        SPProgressBarPlug.incrementBar();
        return passed;
    }

    public static void importTest() {
        try {
            SPImporter importer = new SPImporter();
            SPImporter.importActiveMods();
            Mod patch = new Mod(new ModListing("Test.esp"));
            patch.setFlag(Mod.Mod_Flags.STRING_TABLED, false);
            patch.addAsOverrides(SPGlobal.getDB(), new GRUP_TYPE[0]);
            patch.allFormIDs();
        }
        catch (Exception e) {
            SPGlobal.logException(e);
        }
    }

    public static void parseEmbeddedScripts() {
        try {
            EmbeddedScripts.generateEnums();
        }
        catch (IOException ex) {
            SPGlobal.logException(ex);
        }
    }

    private static void setSkyProcGlobal() {
        SPGlobal.createGlobalLog();
        LDebug.timeElapsed = true;
        SPGlobal.streamMode = streaming;
        SPGlobal.logging(true);
        SPGlobal.setGlobalPatch(new Mod(new ModListing("Test", false)));
    }

    private static class ModTestPackage {
        ModListing main;
        ModListing[] importList;

        public ModTestPackage(String main, String ... list) {
            this.main = new ModListing(main);
            this.importList = new ModListing[list.length];
            int i = 0;
            while (i < list.length) {
                this.importList[i] = new ModListing(list[i]);
                ++i;
            }
        }
    }
}

