/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.ScriptRef;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class ScriptPackage
extends SubRecord
implements Serializable {
    int version = 5;
    int unknown = 2;
    ArrayList<ScriptRef> scripts = new ArrayList();
    SubRecord fragments;

    ScriptPackage() {
    }

    ScriptPackage(SubRecord fragments) {
        this.fragments = fragments;
    }

    @Override
    SubRecord getNew(String type) {
        if (this.fragments != null) {
            return new ScriptPackage(this.fragments.getNew(type));
        }
        return new ScriptPackage();
    }

    @Override
    boolean isValid() {
        return this.scripts.size() > 0;
    }

    @Override
    int getContentLength(ModExporter out) {
        int len = 6;
        for (ScriptRef s : this.scripts) {
            len += s.getTotalLength(out);
        }
        if (this.fragments != null) {
            len += this.fragments.getContentLength(out);
        }
        return len;
    }

    @Override
    ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> out = new ArrayList<FormID>(2);
        for (ScriptRef s : this.scripts) {
            out.addAll(s.allFormIDs());
        }
        return out;
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.version = in.extractInt(2);
        this.unknown = in.extractInt(2);
        int scriptCount = in.extractInt(2);
        if (SPGlobal.logMods) {
            ScriptPackage.logMod(srcMod, this.toString(), "Importing VMAD record with " + scriptCount + " scripts.  Version: " + this.version + ", unknown: " + this.unknown);
        }
        int i = 0;
        while (i < scriptCount) {
            this.scripts.add(new ScriptRef(in, srcMod));
            ++i;
        }
        if (this.fragments != null && !in.isDone().booleanValue()) {
            this.fragments.parseData(in, srcMod);
        }
    }

    @Override
    void export(ModExporter out) throws IOException {
        super.export(out);
        out.write(this.version, 2);
        out.write(this.unknown, 2);
        out.write(this.scripts.size(), 2);
        for (ScriptRef s : this.scripts) {
            s.export(out);
        }
        if (this.fragments != null) {
            this.fragments.export(out);
        }
    }

    public ArrayList<ScriptRef> getScripts() {
        return this.scripts;
    }

    public void addScript(String scriptName) {
        this.addScript(new ScriptRef(scriptName));
    }

    public void addScript(ScriptRef script) {
        this.scripts.add(script);
    }

    public ScriptRef getScript(String scriptName) {
        return this.getScript(new ScriptRef(scriptName));
    }

    public ScriptRef getScript(ScriptRef script) {
        int index = this.scripts.indexOf(script);
        return index != -1 ? this.scripts.get(index) : null;
    }

    public boolean hasScript(String scriptName) {
        return this.hasScript(new ScriptRef(scriptName));
    }

    public boolean hasScript(ScriptRef script) {
        return this.scripts.contains(script);
    }

    public void removeScript(String scriptName) {
        this.removeScript(new ScriptRef(scriptName));
    }

    public void removeScript(ScriptRef script) {
        this.scripts.remove(script);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("VMAD");
    }
}

