/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.FormID;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.Record;
import skyproc.SubData;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class STAT
extends MajorRecord {
    static final SubPrototype STATprototype = new SubPrototype(MajorRecord.majorProto){

        @Override
        protected void addRecords() {
            this.add(new SubData("OBND", new byte[12]));
            this.add(new Model());
            this.add(new DNAM());
            this.add(new SubData("MNAM"));
        }
    };

    STAT() {
        this.subRecords.setPrototype(STATprototype);
    }

    public STAT(String edid) {
        this();
        this.originateFromPatch(edid);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("STAT");
    }

    @Override
    Record getNew() {
        return new STAT();
    }

    public Model getModelData() {
        return this.subRecords.getModel();
    }

    DNAM getDNAM() {
        return (DNAM)this.subRecords.get("DNAM");
    }

    public float getMaxAngle() {
        return this.getDNAM().angle;
    }

    public void setMaxAngle(float angle) {
        this.getDNAM().angle = angle;
    }

    public void setMaterial(FormID id) {
        this.getDNAM().id = id;
    }

    public FormID getMaterial() {
        return this.getDNAM().id;
    }

    static class DNAM
    extends SubRecordTyped {
        float angle = 0.0f;
        FormID id = new FormID();

        DNAM() {
            super("DNAM");
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.angle);
            this.id.export(out);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
            super.parseData(in, srcMod);
            this.angle = in.extractFloat();
            this.id.parseData(in, srcMod);
        }

        @Override
        ArrayList allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(1);
            out.add(this.id);
            return out;
        }

        @Override
        SubRecord getNew(String type) {
            return new DNAM();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 8;
        }

        @Override
        boolean subRecordEquals(SubRecord subRecord) {
            return this.equals(subRecord);
        }

        public int hashCode() {
            int hash = 5;
            hash = 31 * hash + Float.floatToIntBits(this.angle);
            hash = 31 * hash + Objects.hashCode(this.id);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DNAM other = (DNAM)obj;
            if (Float.floatToIntBits(this.angle) != Float.floatToIntBits(other.angle)) {
                return false;
            }
            return Objects.equals(this.id, other.id);
        }
    }
}

