/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.util.ArrayList;
import skyproc.FormID;
import skyproc.MagicItem;
import skyproc.Record;
import skyproc.SubForm;
import skyproc.SubPrototype;
import skyproc.genenums.CastType;
import skyproc.genenums.DeliveryType;

public class SPEL
extends MagicItem {
    static final SubPrototype SPELproto = new SubPrototype(MagicItem.magicItemProto){

        @Override
        protected void addRecords() {
            this.add(new SubForm("MDOB"));
            this.add(new SubForm("ETYP"));
            this.reposition("DESC");
            this.add(new MagicItem.SPIT());
            this.reposition("EFID");
        }
    };

    SPEL() {
        this.subRecords.setPrototype(SPELproto);
    }

    public SPEL(String edid) {
        this();
        this.originateFromPatch(edid);
        SubForm ETYP = this.subRecords.getSubForm("ETYP");
        FormID id = new FormID("013F44Skyrim.esm");
        ETYP.setForm(id);
        this.getSPIT().valid = true;
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("SPEL");
    }

    @Override
    Record getNew() {
        return new SPEL();
    }

    public void setInventoryModel(FormID invModel) {
        this.subRecords.setSubForm("MODB", invModel);
    }

    public FormID getInventoryModel() {
        return this.subRecords.getSubForm("MODB").getForm();
    }

    public void setEquipSlot(FormID equipType) {
        this.subRecords.setSubForm("ETYP", equipType);
    }

    public FormID getEquipSlot() {
        return this.subRecords.getSubForm("ETYP").getForm();
    }

    final MagicItem.SPIT getSPIT() {
        return (MagicItem.SPIT)this.subRecords.get("SPIT");
    }

    public void setBaseCost(int baseCost) {
        this.getSPIT().baseCost = baseCost;
    }

    public int getBaseCost() {
        return this.getSPIT().baseCost;
    }

    public void set(MagicItem.SPELFlag flag, boolean on) {
        this.getSPIT().flags.set(flag.value, on);
    }

    public boolean get(MagicItem.SPELFlag flag) {
        return this.getSPIT().flags.get(flag.value);
    }

    public void setSpellType(SPELType type) {
        this.getSPIT().baseType = type.value;
    }

    public SPELType getSpellType() {
        return SPELType.value(this.getSPIT().baseType);
    }

    public void setChargeTime(float chargeTime) {
        this.getSPIT().chargeTime = chargeTime;
    }

    public float getChargeTime() {
        return this.getSPIT().chargeTime;
    }

    public void setCastType(CastType type) {
        this.getSPIT().castType = type;
    }

    public CastType getCastType() {
        return this.getSPIT().castType;
    }

    public void setDeliveryType(DeliveryType type) {
        this.getSPIT().targetType = type;
    }

    public DeliveryType getDeliveryType() {
        return this.getSPIT().targetType;
    }

    public void setCastDuration(float duration) {
        this.getSPIT().castDuration = duration;
    }

    public float getCastDuration() {
        return this.getSPIT().castDuration;
    }

    public void setRange(float range) {
        this.getSPIT().range = range;
    }

    public float getRange() {
        return this.getSPIT().range;
    }

    public FormID getPerkRef() {
        return this.getSPIT().perkType;
    }

    public void setPerkRef(FormID perkRef) {
        this.getSPIT().perkType = perkRef;
    }

    public static enum SPELType {
        Spell(0),
        Disease(1),
        Power(2),
        LesserPower(3),
        Ability(4),
        Addition(10),
        Voice(11),
        UNKNOWN(-1);

        int value;

        private SPELType(int valuein) {
            this.value = valuein;
        }

        static SPELType value(int value) {
            SPELType[] sPELTypeArray = SPELType.values();
            int n = sPELTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SPELType s = sPELTypeArray[n2];
                if (s.value == value) {
                    return s;
                }
                ++n2;
            }
            return UNKNOWN;
        }
    }
}

