/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import lev.Ln;
import skyproc.FormID;
import skyproc.GRUP_TYPE;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModListing;
import skyproc.SPGlobal;
import skyproc.SPImporter;

public class SPDatabase
implements Iterable<Mod> {
    static ArrayList<ModListing> activePlugins = new ArrayList();
    public static final String dateDelim = "<--DATE-->";
    static ArrayList<ModListing> addedPlugins = new ArrayList();
    static Map<ModListing, Mod> modLookup = new TreeMap<ModListing, Mod>();

    SPDatabase() {
    }

    static void clear() {
        activePlugins.clear();
        addedPlugins.clear();
        modLookup.clear();
    }

    public static int modIndex(ModListing listing) {
        int counter = 0;
        for (Mod m : modLookup.values()) {
            if (m.getName().equalsIgnoreCase(listing.print())) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public static Mod getMod(ModListing listing) {
        if (listing.equals(SPGlobal.getGlobalPatch().getInfo())) {
            return SPGlobal.getGlobalPatch();
        }
        return modLookup.get(listing);
    }

    public static boolean hasMod(ModListing listing) {
        return modLookup.containsKey(listing);
    }

    public static void removeMod(ModListing listing) {
        addedPlugins.remove(listing);
        modLookup.remove(listing);
    }

    public static Mod getMod(int index) {
        return modLookup.get(addedPlugins.get(index));
    }

    public static ArrayList<ModListing> getMods() {
        return new ArrayList<ModListing>(addedPlugins);
    }

    public static ArrayList<ModListing> getImportedModListings() {
        ArrayList<Mod> mods = new ArrayList<Mod>(SPDatabase.getImportedMods());
        ArrayList<ModListing> out = new ArrayList<ModListing>(mods.size());
        for (Mod m : mods) {
            out.add(m.getInfo());
        }
        return out;
    }

    public static ArrayList<Mod> getImportedMods() {
        ArrayList<Mod> out = new ArrayList<Mod>(activePlugins.size());
        for (ModListing m : activePlugins) {
            Mod mod = SPDatabase.getMod(m);
            if (mod == null) continue;
            out.add(mod);
        }
        return out;
    }

    public static void exportModList(String path) throws IOException {
        File modListTmp = new File(String.valueOf(SPGlobal.pathToInternalFiles) + "Last Modlist Temp.txt");
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(modListTmp));){
            for (String s : SPDatabase.getModListDates()) {
                writer.write(s);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        File modList = new File(path);
        if (modList.isFile()) {
            modList.delete();
        }
        Ln.moveFile((File)modListTmp, (File)modList, (boolean)false);
    }

    public static ArrayList<String> getModListDates() {
        ArrayList<String> out = new ArrayList<String>();
        try {
            for (ModListing m : SPImporter.getActiveModList()) {
                File modFile = new File(String.valueOf(SPGlobal.pathToData) + m.toString());
                out.add(String.valueOf(m.toString()) + dateDelim + modFile.lastModified());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    public static int numMods() {
        return addedPlugins.size();
    }

    public static boolean queryMajor(FormID query) {
        return SPDatabase.queryMajor(query, SPGlobal.getDB());
    }

    static boolean queryMajor(FormID query, SPDatabase database) {
        return SPDatabase.queryMajor(query, database, GRUP_TYPE.values());
    }

    public static boolean queryMajor(FormID query, GRUP_TYPE ... grup_types) {
        return SPDatabase.queryMajor(query, SPGlobal.getDB(), grup_types);
    }

    static boolean queryMajor(FormID query, SPDatabase database, GRUP_TYPE ... grup_types) {
        return SPDatabase.getMajor(query, database, grup_types) != null;
    }

    public static MajorRecord getMajor(FormID query) {
        return SPDatabase.getMajor(query, SPGlobal.getDB());
    }

    static MajorRecord getMajor(FormID query, SPDatabase database) {
        return SPDatabase.getMajor(query, database, GRUP_TYPE.values());
    }

    public static MajorRecord getMajor(FormID query, GRUP_TYPE ... grup_types) {
        return SPDatabase.getMajor(query, SPGlobal.getDB(), grup_types);
    }

    static MajorRecord getMajor(FormID query, SPDatabase database, GRUP_TYPE ... grup_types) {
        if (query != null && query.getMaster() != null) {
            Iterator<Mod> revOrder = database.reverseIter();
            while (revOrder.hasNext()) {
                Mod next = revOrder.next();
                MajorRecord ret = next.getMajor(query, grup_types);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    public static void add(Mod m) {
        SPDatabase.removeMod(m.getInfo());
        addedPlugins.add(m.getInfo());
        modLookup.put(m.getInfo(), m);
    }

    public static void add(Set<Mod> modSet) {
        for (Mod m : modSet) {
            SPDatabase.add(m);
        }
    }

    @Override
    public Iterator<Mod> iterator() {
        return modLookup.values().iterator();
    }

    public Iterator<Mod> reverseIter() {
        Iterator<Mod> iter = this.iterator();
        ArrayList<Mod> outList = new ArrayList<Mod>(modLookup.size());
        while (iter.hasNext()) {
            outList.add(0, iter.next());
        }
        return outList.iterator();
    }
}

