/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.nio.ByteBuffer;
import lev.LInChannel;
import skyproc.SPGlobal;

class RecordFileChannel
extends LInChannel {
    long pos;

    public RecordFileChannel(String str) {
        super(str);
        this.pos = 0L;
    }

    public RecordFileChannel(LInChannel fc, int allocation) {
        this.pos = fc.pos();
        this.slice(fc, allocation);
    }

    public RecordFileChannel(RecordFileChannel rfc, int allocation) {
        this.pos = rfc.pos;
        this.slice(rfc, allocation);
    }

    public void openFile(String path) {
        super.openFile(path);
        try {
            this.pos = this.iChannel.position();
        }
        catch (IOException ex) {
            SPGlobal.logException(ex);
        }
    }

    public byte[] extract(int amount) {
        this.pos(this.pos);
        byte[] out = super.extract(amount);
        this.pos += (long)amount;
        return out;
    }

    public Boolean isDone() {
        if (this.pos == this.end) {
            return true;
        }
        return false;
    }

    public void pos(long pos) {
        super.pos(pos);
        this.pos = pos;
    }

    public long pos() {
        return this.pos;
    }

    public ByteBuffer extractByteBuffer(int skip, int read) {
        ByteBuffer out = super.extractByteBuffer(skip, read);
        this.pos += (long)(skip + read);
        return out;
    }

    public int read() {
        this.pos(this.pos);
        int out = super.read();
        ++this.pos;
        return out;
    }
}

