/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import lev.LImport;
import lev.LInChannel;
import lev.LShrinkArray;
import lev.Ln;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.RecordShrinkArray;
import skyproc.SPGlobal;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public abstract class Record
implements Serializable {
    static final HashMap<String, ArrayList<String>> typeLists = new HashMap();
    private static int datasize = -1;

    Record() {
    }

    void parseData(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
        in.skip(this.getIdentifierLength() + this.getSizeLength());
    }

    final void parseData(ByteBuffer in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
        this.parseData((LImport)new LShrinkArray(in), srcMod);
    }

    boolean isValid() {
        return true;
    }

    public abstract String toString();

    public abstract String print();

    abstract ArrayList<String> getTypes();

    static ArrayList<String> getTypeList(String t) {
        ArrayList<String> out = typeLists.get(t);
        if (out == null) {
            out = new ArrayList<String>(Arrays.asList(t));
            typeLists.put(t, out);
        }
        return out;
    }

    public String getType() {
        return this.getTypes().get(0);
    }

    Record getNew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static String getNextType(LImport in) throws BadRecord {
        datasize = -1;
        String type = Ln.arrayToString((int[])in.getInts(0, 4));
        if (type.equals("XXXX")) {
            int blocksize = Ln.arrayToInt((byte[])in.extract(4, 2));
            datasize = Ln.arrayToInt((byte[])in.extract(blocksize));
            type = Ln.arrayToString((int[])in.getInts(0, 4));
        }
        return type;
    }

    static int getDataBlockSize() {
        return datasize;
    }

    void export(ModExporter out) throws IOException {
        if (this.isValid()) {
            out.write(this.getType().toString());
            out.write(this.getContentLength(out));
        }
    }

    public int getRecordLength(LImport in) {
        int blocksize = Record.getDataBlockSize();
        if (blocksize == -1) {
            blocksize = Ln.arrayToInt((int[])in.getInts(this.getIdentifierLength(), this.getSizeLength()));
        }
        return blocksize + this.getSizeLength() + this.getIdentifierLength() + this.getFluffLength();
    }

    LImport extractRecordData(LImport in) {
        return this.extractData(in, this.getRecordLength(in));
    }

    LImport extractData(LImport in, int size) {
        LShrinkArray extracted = SPGlobal.streamMode && (in instanceof RecordShrinkArray || in instanceof LInChannel) ? new RecordShrinkArray(in, size) : new LShrinkArray(in, size);
        in.skip(size);
        return extracted;
    }

    int getHeaderLength() {
        return this.getIdentifierLength() + this.getSizeLength() + this.getFluffLength();
    }

    final int getIdentifierLength() {
        return 4;
    }

    abstract int getSizeLength();

    abstract int getFluffLength();

    int getTotalLength(ModExporter out) {
        return this.getContentLength(out) + this.getHeaderLength();
    }

    abstract int getContentLength(ModExporter var1);

    void newSyncLog(String fileName) {
        SPGlobal.newSyncLog(fileName);
    }

    boolean logging() {
        return SPGlobal.logging();
    }

    void logMain(String header, String ... log) {
        SPGlobal.logMain(header, log);
    }

    void logSync(String header, String ... log) {
        SPGlobal.logSync(this.getType().toString(), log);
    }

    void logError(String header, String ... log) {
        SPGlobal.logError(header, log);
    }

    void logSpecial(Enum e, String header, String ... log) {
        SPGlobal.logSpecial(e, header, log);
    }

    void log(String header, String ... log) {
        SPGlobal.log(header, log);
    }

    static void logMod(Mod srcMod, String header, String ... data) {
        SPGlobal.logMod(srcMod, header, data);
    }

    void newLog(String fileName) {
        SPGlobal.newLog(fileName);
    }

    void flush() {
        SPGlobal.flush();
    }
}

