/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.BodyTemplate;
import skyproc.FormID;
import skyproc.KeywordSet;
import skyproc.MajorRecordDescription;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.NiftyFunc;
import skyproc.Record;
import skyproc.SubData;
import skyproc.SubForm;
import skyproc.SubFormArray;
import skyproc.SubList;
import skyproc.SubListCounted;
import skyproc.SubMarkerSet;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubShell;
import skyproc.SubShellBulkType;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.ActorValue;
import skyproc.genenums.FirstPersonFlags;
import skyproc.genenums.Gender;

public class RACE
extends MajorRecordDescription {
    static final SubPrototype morphProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new SubData("MPAI"));
            this.add(new SubData("MPAV"));
        }
    };
    static final SubPrototype headPartProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new SubData("INDX"));
            this.add(new SubForm("HEAD"));
        }
    };
    static final SubPrototype attackDataProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new AttackDataInternal());
            this.add(SubString.getNew("ATKE", true));
        }
    };
    static final SubPrototype RACEproto = new SubPrototype(MajorRecordDescription.descProto){

        @Override
        protected void addRecords() {
            this.add(new SubListCounted<SubForm>("SPCT", 4, new SubForm("SPLO")));
            this.add(new SubForm("WNAM"));
            this.add(new BodyTemplate());
            this.add(new KeywordSet());
            this.add(new DATA());
            SubMarkerSet<SubShell> mfnam = new SubMarkerSet<SubShell>(new SubShell(new SubPrototype(){

                @Override
                protected void addRecords() {
                    this.add(SubString.getNew("ANAM", true));
                    this.add(new SubData("MODT"));
                }
            }), "MNAM", "FNAM");
            mfnam.forceMarkers = true;
            this.add(mfnam);
            this.add(new SubList(SubString.getNew("MTNM", false)));
            this.add(new SubFormArray("VTCK", 2));
            this.add(new SubFormArray("DNAM", 2));
            this.add(new SubFormArray("HCLF", 2));
            this.add(new SubData("TINL"));
            this.add(new SubData("PNAM"));
            this.add(new SubData("UNAM"));
            this.add(new SubForm("ATKR"));
            this.add(new SubList(new AttackData()));
            this.add(new SubShellBulkType(new SubPrototype(){

                @Override
                protected void addRecords() {
                    this.add(new SubData("NAM1"));
                    this.forceExport("NAM1");
                    SubMarkerSet<SubShell> BodyData = new SubMarkerSet<SubShell>(new SubShell(new SubPrototype(){

                        @Override
                        protected void addRecords() {
                            this.add(new SubData("INDX"));
                            this.add(new Model());
                        }
                    }), "MNAM", "FNAM");
                    BodyData.forceMarkers = true;
                    this.add(BodyData);
                }
            }, false));
            this.add(new SubFormArray("HNAM", 0));
            this.add(new SubFormArray("ENAM", 0));
            this.add(new SubForm("GNAM"));
            this.add(new SubData("NAM2"));
            this.add(new SubShellBulkType(new SubPrototype(){

                @Override
                protected void addRecords() {
                    this.add(new SubData("NAM3"));
                    this.forceExport("NAM3");
                    this.add(new SubMarkerSet<SubShell>(new SubShell(new SubPrototype(){

                        @Override
                        protected void addRecords() {
                            this.add(new Model());
                        }
                    }), "MNAM", "FNAM"));
                }
            }, false));
            this.add(new SubForm("NAM4"));
            this.add(new SubForm("NAM5"));
            this.add(new SubForm("NAM7"));
            this.add(new SubForm("ONAM"));
            this.add(new SubForm("LNAM"));
            this.add(new SubList(SubString.getNew("NAME", true)));
            this.add(new SubList(new SubShell(new SubPrototype(){

                @Override
                protected void addRecords() {
                    this.add(new SubForm("MTYP"));
                    this.add(new SubData("SPED"));
                }
            })));
            this.add(new SubData("VNAM"));
            this.add(new SubList(new SubForm("QNAM")));
            this.add(new SubForm("UNES"));
            this.add(new SubList(SubString.getNew("PHTN", true)));
            this.add(new SubList(new SubData("PHWT")));
            this.add(new SubForm("WKMV"));
            this.add(new SubForm("RNMV"));
            this.add(new SubForm("SWMV"));
            this.add(new SubForm("FLMV"));
            this.add(new SubForm("SNMV"));
            this.add(new SubForm("SPMV"));
            this.add(new SubList(new SubShellBulkType(new SubPrototype(){

                @Override
                protected void addRecords() {
                    this.add(new SubData("NAM0"));
                    this.forceExport("NAM0");
                    this.add(new SubData("MNAM"));
                    this.add(new SubData("FNAM"));
                    this.add(new SubList(new SubShell(headPartProto)));
                    this.add(new SubList(new SubShell(morphProto)));
                    this.add(new SubList(new SubForm("RPRM")));
                    this.add(new SubList(new SubForm("RPRF")));
                    this.add(new SubList(new SubForm("AHCM")));
                    this.add(new SubList(new SubForm("AHCF")));
                    this.add(new SubList(new SubForm("FTSM")));
                    this.add(new SubList(new SubForm("FTSF")));
                    this.add(new SubForm("DFTM"));
                    this.add(new SubForm("DFTF"));
                    this.add(new SubList(new SubShell(new SubPrototype(){

                        @Override
                        protected void addRecords() {
                            this.add(new SubData("TINI"));
                            this.add(SubString.getNew("TINT", true));
                            this.add(new SubData("TINP"));
                            this.add(new SubForm("TIND"));
                            this.add(new SubList(new SubShell(new SubPrototype(){

                                @Override
                                protected void addRecords() {
                                    this.add(new SubForm("TINC"));
                                    this.add(new SubData("TINV"));
                                    this.add(new SubData("TIRS"));
                                }
                            })));
                        }
                    })));
                }
            }, false)));
            this.add(new SubForm("NAM8"));
            this.add(new SubForm("RNAM"));
        }
    };

    RACE() {
        this.subRecords.setPrototype(RACEproto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("RACE");
    }

    @Override
    Record getNew() {
        return new RACE();
    }

    DATA getDATA() {
        return (DATA)this.subRecords.get("DATA");
    }

    public void set(RACEFlags flag, boolean on) {
        this.getDATA().flags.set(flag.ordinal(), on);
    }

    public boolean get(RACEFlags flag) {
        return this.getDATA().flags.get(flag.ordinal());
    }

    public FormID getWornArmor() {
        return this.subRecords.getSubForm("WNAM").getForm();
    }

    public void setWornArmor(FormID id) {
        this.subRecords.setSubForm("WNAM", id);
    }

    public ArrayList<FormID> getSpells() {
        return this.subRecords.getSubList("SPLO").toPublic();
    }

    public void addSpell(FormID spell) {
        this.subRecords.getSubList("SPLO").add(spell);
    }

    public void removeSpell(FormID spell) {
        this.subRecords.getSubList("SPLO").remove(spell);
    }

    public void clearSpells() {
        this.subRecords.getSubList("SPLO").clear();
    }

    public void setModel(Gender gender, String model) {
        this.getMFData((Gender)gender).subRecords.setSubString("ANAM", model);
    }

    SubShell getMFData(Gender gender) {
        SubMarkerSet MFNAM = this.subRecords.getSubMarker("ANAM");
        switch (gender) {
            case MALE: {
                return (SubShell)MFNAM.get("MNAM");
            }
        }
        return (SubShell)MFNAM.get("FNAM");
    }

    public String getModel(Gender gender) {
        return this.getMFData((Gender)gender).subRecords.getSubString("ANAM").print();
    }

    public void setVoiceType(Gender gender, FormID voice) {
        SubFormArray VTCK = (SubFormArray)this.subRecords.get("VTCK");
        switch (gender) {
            case MALE: {
                VTCK.IDs.set(0, voice);
                break;
            }
            default: {
                VTCK.IDs.set(1, voice);
            }
        }
    }

    public FormID getVoiceType(Gender gender) {
        SubFormArray VTCK = (SubFormArray)this.subRecords.get("VTCK");
        switch (gender) {
            case MALE: {
                return VTCK.IDs.get(0);
            }
        }
        return VTCK.IDs.get(1);
    }

    public void setHairColor(Gender gender, FormID color) {
        SubFormArray HCLF = (SubFormArray)this.subRecords.get("HCLF");
        switch (gender) {
            case MALE: {
                HCLF.IDs.set(0, color);
                break;
            }
            default: {
                HCLF.IDs.set(1, color);
            }
        }
    }

    public FormID getHairColor(Gender gender) {
        SubFormArray HCLF = (SubFormArray)this.subRecords.get("HCLF");
        switch (gender) {
            case MALE: {
                return HCLF.IDs.get(0);
            }
        }
        return HCLF.IDs.get(1);
    }

    public void setDecapHeadPart(Gender gender, FormID part) {
        SubFormArray DNAM2 = (SubFormArray)this.subRecords.get("DNAM");
        switch (gender) {
            case MALE: {
                DNAM2.IDs.set(0, part);
                break;
            }
            default: {
                DNAM2.IDs.set(1, part);
            }
        }
    }

    public FormID getDecapHeadPart(Gender gender) {
        SubFormArray DNAM2 = (SubFormArray)this.subRecords.get("DNAM");
        switch (gender) {
            case MALE: {
                return DNAM2.IDs.get(0);
            }
        }
        return DNAM2.IDs.get(1);
    }

    public void setHeight(Gender gender, float value) {
        DATA DATA2 = this.getDATA();
        switch (gender) {
            case MALE: {
                DATA2.maleHeight = value;
            }
            case FEMALE: {
                DATA2.femaleHeight = value;
            }
        }
    }

    public float getHeight(Gender gender) {
        DATA DATA2 = this.getDATA();
        switch (gender) {
            case MALE: {
                return DATA2.maleHeight;
            }
        }
        return DATA2.femaleHeight;
    }

    public float getAccelerationRate() {
        return this.getDATA().accelerationRate;
    }

    public void setAccelerationRate(float accelerationRate) {
        this.getDATA().accelerationRate = accelerationRate;
    }

    public float getAimAngleTolerance() {
        return this.getDATA().aimAngleTolerance;
    }

    public void setAimAngleTolerance(float aimAngleTolerance) {
        this.getDATA().aimAngleTolerance = aimAngleTolerance;
    }

    public float getAngularAcceleration() {
        return this.getDATA().angularAcceleration;
    }

    public void setAngularAcceleration(float angularAcceleration) {
        this.getDATA().angularAcceleration = angularAcceleration;
    }

    public float getAngularTolerance() {
        return this.getDATA().angularTolerance;
    }

    public void setAngularTolerance(float angularTolerance) {
        this.getDATA().angularTolerance = angularTolerance;
    }

    public float getBaseCarryWeight() {
        return this.getDATA().baseCarryWeight;
    }

    public void setBaseCarryWeight(float baseCarryWeight) {
        this.getDATA().baseCarryWeight = baseCarryWeight;
    }

    public float getBaseMass() {
        return this.getDATA().baseMass;
    }

    public void setBaseMass(float baseMass) {
        this.getDATA().baseMass = baseMass;
    }

    public float getDecelerationRate() {
        return this.getDATA().decelerationRate;
    }

    public void setDecelerationRate(float decelerationRate) {
        this.getDATA().decelerationRate = decelerationRate;
    }

    public float getFemaleWeight() {
        return this.getDATA().femaleWeight;
    }

    public void setFemaleWeight(float femaleWeight) {
        this.getDATA().femaleWeight = femaleWeight;
    }

    public float getFlightRadius() {
        return this.getDATA().flightRadius;
    }

    public void setFlightRadius(float flightRadius) {
        this.getDATA().flightRadius = flightRadius;
    }

    public float getHealthRegen() {
        return this.getDATA().healthRegen;
    }

    public void setHealthRegen(float healthRegen) {
        this.getDATA().healthRegen = healthRegen;
    }

    public float getInjuredHealthPct() {
        return this.getDATA().injuredHealthPct;
    }

    public void setInjuredHealthPct(float injuredHealthPct) {
        this.getDATA().injuredHealthPct = injuredHealthPct;
    }

    public float getMagickaRegen() {
        return this.getDATA().magickaRegen;
    }

    public void setMagickaRegen(float magickaRegen) {
        this.getDATA().magickaRegen = magickaRegen;
    }

    public float getMaleHeight() {
        return this.getDATA().maleHeight;
    }

    public void setMaleHeight(float maleHeight) {
        this.getDATA().maleHeight = maleHeight;
    }

    public float getMaleWeight() {
        return this.getDATA().maleWeight;
    }

    public void setMaleWeight(float maleWeight) {
        this.getDATA().maleWeight = maleWeight;
    }

    public Size getSize() {
        return this.getDATA().size;
    }

    public void setSize(Size size) {
        this.getDATA().size = size;
    }

    public float getStaminaRegen() {
        return this.getDATA().staminaRegen;
    }

    public void setStaminaRegen(float staminaRegen) {
        this.getDATA().staminaRegen = staminaRegen;
    }

    public float getStartingHealth() {
        return this.getDATA().startingHealth;
    }

    public void setStartingHealth(float startingHealth) {
        this.getDATA().startingHealth = startingHealth;
    }

    public float getStartingMagicka() {
        return this.getDATA().startingMagicka;
    }

    public void setStartingMagicka(float startingMagicka) {
        this.getDATA().startingMagicka = startingMagicka;
    }

    public float getStartingStamina() {
        return this.getDATA().startingStamina;
    }

    public void setStartingStamina(float startingStamina) {
        this.getDATA().startingStamina = startingStamina;
    }

    public float getUnarmedDamage() {
        return this.getDATA().unarmedDamage;
    }

    public void setUnarmedDamage(float unarmedDamage) {
        this.getDATA().unarmedDamage = unarmedDamage;
    }

    public float getUnarmedReach() {
        return this.getDATA().unarmedReach;
    }

    public void setUnarmedReach(float unarmedReach) {
        this.getDATA().unarmedReach = unarmedReach;
    }

    public void clearAttackData() {
        this.subRecords.getSubList("ATKD").clear();
    }

    public ArrayList<AttackData> getAttackData() {
        return this.subRecords.getSubList("ATKD").toPublic();
    }

    public void addAttackData(AttackData data) {
        this.subRecords.getSubList("ATKD").add(data);
    }

    public void removeAttackData(AttackData data) {
        this.subRecords.getSubList("ATKD").remove(data);
    }

    public void copyAttackData(RACE rhs) {
        ArrayList<AttackData> attackList = this.getAttackData();
        attackList.clear();
        ArrayList<AttackData> rhsAttackList = rhs.getAttackData();
        for (AttackData rhsData : rhsAttackList) {
            AttackData newData = new AttackData(rhsData.getEventName());
            newData.copyData(rhsData);
            attackList.add(newData);
        }
    }

    public FormID getMaterialType() {
        return this.subRecords.getSubForm("NAM4").getForm();
    }

    public void setMaterialType(FormID id) {
        this.subRecords.setSubForm("NAM4", id);
    }

    public FormID getImpactDataSet() {
        return this.subRecords.getSubForm("NAM5").getForm();
    }

    public void setImpactDataSet(FormID id) {
        this.subRecords.setSubForm("NAM5", id);
    }

    public FormID getDecapitationFX() {
        return this.subRecords.getSubForm("NAM7").getForm();
    }

    public void setDecapitationFX(FormID id) {
        this.subRecords.setSubForm("NAM7", id);
    }

    public FormID getOpenLootSound() {
        return this.subRecords.getSubForm("ONAM").getForm();
    }

    public void setOpenLootSound(FormID id) {
        this.subRecords.setSubForm("ONAM", id);
    }

    public FormID getCloseLootSound() {
        return this.subRecords.getSubForm("LNAM").getForm();
    }

    public void setCloseLootSound(FormID id) {
        this.subRecords.setSubForm("LNAM", id);
    }

    public FormID getUnarmedEquipSlot() {
        return this.subRecords.getSubForm("UNES").getForm();
    }

    public void setUnarmedEquipSlot(FormID id) {
        this.subRecords.setSubForm("UNES", id);
    }

    public void clearTinting() {
        this.subRecords.getSubList("NAM0").clear();
    }

    SubMarkerSet<SubShell> getBodyData() {
        return this.subRecords.getSubShell((String)"NAM1").subRecords.getSubMarker("INDX");
    }

    SubShell getBodyData(Gender gender) {
        switch (gender) {
            case MALE: {
                return (SubShell)this.getBodyData().set.get("MNAM");
            }
        }
        return (SubShell)this.getBodyData().set.get("FNAM");
    }

    public String getLightingModels(Gender gender) {
        return this.getBodyData((Gender)gender).subRecords.getModel().getFileName();
    }

    public void setLightingModels(Gender gender, String s) {
        this.getBodyData((Gender)gender).subRecords.getModel().setFileName(s);
    }

    SubMarkerSet<SubShell> getBehaviorGraph() {
        return this.subRecords.getSubShell((String)"NAM3").subRecords.getSubMarker("MODL");
    }

    SubShell getBehaviorGraph(Gender gender) {
        switch (gender) {
            case MALE: {
                return (SubShell)this.getBehaviorGraph().set.get("MNAM");
            }
        }
        return (SubShell)this.getBehaviorGraph().set.get("FNAM");
    }

    public String getPhysicsModels(Gender gender) {
        return this.getPhysicsModel(gender).getFileName();
    }

    public void setPhysicsModels(Gender gender, String s) {
        this.getPhysicsModel(gender).setFileName(s);
    }

    public Model getPhysicsModel(Gender gender) {
        return this.getBehaviorGraph((Gender)gender).subRecords.getModel();
    }

    public ArrayList<FormID> getEquipSlots() {
        return this.subRecords.getSubList("QNAM").toPublic();
    }

    public void addEquipSlot(FormID in) {
        this.subRecords.getSubList("QNAM").add(in);
    }

    public void removeEquipSlot(FormID in) {
        this.subRecords.getSubList("QNAM").remove(in);
    }

    public void clearEquipSlots() {
        this.subRecords.getSubList("QNAM").clear();
    }

    public KeywordSet getKeywordSet() {
        return this.subRecords.getKeywords();
    }

    public BodyTemplate getBodyTemplate() {
        return this.subRecords.getBodyTemplate();
    }

    public void setArmorRace(FormID race) {
        this.subRecords.setSubForm("RNAM", race);
    }

    public FormID getArmorRace() {
        return this.subRecords.getSubForm("RNAM").getForm();
    }

    public void setMorphRace(FormID race) {
        this.subRecords.setSubForm("NAM8", race);
    }

    public FormID getMorphRace() {
        return this.subRecords.getSubForm("NAM8").getForm();
    }

    public void setSkillBoost(int boostIndex, ActorValue skill, int value) {
        if (boostIndex < 7 && boostIndex >= 0) {
            this.getDATA().skillBoosts.set(boostIndex, skill);
            this.getDATA().skillBoostValues.set(boostIndex, value);
        }
    }

    public ActorValue getSkillBoostSkill(int boostIndex) {
        if (boostIndex < 7 && boostIndex >= 0) {
            return this.getDATA().skillBoosts.get(boostIndex);
        }
        return null;
    }

    public int getSkillBoostValue(int boostIndex) {
        if (boostIndex < 7 && boostIndex >= 0) {
            return this.getDATA().skillBoostValues.get(boostIndex);
        }
        return -1;
    }

    public void setHeadBipedObject(FirstPersonFlags object) {
        this.getDATA().headBipedObject = object;
    }

    public FirstPersonFlags getHeadBipedObject() {
        return this.getDATA().headBipedObject;
    }

    public void setHairBipedObject(FirstPersonFlags object) {
        this.getDATA().hairBipedObject = object;
    }

    public FirstPersonFlags getHairBipedObject() {
        return this.getDATA().hairBipedObject;
    }

    public void setShieldBipedObject(FirstPersonFlags object) {
        this.getDATA().shieldBipedObject = object;
    }

    public FirstPersonFlags getShieldBipedObject() {
        return this.getDATA().shieldBipedObject;
    }

    public void setBodyBipedObject(FirstPersonFlags object) {
        this.getDATA().bodyBipedObject = object;
    }

    public FirstPersonFlags getBodyBipedObject() {
        return this.getDATA().bodyBipedObject;
    }

    public void set(RaceFlags2 flag, boolean on) {
        this.getDATA().flags2.set(flag.val, on);
    }

    public boolean get(RaceFlags2 flag) {
        return this.getDATA().flags2.get(flag.val);
    }

    public ArrayList<String> getMovementTypeNames() {
        return this.subRecords.getSubList("MTNM").toPublic();
    }

    public void addMovementTypeName(String name) {
        this.subRecords.getSubList("MTNM").add(NiftyFunc.trimToFour(name));
    }

    public void clearMovementTypeNames() {
        this.subRecords.getSubList("MTNM").clear();
    }

    public void removeMovementTypeName(String name) {
        this.subRecords.getSubList("MTNM").remove(NiftyFunc.trimToFour(name));
    }

    public void setFaceGenMainClamp(float in) {
        this.subRecords.setSubFloat("PNAM", in);
    }

    public float getFaceGenMainClamp() {
        return this.subRecords.getSubFloat("PNAM").get();
    }

    public void setFaceGenFaceClamp(float in) {
        this.subRecords.setSubFloat("UNAM", in);
    }

    public float getFaceGenFaceClamp() {
        return this.subRecords.getSubFloat("UNAM").get();
    }

    public void setAttackRace(FormID id) {
        this.subRecords.setSubForm("ATKR", id);
    }

    public FormID getAttackRace() {
        return this.subRecords.getSubForm("ATKR").getForm();
    }

    SubList<SubShell, SubShell> getHeadData() {
        return this.subRecords.getSubList("NAM0");
    }

    SubShell getHeadData(Gender g) {
        String genderType;
        switch (g) {
            case MALE: {
                genderType = "MNAM";
                break;
            }
            default: {
                genderType = "FNAM";
            }
        }
        SubList<SubShell, SubShell> data = this.getHeadData();
        for (SubShell s : data) {
            if (!s.subRecords.containsStrict(genderType)) continue;
            return s;
        }
        SubShell newData = (SubShell)((SubShell)data.prototype).getNew();
        data.add(newData);
        newData.subRecords.getSubData(genderType).initialize(0);
        return newData;
    }

    public void setDefaultFaceTexture(Gender g, FormID id) {
        switch (g) {
            case FEMALE: {
                this.getHeadData((Gender)g).subRecords.setSubForm("DFTF", id);
                break;
            }
            default: {
                this.getHeadData((Gender)g).subRecords.setSubForm("DFTM", id);
            }
        }
    }

    public FormID getDefaultFaceTexture(Gender g) {
        switch (g) {
            case FEMALE: {
                return this.getHeadData((Gender)g).subRecords.getSubForm("DFTF").getForm();
            }
        }
        return this.getHeadData((Gender)g).subRecords.getSubForm("DFTM").getForm();
    }

    public ArrayList<FormID> getFaceDetailsTextureSet(Gender g) {
        switch (g) {
            case FEMALE: {
                return this.getHeadData((Gender)g).subRecords.getSubList("FTSF").toPublic();
            }
        }
        return this.getHeadData((Gender)g).subRecords.getSubList("FTSM").toPublic();
    }

    public void addFaceDetailsTexture(Gender g, FormID id) {
        switch (g) {
            case FEMALE: {
                this.getHeadData((Gender)g).subRecords.getSubList("FTSF").add(new SubForm("FTSF", id));
                break;
            }
            default: {
                this.getHeadData((Gender)g).subRecords.getSubList("FTSM").add(new SubForm("FTSM", id));
            }
        }
    }

    public void removeFaceDetailsTexture(Gender g, FormID id) {
        switch (g) {
            case FEMALE: {
                this.getHeadData((Gender)g).subRecords.getSubList("FTSF").remove(new SubForm("FTSF", id));
                break;
            }
            default: {
                this.getHeadData((Gender)g).subRecords.getSubList("FTSM").remove(new SubForm("FTSM", id));
            }
        }
    }

    public void clearFaceDetailsTexture(Gender g) {
        switch (g) {
            case FEMALE: {
                this.getHeadData((Gender)g).subRecords.getSubList("FTSF").clear();
                break;
            }
            default: {
                this.getHeadData((Gender)g).subRecords.getSubList("FTSM").clear();
            }
        }
    }

    public static final class AttackData
    extends SubShell {
        AttackData() {
            super(attackDataProto);
        }

        public AttackData(String eventName) {
            this();
            this.subRecords.setSubString("ATKE", eventName);
        }

        public String getEventName() {
            return this.subRecords.getSubString("ATKE").print();
        }

        AttackDataInternal getATKD() {
            return (AttackDataInternal)this.subRecords.get("ATKD");
        }

        public void copyData(AttackData rhs) {
            this.getATKD().copy(rhs.getATKD());
        }

        @Override
        SubRecord getNew(String type) {
            return new AttackData();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AttackData other = (AttackData)obj;
            return Objects.equals(this.getEventName(), other.getEventName());
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + Objects.hashCode(this.getEventName());
            return hash;
        }

        public void setDamageMult(float in) {
            this.getATKD().damageMult = in;
        }

        public float getDamageMult() {
            return this.getATKD().damageMult;
        }

        public void setAttackChance(float in) {
            this.getATKD().attackChance = in;
        }

        public float getAttackChance() {
            return this.getATKD().attackChance;
        }

        public void setAttackSpell(FormID spell) {
            this.getATKD().attackSpell = spell;
        }

        public FormID getAttackSpell() {
            return this.getATKD().attackSpell;
        }

        public void setAttackAngle(float in) {
            this.getATKD().attackAngle = in;
        }

        public float getAttackAngle() {
            return this.getATKD().attackAngle;
        }

        public void setStrikeAngle(float in) {
            this.getATKD().strikeAngle = in;
        }

        public float getStrikeAngle() {
            return this.getATKD().strikeAngle;
        }

        public void setStagger(float in) {
            this.getATKD().stagger = in;
        }

        public float getStagger() {
            return this.getATKD().stagger;
        }

        public void setAttackType(FormID id) {
            this.getATKD().attackType = id;
        }

        public FormID getAttackType() {
            return this.getATKD().attackType;
        }

        public void setKnockDown(float in) {
            this.getATKD().knockDown = in;
        }

        public float getKnockDown() {
            return this.getATKD().knockDown;
        }

        public void setRecoveryTime(float in) {
            this.getATKD().recoveryTime = in;
        }

        public float getRecoveryTime() {
            return this.getATKD().recoveryTime;
        }

        public void setFatigueMult(float in) {
            this.getATKD().fatigueMult = in;
        }

        public float getFatigueMult() {
            return this.getATKD().fatigueMult;
        }
    }

    public static final class AttackDataInternal
    extends SubRecord {
        float damageMult = 0.0f;
        float attackChance = 0.0f;
        FormID attackSpell = new FormID();
        LFlags flags = new LFlags(4);
        float attackAngle = 0.0f;
        float strikeAngle = 0.0f;
        float stagger = 0.0f;
        FormID attackType = new FormID();
        float knockDown = 0.0f;
        float recoveryTime = 0.0f;
        float fatigueMult = 0.0f;

        void copy(AttackDataInternal rhs) {
            this.damageMult = rhs.damageMult;
            this.attackChance = rhs.attackChance;
            this.attackSpell = new FormID(rhs.attackSpell);
            this.flags = new LFlags(rhs.flags);
            this.attackAngle = rhs.attackAngle;
            this.strikeAngle = rhs.strikeAngle;
            this.stagger = rhs.stagger;
            this.attackType = new FormID(rhs.attackType);
            this.knockDown = rhs.knockDown;
            this.recoveryTime = rhs.recoveryTime;
            this.fatigueMult = rhs.fatigueMult;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(2);
            out.add(this.attackSpell);
            out.add(this.attackType);
            return out;
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.damageMult);
            out.write(this.attackChance);
            this.attackSpell.export(out);
            out.write(this.flags.export());
            out.write(this.attackAngle);
            out.write(this.strikeAngle);
            out.write(this.stagger);
            this.attackType.export(out);
            out.write(this.knockDown);
            out.write(this.recoveryTime);
            out.write(this.fatigueMult);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
            super.parseData(in, srcMod);
            this.damageMult = in.extractFloat();
            this.attackChance = in.extractFloat();
            this.attackSpell.parseData(in, srcMod);
            this.flags.set(in.extract(4));
            this.attackAngle = in.extractFloat();
            this.strikeAngle = in.extractFloat();
            this.stagger = in.extractFloat();
            this.attackType.parseData(in, srcMod);
            this.knockDown = in.extractFloat();
            this.recoveryTime = in.extractFloat();
            this.fatigueMult = in.extractFloat();
        }

        @Override
        SubRecord getNew(String type) {
            return new AttackDataInternal();
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("ATKD");
        }

        @Override
        int getContentLength(ModExporter out) {
            return 44;
        }
    }

    static final class DATA
    extends SubRecord {
        ArrayList<ActorValue> skillBoosts = new ArrayList(7);
        ArrayList<Integer> skillBoostValues = new ArrayList(7);
        float maleHeight = 0.0f;
        float femaleHeight = 0.0f;
        float maleWeight = 0.0f;
        float femaleWeight = 0.0f;
        LFlags flags = new LFlags(4);
        float startingHealth = 0.0f;
        float startingMagicka = 0.0f;
        float startingStamina = 0.0f;
        float baseCarryWeight = 0.0f;
        float baseMass = 0.0f;
        float accelerationRate = 0.0f;
        float decelerationRate = 0.0f;
        Size size = Size.MEDIUM;
        FirstPersonFlags headBipedObject = FirstPersonFlags.NONE;
        FirstPersonFlags hairBipedObject = FirstPersonFlags.NONE;
        float injuredHealthPct = 0.0f;
        FirstPersonFlags shieldBipedObject = FirstPersonFlags.NONE;
        float healthRegen = 0.0f;
        float magickaRegen = 0.0f;
        float staminaRegen = 0.0f;
        float unarmedDamage = 0.0f;
        float unarmedReach = 0.0f;
        FirstPersonFlags bodyBipedObject = FirstPersonFlags.NONE;
        float aimAngleTolerance = 0.0f;
        float flightRadius = 0.0f;
        float angularAcceleration = 0.0f;
        float angularTolerance = 0.0f;
        LFlags flags2 = new LFlags(4);
        byte[] mountData;

        DATA() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            int i = 0;
            while (i < 7) {
                out.write(ActorValue.value(this.skillBoosts.get(i)), 1);
                out.write(this.skillBoostValues.get(i), 1);
                ++i;
            }
            out.write(0, 2);
            out.write(this.maleHeight);
            out.write(this.femaleHeight);
            out.write(this.maleWeight);
            out.write(this.femaleWeight);
            out.write(this.flags.export(), 4);
            out.write(this.startingHealth);
            out.write(this.startingMagicka);
            out.write(this.startingStamina);
            out.write(this.baseCarryWeight);
            out.write(this.baseMass);
            out.write(this.accelerationRate);
            out.write(this.decelerationRate);
            out.write(this.size.ordinal(), 4);
            out.write(this.headBipedObject.getValue());
            out.write(this.hairBipedObject.getValue());
            out.write(this.injuredHealthPct);
            out.write(this.shieldBipedObject.getValue());
            out.write(this.healthRegen);
            out.write(this.magickaRegen);
            out.write(this.staminaRegen);
            out.write(this.unarmedDamage);
            out.write(this.unarmedReach);
            out.write(this.bodyBipedObject.getValue());
            out.write(this.aimAngleTolerance);
            out.write(this.flightRadius);
            out.write(this.angularAcceleration);
            out.write(this.angularTolerance);
            out.write(this.flags2.export());
            if (this.mountData != null) {
                out.write(this.mountData);
            }
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            int i = 0;
            while (i < 7) {
                this.skillBoosts.add(ActorValue.value(in.extractInt(1)));
                this.skillBoostValues.add(in.extractIntSigned(1));
                ++i;
            }
            in.skip(2);
            this.maleHeight = in.extractFloat();
            this.femaleHeight = in.extractFloat();
            this.maleWeight = in.extractFloat();
            this.femaleWeight = in.extractFloat();
            this.flags.set(in.extract(4));
            this.startingHealth = in.extractFloat();
            this.startingMagicka = in.extractFloat();
            this.startingStamina = in.extractFloat();
            this.baseCarryWeight = in.extractFloat();
            this.baseMass = in.extractFloat();
            this.accelerationRate = in.extractFloat();
            this.decelerationRate = in.extractFloat();
            this.size = Size.values()[in.extractInt(4)];
            this.headBipedObject = FirstPersonFlags.getValue(in.extractInt(4));
            this.hairBipedObject = FirstPersonFlags.getValue(in.extractInt(4));
            this.injuredHealthPct = in.extractFloat();
            this.shieldBipedObject = FirstPersonFlags.getValue(in.extractInt(4));
            this.healthRegen = in.extractFloat();
            this.magickaRegen = in.extractFloat();
            this.staminaRegen = in.extractFloat();
            this.unarmedDamage = in.extractFloat();
            this.unarmedReach = in.extractFloat();
            this.bodyBipedObject = FirstPersonFlags.getValue(in.extractInt(4));
            this.aimAngleTolerance = in.extractFloat();
            this.flightRadius = in.extractFloat();
            this.angularAcceleration = in.extractFloat();
            this.angularTolerance = in.extractFloat();
            this.flags2.set(in.extract(4));
            if (!in.isDone().booleanValue()) {
                this.mountData = in.extract(36);
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        int getContentLength(ModExporter out) {
            if (this.mountData == null) {
                return 128;
            }
            return 164;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }

    public static enum RACEFlags {
        Playable,
        FaceGenHead,
        Child,
        TiltFrontBack,
        TiltLeftRight,
        NoShadow,
        Swims,
        Flies,
        Walks,
        Immobile,
        NotPushable,
        NoCombatInWater,
        NoRotatingToHeadTrack,
        DontShowBloodSpray,
        DontShowBloodDecal,
        UsesHeadTrackAnims,
        SpellsAlignWithMagicNode,
        UseWorldRaycastsForFootIK,
        AllowRagdollCollision,
        RegenHPInCombat,
        CantOpenDoors,
        AllowPCDialogue,
        NoKnockdowns,
        AllowPickpocket,
        AlwaysUseProxyController,
        DontShowWeaponBlood,
        OverlayHeadPartList,
        OverrideHeadPartList,
        CanPickupItems,
        AllowMultipleMembraneShaders,
        CanDualWeild,
        AvoidsRoads;

    }

    public static enum RaceFlags2 {
        UseAdvancedAvoidance(0),
        NonHostile(1),
        AllowMountedCombat(4);

        int val;

        private RaceFlags2(int val) {
            this.val = val;
        }
    }

    public static enum Size {
        SMALL,
        MEDIUM,
        LARGE,
        EXTRALARGE;

    }
}

