/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LByteChannel;
import lev.LFlags;
import lev.LImport;
import skyproc.Condition;
import skyproc.FormID;
import skyproc.KeywordSet;
import skyproc.MajorRecordNamed;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.ScriptPackage;
import skyproc.ScriptRef;
import skyproc.StringNonNull;
import skyproc.SubData;
import skyproc.SubFlag;
import skyproc.SubForm;
import skyproc.SubFormInt;
import skyproc.SubInt;
import skyproc.SubList;
import skyproc.SubListCounted;
import skyproc.SubListMulti;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubShell;
import skyproc.SubShellBulkType;
import skyproc.SubString;
import skyproc.SubStringPointer;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class QUST
extends MajorRecordNamed {
    static final SubPrototype ALSTALLSproto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(SubString.getNew("ALID", true));
            this.add(new SubFlag("FNAM", 4));
            this.add(new SubInt("ALFI"));
            this.add(new SubForm("ALFL"));
            this.add(new SubForm("ALFR"));
            this.add(new SubForm("ALUA"));
            this.add(new SubInt("ALFA"));
            this.add(new SubForm("KNAM"));
            this.add(new SubForm("ALRT"));
            this.add(new SubForm("ALEQ"));
            this.add(new SubInt("ALEA"));
            this.add(new SubForm("ALCO"));
            this.add(new SubData("ALCA"));
            this.add(new SubInt("ALCL"));
            this.add(new SubInt("ALNA"));
            this.add(new SubInt("ALNT"));
            this.add(SubString.getNew("ALFE", false));
            this.add(new SubInt("ALFD"));
            this.add(new SubList(new Condition()));
            this.add(new KeywordSet());
            this.add(new SubListCounted<SubFormInt>("COCT", 4, new SubFormInt("CNTO")));
            this.add(new SubForm("SPOR"));
            this.add(new SubForm("OCOR"));
            this.add(new SubForm("GWOR"));
            this.add(new SubForm("ECOR"));
            this.add(new SubForm("ALDN"));
            this.add(new SubList(new SubForm("ALSP")));
            this.add(new SubList(new SubForm("ALFC")));
            this.add(new SubList(new SubForm("ALPC")));
            this.add(new SubForm("VTCK"));
            this.add(new SubData("ALED"));
        }
    };
    static final SubPrototype aliasLocationProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new SubInt("ALLS"));
            this.mergeIn(ALSTALLSproto);
        }
    };
    static final SubPrototype aliasReferenceProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new SubInt("ALST"));
            this.mergeIn(ALSTALLSproto);
            this.forceExport("VTCK");
        }
    };
    static final SubPrototype questLogEntryProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new SubFlag("QSDT", 1));
            this.add(new SubForm("NAM0"));
            this.add(new SubStringPointer("CNAM", SubStringPointer.Files.DLSTRINGS));
            this.add(new SubData("SCHR"));
            this.add(new SubForm("QNAM"));
            this.add(SubString.getNew("SCTX", false));
            this.add(new SubList(new Condition()));
        }
    };
    static final SubPrototype questStageProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new INDX());
            this.add(new SubList(new QuestLogEntry()));
        }
    };
    static final SubPrototype questTargetProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new QuestTargetData());
            this.add(new SubList(new Condition()));
        }
    };
    static final SubPrototype questObjectiveProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new SubInt("QOBJ", 2));
            this.add(new SubData("FNAM"));
            this.add(new SubStringPointer("NNAM", SubStringPointer.Files.STRINGS));
            this.add(new SubList(new QuestTarget()));
        }
    };
    static final SubPrototype QUSTproto = new SubPrototype(MajorRecordNamed.namedProto){

        @Override
        protected void addRecords() {
            this.after(new ScriptPackage(new QUSTScriptFragments()), "EDID");
            this.reposition("FULL");
            this.add(new DNAM());
            this.add(SubString.getNew("ENAM", false));
            this.add(new SubList(new SubForm("QTGL")));
            this.add(SubString.getNew("FLTR", true));
            this.add(new SubList(new Condition()));
            this.add(new SubShellBulkType(new SubPrototype(){

                @Override
                protected void addRecords() {
                    this.add(new SubData("NEXT"));
                    this.forceExport("NEXT");
                    this.add(new SubList(new Condition()));
                }
            }, false));
            this.add(new SubList(new QuestStage()));
            this.add(new SubList(new QuestObjective()));
            this.add(new SubInt("ANAM"));
            this.add(new SubListMulti(new AliasLocation(), new AliasReference()));
        }
    };

    QUST() {
        this.subRecords.setPrototype(QUSTproto);
    }

    public QUST(String edid) {
        this();
        this.originateFromPatch(edid);
        DNAM dnam = (DNAM)this.subRecords.get("DNAM");
        dnam.flags.set(0, true);
        dnam.flags.set(4, true);
        dnam.flags.set(8, true);
        this.subRecords.getSubInt("ANAM").set(0);
    }

    @Override
    Record getNew() {
        return new QUST();
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("QUST");
    }

    public ScriptPackage getScriptPackage() {
        return this.subRecords.getScripts();
    }

    public ArrayList<Condition> getConditions() {
        return this.subRecords.getSubList("CTDA").toPublic();
    }

    public void addCondition(Condition c) {
        this.subRecords.getSubList("CTDA").add(c);
    }

    public void removeCondition(Condition c) {
        this.subRecords.getSubList("CTDA").remove(c);
    }

    public ArrayList<QuestStage> getQuestStages() {
        return this.subRecords.getSubList("INDX").toPublic();
    }

    public void addQuestStage(QuestStage stage) {
        this.subRecords.getSubList("INDX").add(stage);
    }

    DNAM getDNAM() {
        return (DNAM)this.subRecords.get("DNAM");
    }

    public int getPriority() {
        return this.getDNAM().priority;
    }

    public void setPriority(int priority) {
        if (priority < 0) {
            priority = 0;
        } else if (priority > 100) {
            priority = 100;
        }
        this.getDNAM().priority = (byte)priority;
    }

    public void set(QuestFlags flag, boolean on) {
        this.getDNAM().flags.set(flag.value, on);
    }

    public boolean get(QuestFlags flag) {
        return this.getDNAM().flags.get(flag.value);
    }

    public void setQuestType(QuestType type) {
        this.getDNAM().questType = type;
    }

    public QuestType getQuestType() {
        return this.getDNAM().questType;
    }

    public String getShortName() {
        return this.subRecords.getSubString("ENAM").print();
    }

    public void setShortName(String shortName) {
        this.subRecords.setSubString("ENAM", shortName);
    }

    public String getObjectWindowFilter() {
        return this.subRecords.getSubString("FLTR").print();
    }

    public void setObjectWindowFilter(String name) {
        this.subRecords.setSubString("FLTR", name);
    }

    public ArrayList<QuestStage> getStages() {
        return this.subRecords.getSubList("INDX").toPublic();
    }

    public void clearStages() {
        this.subRecords.getSubList("INDX").clear();
    }

    public void addStage(QuestStage stage) {
        this.subRecords.getSubList("INDX").add(stage);
    }

    public ArrayList<QuestObjective> getObjectives() {
        return this.subRecords.getSubList("QOBJ").toPublic();
    }

    public void clearObjectives() {
        this.subRecords.getSubList("QOBJ").clear();
    }

    public void addObjective(QuestObjective objective) {
        this.subRecords.getSubList("QOBJ").add(objective);
    }

    public ArrayList<Alias> getAliases() {
        return this.subRecords.getSubList("ALLS").toPublic();
    }

    public void addAlias(Alias alias) {
        this.subRecords.getSubList("ALLS").add(alias);
    }

    public void clearAliases() {
        this.subRecords.getSubList("ALLS").clear();
    }

    public static abstract class Alias
    extends SubShellBulkType {
        Alias(SubPrototype proto) {
            super(proto, false);
        }

        public void setName(String name) {
            this.subRecords.setSubStringPointer("ALID", name);
        }

        public String getName() {
            return this.subRecords.getSubString("ALID").print();
        }

        public abstract void setAliasID(int var1);

        public abstract int getAliasID();

        public void setAliasName(String name) {
            this.subRecords.setSubString("ALID", name);
        }

        public String getAliasName() {
            return this.subRecords.getSubString("ALID").print();
        }

        public void setUniqueActor(FormID id) {
        }

        public FormID getUniqueActor() {
            return FormID.NULL;
        }
    }

    public static class AliasLocation
    extends Alias {
        public AliasLocation(int val) {
            this();
            this.setAliasID(val);
        }

        AliasLocation() {
            super(aliasLocationProto);
        }

        public AliasLocation(String name) {
            this();
            this.setName(name);
        }

        @Override
        public void setAliasID(int val) {
            this.subRecords.setSubInt("ALLS", val);
        }

        @Override
        public int getAliasID() {
            return this.subRecords.getSubInt("ALLS").get();
        }
    }

    public static class AliasReference
    extends Alias {
        public AliasReference(int val) {
            this();
            this.setAliasID(val);
        }

        AliasReference() {
            super(aliasReferenceProto);
        }

        public AliasReference(String name) {
            this();
            this.setName(name);
        }

        @Override
        public void setAliasID(int val) {
            this.subRecords.setSubInt("ALST", val);
        }

        @Override
        public int getAliasID() {
            return this.subRecords.getSubInt("ALST").get();
        }

        @Override
        public FormID getUniqueActor() {
            return this.subRecords.getSubForm("ALUA").getForm();
        }

        @Override
        public void setUniqueActor(FormID id) {
            this.subRecords.setSubForm("ALUA", id);
        }
    }

    static class AliasScriptFragment {
        byte[] object = new byte[8];
        FormID object_FormID = FormID.NULL;
        int object_alias = -1;
        byte[] object_unused = new byte[2];
        int version;
        int format;
        int scriptCount;
        ArrayList<ScriptRef> scripts = new ArrayList();

        AliasScriptFragment() {
        }

        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            this.object = in.extract(8);
            this.version = in.extractInt(2);
            this.format = in.extractInt(2);
            LByteChannel objectChannel = new LByteChannel(this.object);
            if (this.format == 1) {
                this.object_FormID = new FormID();
                this.object_FormID.parseData((LImport)objectChannel, srcMod);
                this.object_alias = objectChannel.extractInt(2);
                this.object_unused = objectChannel.extract(2);
            } else if (this.format == 2) {
                this.object_unused = objectChannel.extract(2);
                this.object_alias = objectChannel.extractInt(2);
                this.object_FormID = new FormID();
                this.object_FormID.parseData((LImport)objectChannel, srcMod);
            } else {
                throw new UnsupportedOperationException("Unsupported VMAD Object format: " + this.format);
            }
            this.scriptCount = in.extractInt(2);
            int i = 0;
            while (i < this.scriptCount) {
                this.scripts.add(new ScriptRef(in, srcMod));
                ++i;
            }
        }

        void export(ModExporter out) throws IOException {
            if (this.format == 1) {
                this.object_FormID.export(out);
                out.write(this.object_alias, 2);
                out.write(this.object_unused);
            } else if (this.format == 2) {
                out.write(this.object_unused);
                out.write(this.object_alias, 2);
                this.object_FormID.export(out);
            }
            out.write(this.version, 2);
            out.write(this.format, 2);
            out.write(this.scripts.size(), 2);
            for (ScriptRef s : this.scripts) {
                s.export(out);
            }
        }

        int getContentLength(ModExporter out) {
            int size = 0;
            for (ScriptRef s : this.scripts) {
                size += s.getTotalLength(out);
            }
            return 14 + size;
        }
    }

    static class DNAM
    extends SubRecord {
        LFlags flags = new LFlags(2);
        byte priority = 0;
        byte unknown = 0;
        int unknown2 = 0;
        QuestType questType = QuestType.None;

        DNAM() {
        }

        @Override
        SubRecord getNew(String type) {
            return new DNAM();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 12;
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.flags.export());
            out.write(this.priority, 1);
            out.write(this.unknown, 1);
            out.write(this.unknown2);
            out.write(this.questType.ordinal());
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
            super.parseData(in, srcMod);
            this.flags.set(in.extract(2));
            this.priority = in.extract(1)[0];
            this.unknown = in.extract(1)[0];
            this.unknown2 = in.extractInt(4);
            this.questType = QuestType.values()[in.extractInt(4)];
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DNAM");
        }
    }

    static class INDX
    extends SubRecord {
        int index = 0;
        LFlags flags = new LFlags(2);

        INDX() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.index, 2);
            out.write(this.flags.export());
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
            super.parseData(in, srcMod);
            this.index = in.extractInt(2);
            this.flags.set(in.extract(2));
        }

        @Override
        SubRecord getNew(String type) {
            return new INDX();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 4;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("INDX");
        }
    }

    static class QUSTScriptFragment {
        int questStage;
        int unknown1;
        int questStageIndex;
        int unknown2;
        StringNonNull scriptName = new StringNonNull();
        StringNonNull fragmentName = new StringNonNull();

        QUSTScriptFragment() {
        }

        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            this.questStage = in.extractInt(2);
            this.unknown1 = in.extractInt(2);
            this.questStageIndex = in.extractInt(4);
            this.unknown2 = in.extractInt(1);
            this.scriptName.set(in.extractString(in.extractInt(2)));
            this.fragmentName.set(in.extractString(in.extractInt(2)));
        }

        void export(ModExporter out) throws IOException {
            out.write(this.questStage, 2);
            out.write(this.unknown1, 2);
            out.write(this.questStageIndex);
            out.write(this.unknown2, 1);
            this.scriptName.export(out);
            this.fragmentName.export(out);
        }

        int getContentLength(ModExporter out) {
            return 9 + this.scriptName.getTotalLength(out) + this.fragmentName.getTotalLength(out);
        }
    }

    static class QUSTScriptFragments
    extends SubRecord {
        byte unknown = 0;
        StringNonNull fragmentFile = new StringNonNull();
        ArrayList<QUSTScriptFragment> questFragments = new ArrayList();
        ArrayList<AliasScriptFragment> aliasFragments = new ArrayList();
        boolean valid = false;

        QUSTScriptFragments() {
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            this.unknown = in.extract(1)[0];
            int fragmentCount = in.extractInt(2);
            this.fragmentFile.set(in.extractString(in.extractInt(2)));
            int i = 0;
            while (i < fragmentCount) {
                QUSTScriptFragment frag = new QUSTScriptFragment();
                frag.parseData(in, srcMod);
                this.questFragments.add(frag);
                ++i;
            }
            int aliasCount = in.extractInt(2);
            int i2 = 0;
            while (i2 < aliasCount) {
                AliasScriptFragment frag = new AliasScriptFragment();
                frag.parseData(in, srcMod);
                this.aliasFragments.add(frag);
                ++i2;
            }
            this.valid = true;
        }

        @Override
        void export(ModExporter out) throws IOException {
            if (!this.valid) {
                return;
            }
            out.write(this.unknown, 1);
            out.write(this.questFragments.size(), 2);
            this.fragmentFile.export(out);
            for (QUSTScriptFragment qUSTScriptFragment : this.questFragments) {
                qUSTScriptFragment.export(out);
            }
            out.write(this.aliasFragments.size(), 2);
            for (AliasScriptFragment aliasScriptFragment : this.aliasFragments) {
                aliasScriptFragment.export(out);
            }
        }

        @Override
        int getContentLength(ModExporter out) {
            if (!this.valid) {
                return 0;
            }
            int len = 3;
            len += this.fragmentFile.getTotalLength(out);
            for (QUSTScriptFragment qUSTScriptFragment : this.questFragments) {
                len += qUSTScriptFragment.getContentLength(out);
            }
            len += 2;
            for (AliasScriptFragment aliasScriptFragment : this.aliasFragments) {
                len += aliasScriptFragment.getContentLength(out);
            }
            return len;
        }

        @Override
        SubRecord getNew(String type) {
            return new QUSTScriptFragments();
        }

        @Override
        ArrayList<String> getTypes() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static enum QuestFlags {
        StartGameEnabled(0),
        WildernessEncounter(2),
        AllowRepeatedStages(3),
        RunOnce(4),
        ExcludeFromDialogueExport(5),
        WarnOnAliasFillFailure(6);

        int value;

        private QuestFlags(int val) {
            this.value = val;
        }
    }

    public static class QuestLogEntry
    extends SubShell {
        public QuestLogEntry() {
            super(questLogEntryProto);
        }

        @Override
        SubRecord getNew(String type) {
            return new QuestLogEntry();
        }

        public void set(QuestLogFlags flag, boolean on) {
            this.subRecords.setSubFlag("QSDT", flag.ordinal(), on);
        }

        public boolean get(QuestLogFlags flag) {
            return this.subRecords.getSubFlag("QSDT").is(flag.ordinal());
        }

        public ArrayList<Condition> getConditions() {
            return this.subRecords.getSubList("CTDA").toPublic();
        }

        public void addCondition(Condition c) {
            this.subRecords.getSubList("CTDA").add(c);
        }

        public void removeCondition(Condition c) {
            this.subRecords.getSubList("CTDA").remove(c);
        }

        public void setJournalText(String text) {
            this.subRecords.setSubStringPointer("CNAM", text);
        }

        public String getJournalText() {
            return this.subRecords.getSubStringPointer("CNAM").print();
        }

        public void setNextQuest(FormID id) {
            this.subRecords.setSubForm("NAM0", id);
        }

        public FormID getNextQuest() {
            return this.subRecords.getSubForm("NAM0").getForm();
        }
    }

    public static enum QuestLogFlags {
        CompleteQuest,
        FailQuest;

    }

    public static class QuestObjective
    extends SubShellBulkType {
        QuestObjective() {
            super(questObjectiveProto, false);
        }

        public QuestObjective(int index, String name) {
            this();
            this.setIndex(index);
            this.setName(name);
        }

        @Override
        SubRecord getNew(String type) {
            return new QuestObjective();
        }

        public final void setIndex(int index) {
            this.subRecords.setSubInt("QOBJ", index);
        }

        public int getIndex() {
            return this.subRecords.getSubInt("QOBJ").get();
        }

        public final void setName(String in) {
            this.subRecords.setSubStringPointer("NNAM", in);
        }

        public String getName() {
            return this.subRecords.getSubStringPointer("NNAM").print();
        }

        public ArrayList<QuestTarget> getTargets() {
            return this.subRecords.getSubList("QSTA").toPublic();
        }

        public void clearTargets() {
            this.subRecords.getSubList("QSTA").clear();
        }

        public void addTarget(QuestTarget target) {
            this.subRecords.getSubList("QSTA").add(target);
        }
    }

    public static class QuestStage
    extends SubShellBulkType {
        public QuestStage() {
            super(questStageProto, false);
        }

        INDX getINDX() {
            return (INDX)this.subRecords.get("INDX");
        }

        public int getJournalIndex() {
            return this.getINDX().index;
        }

        public void setJournalIndex(int value) {
            this.getINDX().index = value;
        }

        public boolean get(QuestStageFlags flag) {
            return this.getINDX().flags.get(flag.ordinal() + 1);
        }

        public void set(QuestStageFlags flag, boolean on) {
            this.getINDX().flags.set(flag.ordinal() + 1, on);
        }

        public ArrayList<QuestLogEntry> getLogEntries() {
            return this.subRecords.getSubList("QSDT").toPublic();
        }

        public void addLogEntry(QuestLogEntry entry) {
            this.subRecords.getSubList("QSDT").add(entry);
        }
    }

    public static enum QuestStageFlags {
        StartUpStage,
        ShutDownStage,
        KeepInstanceDataFromHereOn;

    }

    public static class QuestTarget
    extends SubShell {
        QuestTarget() {
            super(questTargetProto);
        }

        public QuestTarget(int aliasID) {
            this();
            this.setTargetAlias(aliasID);
        }

        @Override
        SubRecord getNew(String type) {
            return new QuestTarget();
        }

        QuestTargetData getData() {
            return (QuestTargetData)this.subRecords.get("QSDT");
        }

        public final void setTargetAlias(int aliasID) {
            this.getData().targetAlias = aliasID;
        }

        public int getTargetAlias() {
            return this.getData().targetAlias;
        }

        public ArrayList<Condition> getConditions() {
            return this.subRecords.getSubList("CTDA").toPublic();
        }

        public void addCondition(Condition c) {
            this.subRecords.getSubList("CTDA").add(c);
        }

        public void removeCondition(Condition c) {
            this.subRecords.getSubList("CTDA").remove(c);
        }

        public void setCompassMarkersIgnoreLocks(boolean on) {
            this.getData().flags.set(0, on);
        }

        public boolean getCompassMarkersIgnoreLocks() {
            return this.getData().flags.get(0);
        }
    }

    static class QuestTargetData
    extends SubRecord {
        int targetAlias = 0;
        LFlags flags = new LFlags(4);

        QuestTargetData() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.targetAlias);
            out.write(this.flags.export());
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
            super.parseData(in, srcMod);
            this.targetAlias = in.extractInt(4);
            this.flags.set(in.extract(4));
        }

        @Override
        SubRecord getNew(String type) {
            return new QuestTargetData();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 8;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("QSTA");
        }
    }

    public static enum QuestType {
        None,
        MainQuest,
        MageGuild,
        ThievesGuild,
        DarkBrotherhood,
        Companion,
        Misc,
        Daedric,
        Side,
        CivilWar,
        Vampire,
        Dragonborn;

    }
}

