/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.DestructionData;
import skyproc.FormID;
import skyproc.MajorRecordNamed;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.Record;
import skyproc.SubData;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class PROJ
extends MajorRecordNamed {
    static final SubPrototype PROJprototype = new SubPrototype(MajorRecordNamed.namedProto){

        @Override
        protected void addRecords() {
            this.add(new SubData("OBND", new byte[12]));
            this.reposition("FULL");
            this.add(new Model());
            this.add(new DestructionData());
            this.add(new DATA());
            this.add(SubString.getNew("NAM1", true));
            this.add(new SubData("NAM2"));
            this.add(new SubData("VNAM"));
        }
    };

    PROJ() {
        this.subRecords.setPrototype(PROJprototype);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("PROJ");
    }

    @Override
    Record getNew() {
        return new PROJ();
    }

    public void setModel(String path) {
        this.subRecords.getModel().setFileName(path);
    }

    public String getModel() {
        return this.subRecords.getModel().getFileName();
    }

    public void setEffectModel(String filename) {
        this.subRecords.setSubString("NAM1", filename);
    }

    public String getEffectModel() {
        return this.subRecords.getSubString("NAM1").print();
    }

    DATA getDATA() {
        return (DATA)this.subRecords.get("DATA");
    }

    public void set(ProjectileFlag flag, boolean on) {
        this.getDATA().flags.set(flag.value, on);
    }

    public boolean get(ProjectileFlag flag) {
        return this.getDATA().flags.get(flag.value);
    }

    public void setProjType(ProjectileType t) {
        LFlags flags = this.getDATA().projType;
        flags.clear();
        flags.set(t.ordinal(), true);
    }

    public ProjectileType getProjType() {
        return ProjectileType.values()[this.getDATA().projType.getFirstTrue()];
    }

    public void setGravity(float gravity) {
        this.getDATA().gravity = gravity;
    }

    public float getGravity() {
        return this.getDATA().gravity;
    }

    public void setSpeed(float speed) {
        this.getDATA().speed = speed;
    }

    public float getSpeed() {
        return this.getDATA().speed;
    }

    public void setRange(float range) {
        this.getDATA().range = range;
    }

    public float getRange() {
        return this.getDATA().range;
    }

    public void setLight(FormID light) {
        this.getDATA().light = light;
    }

    public FormID getLight() {
        return this.getDATA().light;
    }

    public void setMuzzleLight(FormID light) {
        this.getDATA().muzzleLight = light;
    }

    public FormID getMuzzleLight() {
        return this.getDATA().muzzleLight;
    }

    public void setTracerChance(float chance) {
        this.getDATA().tracerChance = chance;
    }

    public float getTracerChance() {
        return this.getDATA().tracerChance;
    }

    public void setProximity(float proximity) {
        this.getDATA().proximity = proximity;
    }

    public float getProximity() {
        return this.getDATA().proximity;
    }

    public void setTimer(float timer) {
        this.getDATA().timer = timer;
    }

    public float getTimer() {
        return this.getDATA().timer;
    }

    public void setExplosionType(FormID explType) {
        this.getDATA().explosionType = explType;
    }

    public FormID getExplosionType() {
        return this.getDATA().explosionType;
    }

    public void setSound(FormID sound) {
        this.getDATA().sound = sound;
    }

    public FormID getSound() {
        return this.getDATA().sound;
    }

    public void setMuzzleFlashDuration(float duration) {
        this.getDATA().muzzleFlashDuration = duration;
    }

    public float getMuzzleFlashDuration() {
        return this.getDATA().muzzleFlashDuration;
    }

    public void setFadeDuration(float duration) {
        this.getDATA().fadeDuration = duration;
    }

    public float getFadeDuration() {
        return this.getDATA().fadeDuration;
    }

    public void setImpactForce(float force) {
        this.getDATA().impactForce = force;
    }

    public float getImpactForce() {
        return this.getDATA().impactForce;
    }

    public void setExplosionSound(FormID sound) {
        this.getDATA().explosionSound = sound;
    }

    public FormID getExplosionSound() {
        return this.getDATA().explosionSound;
    }

    public void setDisableSound(FormID sound) {
        this.getDATA().disableSound = sound;
    }

    public FormID getDisableSound() {
        return this.getDATA().disableSound;
    }

    public void setDefaultWeaponSource(FormID weaponSource) {
        this.getDATA().defaultWeaponSource = weaponSource;
    }

    public FormID getDefaultWeaponSource() {
        return this.getDATA().defaultWeaponSource;
    }

    public void setConeSpread(float spread) {
        this.getDATA().coneSpread = spread;
    }

    public float getConeSpread() {
        return this.getDATA().coneSpread;
    }

    public void setCollisionRadius(float radius) {
        this.getDATA().collisionRadius = radius;
    }

    public float getCollisionRadius() {
        return this.getDATA().collisionRadius;
    }

    public void setLifetime(float lifetime) {
        this.getDATA().lifetime = lifetime;
    }

    public float getLifetime() {
        return this.getDATA().lifetime;
    }

    public void setRelaunchInterval(float interval) {
        this.getDATA().relaunchInterval = interval;
    }

    public float getRelaunchInterval() {
        return this.getDATA().relaunchInterval;
    }

    public void setDecalData(FormID decal) {
        this.getDATA().decalData = decal;
    }

    public FormID getDecalData() {
        return this.getDATA().decalData;
    }

    public Model getModelData() {
        return this.subRecords.getModel();
    }

    static class DATA
    extends SubRecord {
        LFlags flags = new LFlags(2);
        LFlags projType = new LFlags(2);
        float gravity = 0.0f;
        float speed = 0.0f;
        float range = 0.0f;
        FormID light = new FormID();
        FormID muzzleLight = new FormID();
        float tracerChance = 0.0f;
        float proximity = 0.0f;
        float timer = 0.0f;
        FormID explosionType = new FormID();
        FormID sound = new FormID();
        float muzzleFlashDuration = 0.0f;
        float fadeDuration = 0.0f;
        float impactForce = 0.0f;
        FormID explosionSound = new FormID();
        FormID disableSound = new FormID();
        FormID defaultWeaponSource = new FormID();
        float coneSpread = 0.0f;
        float collisionRadius = 0.0f;
        float lifetime = 0.0f;
        float relaunchInterval = 0.0f;
        FormID decalData = new FormID();
        byte[] collisionLayer = new byte[4];

        DATA() {
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>();
            out.add(this.light);
            out.add(this.muzzleLight);
            out.add(this.explosionType);
            out.add(this.sound);
            out.add(this.explosionSound);
            out.add(this.disableSound);
            out.add(this.defaultWeaponSource);
            out.add(this.decalData);
            return out;
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.flags.export(), 2);
            out.write(this.projType.export(), 2);
            out.write(this.gravity);
            out.write(this.speed);
            out.write(this.range);
            this.light.export(out);
            this.muzzleLight.export(out);
            out.write(this.tracerChance);
            out.write(this.proximity);
            out.write(this.timer);
            this.explosionType.export(out);
            this.sound.export(out);
            out.write(this.muzzleFlashDuration);
            out.write(this.fadeDuration);
            out.write(this.impactForce);
            this.explosionSound.export(out);
            this.disableSound.export(out);
            this.defaultWeaponSource.export(out);
            out.write(this.coneSpread);
            out.write(this.collisionRadius);
            out.write(this.lifetime);
            out.write(this.relaunchInterval);
            this.decalData.export(out);
            out.write(this.collisionLayer);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
            super.parseData(in, srcMod);
            this.flags.set(in.extract(2));
            this.projType.set(in.extract(2));
            this.gravity = in.extractFloat();
            this.speed = in.extractFloat();
            this.range = in.extractFloat();
            this.light.parseData(in, srcMod);
            this.muzzleLight.parseData(in, srcMod);
            this.tracerChance = in.extractFloat();
            this.proximity = in.extractFloat();
            this.timer = in.extractFloat();
            this.explosionType.parseData(in, srcMod);
            this.sound.parseData(in, srcMod);
            this.muzzleFlashDuration = in.extractFloat();
            this.fadeDuration = in.extractFloat();
            this.impactForce = in.extractFloat();
            this.explosionSound.parseData(in, srcMod);
            this.disableSound.parseData(in, srcMod);
            this.defaultWeaponSource.parseData(in, srcMod);
            this.coneSpread = in.extractFloat();
            this.collisionRadius = in.extractFloat();
            this.lifetime = in.extractFloat();
            this.relaunchInterval = in.extractFloat();
            if (!in.isDone().booleanValue()) {
                this.decalData.parseData(in, srcMod);
            }
            if (!in.isDone().booleanValue()) {
                this.collisionLayer = in.extract(4);
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 92;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }

    public static enum ProjectileFlag {
        Explosion(1),
        AltTrigger(2),
        MuzzleFlash(3),
        CanBeDisabled(5),
        CanBePickedUp(6),
        SuperSonic(7),
        CritPinsLimbs(8),
        PassThroughSmallTransparent(9),
        DisableCombatAimCorrection(10);

        int value;

        private ProjectileFlag(int val) {
            this.value = val;
        }
    }

    public static enum ProjectileType {
        Missile,
        Lobber,
        Beam,
        Flame,
        Cone,
        Barrier,
        Arrow;


        static ProjectileType get(int value) {
            switch (value) {
                case 1: {
                    return Missile;
                }
                case 2: {
                    return Lobber;
                }
                case 4: {
                    return Beam;
                }
                case 8: {
                    return Flame;
                }
                case 16: {
                    return Cone;
                }
                case 32: {
                    return Barrier;
                }
            }
            return Arrow;
        }
    }
}

