/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import lev.Ln;
import skyproc.FormID;
import skyproc.GRUP_TYPE;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SPDatabase;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class Owner
extends SubRecordTyped {
    FormID owner = new FormID();
    FormID global = new FormID();
    int reqRank = 0;
    float itemCondition = 0.0f;

    Owner() {
        super("COED");
    }

    @Override
    SubRecord getNew(String type) {
        return new Owner();
    }

    @Override
    ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> out = new ArrayList<FormID>(2);
        out.add(this.owner);
        out.add(this.global);
        return out;
    }

    @Override
    void export(ModExporter out) throws IOException {
        super.export(out);
        this.owner.export(out);
        if (this.isNPCOwner()) {
            this.global.export(out);
        } else {
            out.write(this.reqRank);
        }
        out.write(this.itemCondition);
    }

    boolean isNPCOwner() {
        return SPDatabase.queryMajor(this.owner, GRUP_TYPE.NPC_);
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.owner.parseData(in, srcMod);
        this.global.parseData(in, srcMod);
        this.reqRank = Ln.arrayToInt((byte[])this.global.form);
        this.itemCondition = in.extractFloat();
    }

    @Override
    boolean isValid() {
        return !this.owner.isNull() || !this.isNPCOwner() && !this.global.isNull() || (double)this.itemCondition != 0.0;
    }

    @Override
    int getContentLength(ModExporter out) {
        return 12;
    }

    float getItemCondition() {
        return this.itemCondition;
    }

    void setItemCondition(float itemCondition) {
        this.itemCondition = itemCondition;
    }
}

