/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import lev.LImport;
import lev.LInChannel;
import lev.LPair;
import lev.LShrinkArray;
import lev.Ln;
import skyproc.SPGlobal;
import skyproc.exceptions.BadParameter;

public class NIF {
    private static String header = "NIF";
    String fileName;
    int numBlocks;
    ArrayList<String> blockTypes;
    ArrayList<Node> nodes;
    long headerOffset;

    public NIF(File f) throws FileNotFoundException, IOException, BadParameter {
        LInChannel in = new LInChannel(f);
        this.fileName = f.getPath();
        this.parseData(new LShrinkArray(in.extractByteBuffer(0, in.available())));
    }

    public NIF(String filename, LShrinkArray in) throws BadParameter {
        this.fileName = filename;
        this.parseData(in);
    }

    final void parseData(LShrinkArray in) throws BadParameter {
        this.loadHeader(in);
    }

    void loadHeader(LShrinkArray in) throws BadParameter {
        byte first;
        if (SPGlobal.debugNIFimport) {
            SPGlobal.logSync(header, "Loading nif file");
        }
        if (!in.getString(20).equals("Gamebryo File Format") && !in.extractString((int)(first = in.extract(1)[0]), 20).equals("Gamebryo File Format")) {
            throw new BadParameter(String.valueOf(this.fileName) + " was not a NIF file.");
        }
        in.extractLine();
        this.numBlocks = in.extractInt(9, 4);
        if (SPGlobal.debugNIFimport && SPGlobal.logging()) {
            SPGlobal.logSync(header, "Num Blocks: " + this.numBlocks);
        }
        in.skip(in.extractInt(4, 1));
        in.skip(in.extractInt(1));
        in.skip(in.extractInt(1));
        int numBlockTypes = in.extractInt(2);
        if (SPGlobal.debugNIFimport && SPGlobal.logging()) {
            SPGlobal.logSync(header, "Num Block Types: " + numBlockTypes);
        }
        this.blockTypes = new ArrayList(numBlockTypes);
        int i = 0;
        while (i < numBlockTypes) {
            String blockType = in.extractString(in.extractInt(4));
            this.blockTypes.add(blockType);
            if (SPGlobal.debugNIFimport && SPGlobal.logging()) {
                SPGlobal.logSync(header, "  Added block type[" + i + "]: " + blockType);
            }
            ++i;
        }
        if (SPGlobal.debugNIFimport && SPGlobal.logging()) {
            SPGlobal.logSync(header, "Block Type list: ");
        }
        this.nodes = new ArrayList(this.numBlocks);
        i = 0;
        while (i < this.numBlocks) {
            int type = in.extractInt(2);
            Node n = new Node(NodeType.SPvalueOf(this.blockTypes.get(type)));
            n.number = i;
            this.nodes.add(n);
            if (SPGlobal.debugNIFimport && SPGlobal.logging()) {
                SPGlobal.logSync(header, "  Block list[" + i + "] has block type: " + type + ", " + this.blockTypes.get(type));
            }
            ++i;
        }
        i = 0;
        while (i < this.numBlocks) {
            this.nodes.get((int)i).size = in.extractInt(4);
            ++i;
        }
        if (SPGlobal.debugNIFimport && SPGlobal.logging()) {
            SPGlobal.logSync(header, "Block headers: ");
            i = 0;
            while (i < this.numBlocks) {
                SPGlobal.logSync(header, "  [" + i + "]: " + (Object)((Object)this.nodes.get((int)i).type) + ", length: " + Ln.prettyPrintHex((int)this.nodes.get((int)i).size));
                ++i;
            }
        }
        if (SPGlobal.debugNIFimport && SPGlobal.logging()) {
            SPGlobal.logSync(header, "Block Titles: ");
        }
        int numStrings = in.extractInt(4);
        in.skip(4);
        ArrayList<String> strings = new ArrayList<String>(numStrings);
        int i2 = 0;
        while (i2 < numStrings) {
            strings.add(in.extractString(in.extractInt(4)));
            ++i2;
        }
        in.skip(4);
        i2 = 0;
        while (i2 < this.numBlocks) {
            this.nodes.get((int)i2).data = new LShrinkArray((LImport)in, this.nodes.get((int)i2).size);
            in.skip(this.nodes.get((int)i2).size);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.numBlocks) {
            NodeType type = this.nodes.get((int)i2).type;
            if (type == NodeType.NINODE || type == NodeType.NITRISHAPE || type == NodeType.BSINVMARKER || type == NodeType.BSBEHAVIORGRAPHEXTRADATA) {
                Node n = this.nodes.get(i2);
                int stringIndex = n.data.getInts(0, 4)[0];
                n.title = (String)strings.get(stringIndex);
                if (SPGlobal.debugNIFimport && SPGlobal.logging()) {
                    SPGlobal.log(header, "  [" + i2 + "]: " + (Object)((Object)this.nodes.get((int)i2).type) + ", string: " + this.nodes.get((int)i2).title);
                }
            }
            ++i2;
        }
    }

    public ArrayList<NodeType> getNodeTypes() {
        ArrayList<NodeType> out = new ArrayList<NodeType>(this.nodes.size());
        int i = 0;
        while (i < this.nodes.size()) {
            out.add(this.nodes.get((int)i).type);
            ++i;
        }
        return out;
    }

    public Node getNode(int i) {
        return new Node(this.nodes.get(i));
    }

    public String getNodeTitle(int i) {
        return this.nodes.get((int)i).title;
    }

    public Map<Integer, Node> getNodes(NodeType type) {
        TreeMap<Integer, Node> out = new TreeMap<Integer, Node>();
        String name = "";
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = this.getNode(i);
            if (n.type == NodeType.NITRISHAPE) {
                name = n.title;
            }
            if (n.type == type) {
                if (n.title == null) {
                    n.title = name;
                }
                out.put(n.number, n);
            }
            ++i;
        }
        return out;
    }

    public ArrayList<ArrayList<Node>> getNiTriShapePackages() {
        ArrayList<ArrayList<Node>> out = new ArrayList<ArrayList<Node>>();
        ArrayList<Node> NiTriShapePackage = new ArrayList<Node>();
        boolean on = false;
        String title = "";
        for (Node n : this.nodes) {
            if (n.type == NodeType.NITRISHAPE) {
                NiTriShapePackage = new ArrayList();
                out.add(NiTriShapePackage);
                title = n.title;
                NiTriShapePackage.add(n);
                on = true;
                continue;
            }
            if (!on) continue;
            n.title = title;
            NiTriShapePackage.add(n);
        }
        return out;
    }

    public Map<Integer, LPair<String, ArrayList<String>>> extractTextures() {
        HashMap<Integer, LPair<String, ArrayList<String>>> out = new HashMap<Integer, LPair<String, ArrayList<String>>>();
        Map<Integer, Node> BiLightingShaderProperties = this.getNodes(NodeType.BSLIGHTINGSHADERPROPERTY);
        Map<Integer, Node> BiShaderTextureNodes = this.getNodes(NodeType.BSSHADERTEXTURESET);
        HashMap<Integer, ArrayList<String>> BiShaderTextureSets = new HashMap<Integer, ArrayList<String>>();
        for (Integer i : BiShaderTextureNodes.keySet()) {
            BiShaderTextureSets.put(i, NIF.extractBSTextures(BiShaderTextureNodes.get(i)));
        }
        TreeMap<Integer, Node> together = new TreeMap<Integer, Node>();
        together.putAll(BiLightingShaderProperties);
        together.putAll(this.getNodes(NodeType.BSEFFECTSHADERPROPERTY));
        int i = 0;
        for (Integer key : together.keySet()) {
            if (BiLightingShaderProperties.containsKey(key)) {
                String name = BiLightingShaderProperties.get((Object)key).title;
                int textureLink = BiLightingShaderProperties.get((Object)key).data.extractInt(40, 4);
                ArrayList textures = (ArrayList)BiShaderTextureSets.get(textureLink);
                if (textures != null) {
                    LPair pair = new LPair((Object)name, new ArrayList(textures));
                    out.put(i, (LPair<String, ArrayList<String>>)pair);
                }
            }
            ++i;
        }
        return out;
    }

    public ArrayList<TextureSet> extractTextureSets() {
        Map<Integer, LPair<String, ArrayList<String>>> data = this.extractTextures();
        ArrayList<TextureSet> out = new ArrayList<TextureSet>(data.size());
        for (Integer i : data.keySet()) {
            out.add(new TextureSet(i, data.get(i)));
        }
        return out;
    }

    public static ArrayList<String> extractBSTextures(Node n) {
        int numTextures = n.data.extractInt(4);
        ArrayList<String> maps = new ArrayList<String>(numTextures);
        int i = 0;
        while (i < numTextures) {
            maps.add(n.data.extractString(n.data.extractInt(4)));
            ++i;
        }
        return maps;
    }

    public class Node {
        public String title;
        public NodeType type;
        int size;
        public LShrinkArray data;
        public int number;

        Node(NodeType n) {
            this.type = n;
        }

        Node(Node in) {
            this.title = in.title;
            this.type = in.type;
            this.size = in.size;
            this.data = new LShrinkArray(in.data);
            this.number = in.number;
        }
    }

    public static enum NodeType {
        NINODE,
        BSBEHAVIORGRAPHEXTRADATA,
        NICONTROLLERSEQUENCE,
        BSINVMARKER,
        NITRISHAPE,
        NITRISHAPEDATA,
        NISKININSTANCE,
        NISKINDATA,
        NISKINPARTITION,
        BSLIGHTINGSHADERPROPERTY,
        BSEFFECTSHADERPROPERTY,
        BSSHADERTEXTURESET,
        NIALPHAPROPERTY,
        UNKNOWN;


        static NodeType SPvalueOf(String in) {
            try {
                return NodeType.valueOf(in.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }

    public static class TextureSet {
        int index;
        String name;
        ArrayList<String> textures;

        public TextureSet(Integer i, LPair<String, ArrayList<String>> data) {
            this(i, (String)data.a, (ArrayList)data.b);
        }

        public TextureSet(Integer i, String name, ArrayList<String> tex) {
            this.index = i;
            this.name = name;
            this.textures = tex;
        }

        public TextureSet(TextureSet rhs) {
            this.index = rhs.index;
            this.name = rhs.name;
            this.textures = new ArrayList<String>(rhs.textures);
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public ArrayList<String> getTextures() {
            return this.textures;
        }

        public String toString() {
            return this.name;
        }
    }
}

