/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SPDatabase;
import skyproc.SPGlobal;
import skyproc.SubData;
import skyproc.SubRecord;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class ModListing
extends SubRecord<ModListing>
implements Comparable {
    private static final ArrayList<String> type = new ArrayList<String>(Arrays.asList("MAST", "DATA"));
    static ModListing skyrim = new ModListing("Skyrim.esm");
    static ModListing update = new ModListing("Update.esm");
    SubString mast = SubString.getNew("MAST", true);
    boolean master = false;
    boolean falseMaster = false;
    int strHash = 0;

    public ModListing(String name, Boolean master) {
        this(name);
        this.master = master;
        this.falseMaster = false;
    }

    public ModListing(String nameWithSuffix) {
        this();
        this.setString(nameWithSuffix);
    }

    ModListing() {
    }

    final void setString(String in) {
        String upper = in.toUpperCase();
        if (upper.contains(".ESM")) {
            this.setMasterTag(true);
            in = in.substring(0, upper.indexOf(".ES"));
        } else if (upper.contains(".ESP")) {
            this.setMasterTag(false);
            in = in.substring(0, upper.indexOf(".ES"));
        }
        this.mast.setString(in);
        this.strHash = 259 + this.mast.hashUpperCaseCode();
    }

    @Override
    public String print() {
        if (this.master && !this.falseMaster) {
            return String.valueOf(this.printNoSuffix()) + ".esm";
        }
        return String.valueOf(this.printNoSuffix()) + ".esp";
    }

    public String printNoSuffix() {
        return this.mast.print();
    }

    @Override
    public String toString() {
        return this.print();
    }

    @Override
    void export(ModExporter out) throws IOException {
        this.mast.string = this.print();
        this.mast.export(out);
        SubData data = new SubData("DATA");
        data.initialize(8);
        data.export(out);
        this.setString(this.print());
    }

    @Override
    final void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        switch (ModListing.getNextType(in)) {
            case "MAST": {
                this.mast.parseData(in, srcMod);
                this.setString(this.mast.string);
            }
        }
    }

    @Override
    SubRecord getNew(String type_) {
        return new ModListing();
    }

    @Override
    int getContentLength(ModExporter out) {
        return this.mast.getContentLength(out) + 14 + 4;
    }

    @Override
    boolean isValid() {
        return this.mast.isValid();
    }

    void setMasterTag(Boolean in) {
        this.master = in;
    }

    boolean getMasterTag() {
        return this.master;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Mod) {
            obj = ((Mod)obj).getInfo();
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModListing other = (ModListing)obj;
        if (!(this.mast == other.mast || this.mast != null && this.mast.equalsIgnoreCase(other.mast))) {
            return false;
        }
        return this.master == other.master;
    }

    public int hashCode() {
        int hash = this.strHash;
        hash = 37 * hash + (this.master ? 1 : 0);
        return hash;
    }

    public int compareTo(Object o) {
        ModListing rhs = (ModListing)o;
        if (this.equals(rhs)) {
            return 0;
        }
        if ((this.master || this.falseMaster) && !rhs.master && !rhs.falseMaster) {
            return -1;
        }
        if (!this.master && !this.falseMaster && (rhs.master || rhs.falseMaster)) {
            return 1;
        }
        if (SPGlobal.getGlobalPatch() != null) {
            if (this.equals(SPGlobal.getGlobalPatch().getInfo())) {
                return 1;
            }
            if (rhs.equals(SPGlobal.getGlobalPatch().getInfo())) {
                return -1;
            }
        }
        if (this.equals(skyrim)) {
            return -1;
        }
        if (rhs.equals(skyrim)) {
            return 1;
        }
        if (this.equals(update)) {
            return -1;
        }
        if (rhs.equals(update)) {
            return 1;
        }
        boolean thisActive = SPDatabase.activePlugins.contains(this);
        boolean rhsActive = SPDatabase.activePlugins.contains(rhs);
        if (thisActive) {
            if (!rhsActive) {
                return -1;
            }
            int comp = SPDatabase.activePlugins.indexOf(this) - SPDatabase.activePlugins.indexOf(rhs);
            if (comp != 0) {
                return comp;
            }
            return 1;
        }
        if (rhsActive) {
            return 1;
        }
        SPGlobal.getDB();
        int n = SPDatabase.addedPlugins.indexOf(this);
        SPGlobal.getDB();
        int comp = n - SPDatabase.addedPlugins.indexOf(rhs);
        if (comp != 0) {
            return comp;
        }
        return 1;
    }

    @Override
    ArrayList<String> getTypes() {
        return type;
    }

    public boolean isFalseMaster() {
        return this.falseMaster;
    }

    public void setFalseMaster(boolean falseMaster) {
        this.falseMaster = falseMaster;
    }
}

