/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.DataFormatException;
import lev.LByteChannel;
import lev.LFlags;
import lev.LImport;
import lev.LInChannel;
import lev.LOutFile;
import lev.LShrinkArray;
import lev.Ln;
import skyproc.ALCH;
import skyproc.AMMO;
import skyproc.ARMA;
import skyproc.ARMO;
import skyproc.AVIF;
import skyproc.BOOK;
import skyproc.BSA;
import skyproc.COBJ;
import skyproc.CONT;
import skyproc.Consistency;
import skyproc.DIAL;
import skyproc.DLBR;
import skyproc.DLVW;
import skyproc.ECZN;
import skyproc.ENCH;
import skyproc.FACT;
import skyproc.FLST;
import skyproc.FormID;
import skyproc.GLOB;
import skyproc.GMST;
import skyproc.GRUP;
import skyproc.GRUPRecursive;
import skyproc.GRUP_TYPE;
import skyproc.HDPT;
import skyproc.IMGS;
import skyproc.INGR;
import skyproc.KYWD;
import skyproc.LGTM;
import skyproc.LVLI;
import skyproc.LVLN;
import skyproc.LeveledRecord;
import skyproc.MGEF;
import skyproc.MISC;
import skyproc.MajorRecord;
import skyproc.ModExporter;
import skyproc.ModListing;
import skyproc.NPC_;
import skyproc.NiftyFunc;
import skyproc.OTFT;
import skyproc.PERK;
import skyproc.PROJ;
import skyproc.QUST;
import skyproc.RACE;
import skyproc.Record;
import skyproc.RecordFileChannel;
import skyproc.SCRL;
import skyproc.SPDatabase;
import skyproc.SPEL;
import skyproc.SPGlobal;
import skyproc.SPImporter;
import skyproc.STAT;
import skyproc.SubData;
import skyproc.SubFormArray;
import skyproc.SubList;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubRecordsDerived;
import skyproc.SubString;
import skyproc.SubStringPointer;
import skyproc.TXST;
import skyproc.VTYP;
import skyproc.WEAP;
import skyproc.WTHR;
import skyproc.exceptions.BadMod;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.gui.SPProgressBarPlug;

public class Mod
implements Comparable,
Iterable<GRUP> {
    TES4 tes = new TES4();
    ModListing modInfo;
    Map<GRUP_TYPE, GRUP> GRUPs = new EnumMap<GRUP_TYPE, GRUP>(GRUP_TYPE.class);
    LInChannel input;
    SPGlobal.Language language = SPGlobal.Language.English;
    Map<ModListing, Integer> masterMap = new HashMap<ModListing, Integer>();
    Map<SubStringPointer.Files, Map<Integer, Integer>> stringLocations = new EnumMap<SubStringPointer.Files, Map<Integer, Integer>>(SubStringPointer.Files.class);
    Map<SubStringPointer.Files, LImport> stringStreams = new EnumMap<SubStringPointer.Files, LImport>(SubStringPointer.Files.class);
    private ArrayList<String> outStrings = new ArrayList();
    private ArrayList<String> outDLStrings = new ArrayList();
    private ArrayList<String> outILStrings = new ArrayList();

    public Mod(ModListing info) {
        this.init(info);
        SPDatabase.add(this);
    }

    public Mod(String name, Boolean master) {
        this(new ModListing(name, master));
    }

    Mod(ModListing info, ByteBuffer headerInfo) throws Exception {
        this(info, true);
        if (SPGlobal.logMods) {
            SPGlobal.logMod(this, "MOD", "Parsing header");
        }
        if (!headerInfo.hasRemaining()) {
            throw new BadMod(String.valueOf(info.print()) + " did not have a TES4 header.", null, info);
        }
        this.tes.parseData(headerInfo, this);
        if (this.tes.flags.get(Mod_Flags.MASTER.value) && !info.getMasterTag()) {
            info.setFalseMaster(true);
        }
    }

    Mod(ModListing info, boolean temp) {
        this.init(info);
    }

    void deleteStringsFiles() {
        File STRINGS = new File(this.genStringsPath(SubStringPointer.Files.STRINGS));
        File DLSTRINGS = new File(this.genStringsPath(SubStringPointer.Files.STRINGS));
        File ILSTRINGS = new File(this.genStringsPath(SubStringPointer.Files.STRINGS));
        if (STRINGS.exists()) {
            STRINGS.delete();
        }
        if (DLSTRINGS.exists()) {
            DLSTRINGS.delete();
        }
        if (ILSTRINGS.exists()) {
            ILSTRINGS.delete();
        }
    }

    void addGRUP(MajorRecord r) {
        this.GRUPs.put(GRUP_TYPE.valueOf(r.getType()), new GRUP<MajorRecord>(r));
    }

    void addGRUPrecursive(MajorRecord r) {
        this.GRUPs.put(GRUP_TYPE.valueOf(r.getType()), new GRUPRecursive<MajorRecord>(r));
    }

    final void init(ModListing info) {
        this.modInfo = info;
        this.setFlag(Mod_Flags.MASTER, info.getMasterTag());
        this.setFlag(Mod_Flags.STRING_TABLED, false);
        this.stringLocations.put(SubStringPointer.Files.STRINGS, new TreeMap());
        this.stringLocations.put(SubStringPointer.Files.DLSTRINGS, new TreeMap());
        this.stringLocations.put(SubStringPointer.Files.ILSTRINGS, new TreeMap());
        this.addGRUP(new GMST());
        this.addGRUP(new KYWD());
        this.addGRUP(new TXST());
        this.addGRUP(new GLOB());
        this.addGRUP(new FACT());
        this.addGRUP(new HDPT());
        this.addGRUP(new RACE());
        this.addGRUP(new MGEF());
        this.addGRUP(new ENCH());
        this.addGRUP(new SPEL());
        this.addGRUP(new SCRL());
        this.addGRUP(new ARMO());
        this.addGRUP(new BOOK());
        this.addGRUP(new CONT());
        this.addGRUP(new INGR());
        this.addGRUP(new MISC());
        this.addGRUP(new ALCH());
        this.addGRUP(new COBJ());
        this.addGRUP(new PROJ());
        this.addGRUP(new STAT());
        this.addGRUP(new WEAP());
        this.addGRUP(new AMMO());
        this.addGRUP(new NPC_());
        this.addGRUP(new LVLN());
        this.addGRUP(new LVLI());
        this.addGRUP(new WTHR());
        this.addGRUPrecursive(new DIAL());
        this.addGRUP(new QUST());
        this.addGRUP(new IMGS());
        this.addGRUP(new FLST());
        this.addGRUP(new PERK());
        this.addGRUP(new VTYP());
        this.addGRUP(new AVIF());
        this.addGRUP(new ARMA());
        this.addGRUP(new ECZN());
        this.addGRUP(new LGTM());
        this.addGRUP(new DLBR());
        this.addGRUP(new DLVW());
        this.addGRUP(new OTFT());
    }

    public ModListing getNthMaster(int i) {
        if (this.tes.getMasters().size() > i && i >= 0) {
            return this.tes.getMasters().get(i);
        }
        return this.getInfo();
    }

    public int numMasters() {
        return this.tes.getMasters().size();
    }

    public boolean isEmpty() {
        for (GRUP g : this.GRUPs.values()) {
            if (g.numRecords() <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean exists() {
        File f = new File(String.valueOf(SPGlobal.pathToData) + this.getInfo().print());
        return f.exists();
    }

    FormID getNextID() {
        return new FormID(this.tes.getHEDR().nextID++, this.getInfo());
    }

    void resetNextIDcounter() {
        this.tes.getHEDR().nextID = HEDR.firstAvailableID;
    }

    void addMaster(ModListing input) {
        if (!this.getInfo().equals(input)) {
            this.masterMap.clear();
            this.tes.addMaster(input);
        }
    }

    void closeStreams() {
        this.input.close();
        for (LImport c : this.stringStreams.values()) {
            c.close();
        }
    }

    public MajorRecord getMajor(FormID query, GRUP_TYPE ... grup_types) {
        if (query != null && query.getMaster() != null) {
            if (grup_types.length == 0) {
                grup_types = this.GRUPs.keySet().toArray(new GRUP_TYPE[0]);
            }
            GRUP_TYPE[] gRUP_TYPEArray = grup_types;
            int n = grup_types.length;
            int n2 = 0;
            while (n2 < n) {
                MajorRecord mr;
                GRUP grup;
                GRUP_TYPE g = gRUP_TYPEArray[n2];
                if (!GRUP_TYPE.internal(g) && (grup = this.GRUPs.get((Object)g)) != null && (mr = grup.get(query)) != null) {
                    return mr;
                }
                ++n2;
            }
        }
        return null;
    }

    public MajorRecord getMajor(String edid, GRUP_TYPE ... grup_types) {
        if (edid != null) {
            if (grup_types.length == 0) {
                grup_types = this.GRUPs.keySet().toArray(new GRUP_TYPE[0]);
            }
            GRUP_TYPE[] gRUP_TYPEArray = grup_types;
            int n = grup_types.length;
            int n2 = 0;
            while (n2 < n) {
                MajorRecord mr;
                GRUP_TYPE g = gRUP_TYPEArray[n2];
                GRUP grup = this.GRUPs.get((Object)g);
                if (grup != null && (mr = grup.get(edid)) != null) {
                    return mr;
                }
                ++n2;
            }
        }
        return null;
    }

    MajorRecord makeCopy(MajorRecord m) {
        m = m.copyOf(this);
        this.GRUPs.get((Object)GRUP_TYPE.valueOf(m.getType())).addRecord(m);
        return m;
    }

    public MajorRecord makeCopy(MajorRecord m, String newEDID) {
        if (m == null || newEDID == null) {
            return null;
        }
        m = m.copyOf(this, newEDID);
        this.GRUPs.get((Object)GRUP_TYPE.valueOf(m.getType())).addRecord(m);
        return m;
    }

    public ArrayList<MajorRecord> makeCopy(GRUP g) {
        ArrayList<MajorRecord> out = new ArrayList<MajorRecord>();
        for (Object o : g) {
            MajorRecord m = (MajorRecord)o;
            out.add(this.makeCopy(m));
        }
        return out;
    }

    public ArrayList<GRUP_TYPE> getContainedTypes() {
        ArrayList<GRUP_TYPE> out = new ArrayList<GRUP_TYPE>();
        for (GRUP g : this.GRUPs.values()) {
            if (g.isEmpty().booleanValue()) continue;
            out.add(g.getContainedType());
        }
        return out;
    }

    public void addRecord(MajorRecord m) {
        this.GRUPs.get((Object)GRUP_TYPE.valueOf(m.getType())).addRecord(m);
    }

    public void print() {
        SPGlobal.newSyncLog("Mod Export/" + this.getName() + ".txt");
        if (!this.getMastersStrings().isEmpty() && SPGlobal.logMods) {
            SPGlobal.logMod(this, this.getName(), "=======================================================================");
            SPGlobal.logMod(this, this.getName(), "======================= Printing Mod Masters ==========================");
            SPGlobal.logMod(this, this.getName(), "=======================================================================");
            for (String s : this.getMastersStrings()) {
                SPGlobal.logMod(this, this.getName(), s);
            }
        }
        for (GRUP g : this.GRUPs.values()) {
            g.toString();
        }
        if (SPGlobal.logMods) {
            SPGlobal.logMod(this, this.getName(), "------------------------  DONE PRINTING -------------------------------");
        }
    }

    public String toString() {
        return this.getName();
    }

    ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> tmp = new ArrayList<FormID>();
        for (GRUP g : this.GRUPs.values()) {
            tmp.addAll(g.allFormIDs());
        }
        ArrayList<FormID> out = new ArrayList<FormID>(tmp.size());
        for (FormID id : tmp) {
            if (id != null) {
                out.add(id);
                continue;
            }
            SPGlobal.logError(this.toString(), "AllFormIDs return null formid reference.");
        }
        return out;
    }

    void openStringStreams() {
        if (this.isFlag(Mod_Flags.STRING_TABLED)) {
            SubStringPointer.Files[] filesArray = SubStringPointer.Files.values();
            int n = filesArray.length;
            int n2 = 0;
            while (n2 < n) {
                SubStringPointer.Files f = filesArray[n2];
                this.addStream(this.stringStreams, f);
                ++n2;
            }
        }
    }

    void addStream(Map<SubStringPointer.Files, LImport> streams, SubStringPointer.Files file) {
        try {
            String stringPath = SPImporter.getStringFilePath(this, this.language, file);
            File stringFile = new File(String.valueOf(SPGlobal.pathToData) + stringPath);
            if (stringFile.isFile()) {
                streams.put(file, (LImport)new LInChannel(stringFile));
                return;
            }
            if (BSA.hasBSA(this.getInfo())) {
                BSA bsa = BSA.getBSA(this.getInfo());
                if (bsa.hasFile(stringPath)) {
                    LByteChannel stream = new LByteChannel();
                    stream.openStream(bsa.getFile(stringPath));
                    streams.put(file, (LImport)stream);
                }
                return;
            }
            if (SPGlobal.logMods) {
                SPGlobal.logMod(this, this.getName(), "No strings file for " + (Object)((Object)file));
            }
        }
        catch (IOException | DataFormatException ex) {
            SPGlobal.log(this.getName(), "Could not open a strings stream for mod " + this.getName() + " to type: " + (Object)((Object)file));
        }
    }

    public ArrayList<String> getMastersStrings() {
        ArrayList<String> out = new ArrayList<String>();
        for (ModListing m : this.tes.getMasters()) {
            out.add(m.print());
        }
        return out;
    }

    public ArrayList<ModListing> getMasters() {
        ArrayList<ModListing> out = new ArrayList<ModListing>();
        for (ModListing m : this.tes.getMasters()) {
            out.add(m);
        }
        return out;
    }

    public Map<GRUP_TYPE, GRUP> getGRUPs() {
        return this.GRUPs;
    }

    public void keep(GRUP_TYPE ... grup_type) {
        ArrayList<GRUP_TYPE> grups = new ArrayList<GRUP_TYPE>();
        grups.addAll(Arrays.asList(grup_type));
        for (GRUP g : this.GRUPs.values()) {
            if (grups.contains((Object)g.getContainedType())) continue;
            g.clear();
        }
    }

    public void addAsOverrides(Mod rhs, GRUP_TYPE ... grup_types) {
        if (!this.equals(rhs)) {
            if (grup_types.length == 0) {
                grup_types = this.GRUPs.keySet().toArray(new GRUP_TYPE[0]);
            }
            ArrayList<GRUP_TYPE> grups = new ArrayList<GRUP_TYPE>(Arrays.asList(grup_types));
            for (GRUP_TYPE t : grups) {
                GRUP g = this.GRUPs.get((Object)t);
                if (g == null) continue;
                g.merge(rhs.GRUPs.get((Object)t));
            }
        }
    }

    public void addAsOverrides(ArrayList<Mod> in, GRUP_TYPE ... grup_types) {
        for (Mod m : in) {
            this.addAsOverrides(m, grup_types);
        }
    }

    public void addAsOverrides(Collection<Mod> in, GRUP_TYPE ... grup_types) {
        for (Mod m : in) {
            this.addAsOverrides(m, grup_types);
        }
    }

    public void addAsOverrides(SPDatabase db, GRUP_TYPE ... grup_types) {
        this.addAsOverrides(SPDatabase.modLookup.values(), grup_types);
    }

    public int numRecords() {
        int sum = 0;
        for (GRUP g : this.GRUPs.values()) {
            if (g.numRecords() == 0) continue;
            sum += g.numRecords() + 1;
        }
        return sum;
    }

    public ArrayList<MajorRecord> getRecords() {
        ArrayList<MajorRecord> out = new ArrayList<MajorRecord>();
        for (GRUP g : this.GRUPs.values()) {
            out.addAll(g.getRecords());
        }
        return out;
    }

    public boolean contains(FormID id) {
        for (GRUP g : this.GRUPs.values()) {
            if (!g.contains(id)) continue;
            return true;
        }
        return false;
    }

    int getMasterIndex(ModListing in) {
        Integer out = this.masterMap.get(in);
        if (out != null) {
            return out;
        }
        ArrayList<ModListing> masters = this.getMasters();
        int i = 0;
        while (i < masters.size()) {
            if (masters.get(i).equals(in)) {
                return i;
            }
            ++i;
        }
        this.masterMap.put(in, i);
        return i;
    }

    public void export() throws IOException, BadRecord {
        this.export(SPGlobal.pathToData);
    }

    public void export(String path) throws IOException, BadRecord {
        File tmp = new File(String.valueOf(SPGlobal.pathToInternalFiles) + "tmp.esp");
        if (tmp.isFile()) {
            tmp.delete();
        }
        File dest = new File(String.valueOf(path) + this.getName());
        File backup = new File(String.valueOf(SPGlobal.pathToInternalFiles) + this.getName() + ".bak");
        if (backup.isFile()) {
            backup.delete();
        }
        this.export(tmp);
        Ln.moveFile((File)dest, (File)backup, (boolean)false);
        Ln.moveFile((File)tmp, (File)dest, (boolean)false);
    }

    void export(File outPath) throws IOException, BadRecord {
        AbstractCollection addedMods;
        SPGlobal.logMain("Mod Export", "Exporting " + this);
        if (SPGlobal.logging()) {
            SPGlobal.newSyncLog("Export - " + this.getName() + ".txt");
            SPGlobal.sync(true);
        }
        ModExporter out = new ModExporter(outPath, this);
        GRUP lvli = this.GRUPs.get((Object)GRUP_TYPE.LVLI);
        this.validateListEntries(lvli);
        GRUP lvln = this.GRUPs.get((Object)GRUP_TYPE.LVLN);
        this.validateListEntries(lvln);
        ArrayList<GRUP> exportGRUPs = new ArrayList<GRUP>();
        for (GRUP g : this.GRUPs.values()) {
            if (g.isEmpty().booleanValue()) continue;
            exportGRUPs.add(g);
        }
        SPProgressBarPlug.reset();
        SPProgressBarPlug.setMax(exportGRUPs.size() + 6, "Exporting " + this);
        ArrayList<FormID> allForms = this.allFormIDs();
        SPProgressBarPlug.setStatusNumbered("Adding Masters From Records");
        if (SPGlobal.getAllModsAsMasters()) {
            addedMods = SPImporter.getActiveModList();
            for (ModListing modListing : addedMods) {
                this.addMaster(modListing);
            }
        } else {
            addedMods = new HashSet();
            for (FormID formID : allForms) {
                ModListing master;
                if (formID.isNull() || addedMods.contains(master = formID.getMaster())) continue;
                this.addMaster(master);
                addedMods.add(master);
            }
            SPProgressBarPlug.incrementBar();
            SPProgressBarPlug.setStatusNumbered("Adding Masters From Contributors");
            if (!SPGlobal.mergeMode) {
                for (GRUP gRUP : this) {
                    for (MajorRecord major : gRUP) {
                        FormID id = major.getForm();
                        for (Mod mod : SPDatabase.getImportedMods()) {
                            if (!mod.contains(id) || addedMods.contains(mod.getInfo()) || mod.equals(SPGlobal.getGlobalPatch())) continue;
                            this.addMaster(mod.getInfo());
                            addedMods.add(mod.getInfo());
                        }
                    }
                }
            }
        }
        SPProgressBarPlug.incrementBar();
        this.sortMasters();
        SPProgressBarPlug.incrementBar();
        this.tes.setNumRecords(this.numRecords());
        if (SPGlobal.logging()) {
            SPGlobal.logSync(this.getName(), "Exporting " + this.tes.getHEDR().numRecords + " records.");
            SPGlobal.logSync(this.getName(), "Masters: ");
            int i = 0;
            for (String string : this.getMastersStrings()) {
                SPGlobal.logSync(this.getName(), "   " + Ln.printHex((int)i++) + "  " + string);
            }
        }
        this.tes.export(out);
        for (GRUP g : exportGRUPs) {
            SPProgressBarPlug.setStatusNumbered("Exporting " + this + ": " + (Object)((Object)g.getContainedType()));
            g.export(out);
            SPProgressBarPlug.incrementBar();
        }
        if (this.isFlag(Mod_Flags.STRING_TABLED)) {
            SPProgressBarPlug.setStatusNumbered("Exporting " + this + ": STRINGS files");
            this.exportStringsFile(this.outStrings, SubStringPointer.Files.STRINGS);
            this.exportStringsFile(this.outDLStrings, SubStringPointer.Files.DLSTRINGS);
            this.exportStringsFile(this.outILStrings, SubStringPointer.Files.ILSTRINGS);
            SPProgressBarPlug.incrementBar();
        } else {
            this.deleteStringsFiles();
        }
        out.close();
        SPProgressBarPlug.setStatusNumbered("Checking for Duplicates");
        HashMap<String, MajorRecord> edids = new HashMap<String, MajorRecord>();
        HashSet<FormID> hashSet = new HashSet<FormID>();
        boolean bad = false;
        for (GRUP g : this.GRUPs.values()) {
            for (Object o : g.listRecords) {
                MajorRecord m = (MajorRecord)o;
                if (edids.keySet().contains(m.getEDID()) && (m.getFormMaster().equals(SPGlobal.getGlobalPatch().modInfo) || ((MajorRecord)edids.get(m.getEDID())).getFormMaster().equals(SPGlobal.getGlobalPatch().modInfo))) {
                    SPGlobal.logError("EDID Check", "Error! Duplicate EDID " + m);
                    SPGlobal.logError("EDID Check", "    With: " + edids.get(m.getEDID()));
                    bad = true;
                } else {
                    edids.put(m.getEDID(), m);
                }
                if (hashSet.contains(m.getForm())) {
                    SPGlobal.logError("FormID Check", "Error! Duplicate FormID " + m);
                    bad = true;
                    continue;
                }
                hashSet.add(m.getForm());
            }
        }
        SPProgressBarPlug.incrementBar();
        if (bad) {
            throw new BadRecord("Duplicate EDIDs or FormIDs.  Check logs for a listing.");
        }
        SPProgressBarPlug.setStatusNumbered("Validating Record Lengths");
        if (!NiftyFunc.validateRecordLengths(outPath, 1)) {
            SPGlobal.logError("Record Length Check", "Record lengths were off.");
            throw new BadRecord("Record lengths are off.");
        }
        SPProgressBarPlug.incrementBar();
        SPProgressBarPlug.setStatusNumbered("Exporting Consistency File");
        if (Consistency.automaticExport) {
            Consistency.export();
        }
        SPProgressBarPlug.incrementBar();
    }

    public void exportMasterList(String path) throws IOException {
        File masterListTmp = new File(String.valueOf(SPGlobal.pathToInternalFiles) + "Last Masterlist Temp.txt");
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(masterListTmp));){
            for (ModListing m : this.getMasters()) {
                writer.write(String.valueOf(m.toString()) + "\n");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        File masterList = new File(path);
        if (masterList.isFile()) {
            masterList.delete();
        }
        Ln.moveFile((File)masterListTmp, (File)masterList, (boolean)false);
    }

    int addOutString(String in, SubStringPointer.Files file) {
        switch (file) {
            case DLSTRINGS: {
                return this.addOutString(in, this.outDLStrings);
            }
            case ILSTRINGS: {
                return this.addOutString(in, this.outILStrings);
            }
        }
        return this.addOutString(in, this.outStrings);
    }

    int addOutString(String in, ArrayList<String> list) {
        if (!list.contains(in)) {
            list.add(in);
        }
        return list.indexOf(in) + 1;
    }

    String genStringsPath(SubStringPointer.Files file) {
        return String.valueOf(SPGlobal.pathToData) + "Strings/" + this.getNameNoSuffix() + "_" + (Object)((Object)SPGlobal.language) + "." + (Object)((Object)file);
    }

    void sortMasters() {
        SubList<ModListing, ModListing> sublist = this.tes.getMasters();
        for (ModListing m : sublist.collection) {
            if (m.master || m.falseMaster) continue;
            try {
                RecordFileChannel inputChannel = new RecordFileChannel(String.valueOf(SPGlobal.pathToData) + m.print());
                Mod mod = new Mod(m, SPImporter.extractHeaderInfo(inputChannel));
            }
            catch (Exception e) {
                if (!SPGlobal.logging()) continue;
                SPGlobal.logSync("Sort Masters", "Could not read mod file: " + m.print() + ", Sorting based on extension.");
            }
        }
        sublist.sort();
    }

    void exportStringsFile(ArrayList<String> list, SubStringPointer.Files file) throws FileNotFoundException, IOException {
        int stringLength = 0;
        for (String s : list) {
            stringLength += s.length() + 1;
        }
        int outLength = stringLength + 8 * list.size() + 8;
        LOutFile out = new LOutFile(this.genStringsPath(file));
        out.write(list.size());
        out.write(stringLength);
        int i = 1;
        int offset = 0;
        for (String s : list) {
            out.write(i++);
            out.write(offset);
            offset += s.length() + 1;
        }
        for (String s : list) {
            out.write(s);
            out.write(0, 1);
        }
        list.clear();
        out.close();
    }

    void validateListEntries(GRUP g) {
        ArrayList records = new ArrayList(g.getRecords());
        for (MajorRecord record : records) {
            LeveledRecord leveledRec = (LeveledRecord)record;
            if (leveledRec == null || leveledRec.numEntries() <= 255) continue;
            leveledRec.splitEntries();
        }
    }

    public void setAuthor(String in) {
        this.tes.setAuthor(in);
    }

    public String getAuthor() {
        return this.tes.getAuthor();
    }

    public void setDescription(String in) {
        this.tes.setDescription(in);
    }

    public String getDescription() {
        return this.tes.getDescription();
    }

    void parseData(String type, LImport data) throws Exception {
        this.GRUPs.get((Object)GRUP_TYPE.valueOf(type)).parseData(data, this);
    }

    public boolean isFlag(Mod_Flags flag) {
        return this.tes.flags.get(flag.value);
    }

    public final void setFlag(Mod_Flags flag, boolean on) {
        this.tes.flags.set(flag.value, on);
        if (flag == Mod_Flags.MASTER) {
            this.getInfo().setMasterTag(on);
        }
    }

    public GRUP<LVLN> getLeveledCreatures() {
        return this.GRUPs.get((Object)GRUP_TYPE.LVLN);
    }

    public GRUP<NPC_> getNPCs() {
        return this.GRUPs.get((Object)GRUP_TYPE.NPC_);
    }

    public GRUP<QUST> getQuests() {
        return this.GRUPs.get((Object)GRUP_TYPE.QUST);
    }

    public GRUP<IMGS> getImageSpaces() {
        return this.GRUPs.get((Object)GRUP_TYPE.IMGS);
    }

    public GRUP<PERK> getPerks() {
        return this.GRUPs.get((Object)GRUP_TYPE.PERK);
    }

    public GRUP<SPEL> getSpells() {
        return this.GRUPs.get((Object)GRUP_TYPE.SPEL);
    }

    public GRUP<RACE> getRaces() {
        return this.GRUPs.get((Object)GRUP_TYPE.RACE);
    }

    public GRUP<ARMO> getArmors() {
        return this.GRUPs.get((Object)GRUP_TYPE.ARMO);
    }

    public GRUP<ARMA> getArmatures() {
        return this.GRUPs.get((Object)GRUP_TYPE.ARMA);
    }

    public GRUP<TXST> getTextureSets() {
        return this.GRUPs.get((Object)GRUP_TYPE.TXST);
    }

    public GRUP<WEAP> getWeapons() {
        return this.GRUPs.get((Object)GRUP_TYPE.WEAP);
    }

    public GRUP<KYWD> getKeywords() {
        return this.GRUPs.get((Object)GRUP_TYPE.KYWD);
    }

    public GRUP<FLST> getFormLists() {
        return this.GRUPs.get((Object)GRUP_TYPE.FLST);
    }

    public GRUP<MGEF> getMagicEffects() {
        return this.GRUPs.get((Object)GRUP_TYPE.MGEF);
    }

    public GRUP<ALCH> getAlchemy() {
        return this.GRUPs.get((Object)GRUP_TYPE.ALCH);
    }

    public GRUP<INGR> getIngredients() {
        return this.GRUPs.get((Object)GRUP_TYPE.INGR);
    }

    public GRUP<AMMO> getAmmo() {
        return this.GRUPs.get((Object)GRUP_TYPE.AMMO);
    }

    public GRUP<FACT> getFactions() {
        return this.GRUPs.get((Object)GRUP_TYPE.FACT);
    }

    public GRUP<GMST> getGameSettings() {
        return this.GRUPs.get((Object)GRUP_TYPE.GMST);
    }

    public GRUP<ENCH> getEnchantments() {
        return this.GRUPs.get((Object)GRUP_TYPE.ENCH);
    }

    public GRUP<LVLI> getLeveledItems() {
        return this.GRUPs.get((Object)GRUP_TYPE.LVLI);
    }

    public GRUP<AVIF> getActorValues() {
        return this.GRUPs.get((Object)GRUP_TYPE.AVIF);
    }

    public GRUP<ECZN> getEncounterZones() {
        return this.GRUPs.get((Object)GRUP_TYPE.ECZN);
    }

    public GRUP<GLOB> getGlobals() {
        return this.GRUPs.get((Object)GRUP_TYPE.GLOB);
    }

    public GRUP<COBJ> getConstructibleObjects() {
        return this.GRUPs.get((Object)GRUP_TYPE.COBJ);
    }

    public GRUP<MISC> getMiscObjects() {
        return this.GRUPs.get((Object)GRUP_TYPE.MISC);
    }

    public GRUP<OTFT> getOutfits() {
        return this.GRUPs.get((Object)GRUP_TYPE.OTFT);
    }

    public GRUP<HDPT> getHeadParts() {
        return this.GRUPs.get((Object)GRUP_TYPE.HDPT);
    }

    public GRUP<PROJ> getProjectiles() {
        return this.GRUPs.get((Object)GRUP_TYPE.PROJ);
    }

    public GRUP<LGTM> getLightingTemplates() {
        return this.GRUPs.get((Object)GRUP_TYPE.LGTM);
    }

    public GRUP<BOOK> getBooks() {
        return this.GRUPs.get((Object)GRUP_TYPE.BOOK);
    }

    public GRUP<WTHR> getWeathers() {
        return this.GRUPs.get((Object)GRUP_TYPE.WTHR);
    }

    public GRUP<DIAL> getDialogs() {
        return this.GRUPs.get((Object)GRUP_TYPE.DIAL);
    }

    public GRUP<DLBR> getDialogBranches() {
        return this.GRUPs.get((Object)GRUP_TYPE.DLBR);
    }

    public GRUP<DLVW> getDialogViews() {
        return this.GRUPs.get((Object)GRUP_TYPE.DLVW);
    }

    public GRUP<CONT> getContainers() {
        return this.GRUPs.get((Object)GRUP_TYPE.CONT);
    }

    public GRUP<VTYP> getVoiceTypes() {
        return this.GRUPs.get((Object)GRUP_TYPE.VTYP);
    }

    public GRUP<STAT> getStatics() {
        return this.GRUPs.get((Object)GRUP_TYPE.STAT);
    }

    public GRUP<SCRL> getScrolls() {
        return this.GRUPs.get((Object)GRUP_TYPE.SCRL);
    }

    public String getName() {
        return this.modInfo.print();
    }

    public ModListing getInfo() {
        return this.modInfo;
    }

    public String getNameNoSuffix() {
        return this.getName().substring(0, this.getName().indexOf(".es"));
    }

    public int compareTo(Object o) {
        Mod rhs = (Mod)o;
        return this.getInfo().compareTo(rhs.getInfo());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ModListing) {
            return this.getInfo().equals(obj);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mod other = (Mod)obj;
        return this.getName().equalsIgnoreCase(other.getName());
    }

    public void remove(FormID id) {
        for (GRUP g : this.GRUPs.values()) {
            if (!g.contains(id)) continue;
            g.removeRecord(id);
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.modInfo != null ? this.modInfo.hashCode() : 0);
        return hash;
    }

    @Override
    public Iterator<GRUP> iterator() {
        return this.GRUPs.values().iterator();
    }

    static class HEDR
    extends SubRecord<HEDR> {
        byte[] version;
        int numRecords;
        int nextID;
        static int firstAvailableID = 3426;

        HEDR() {
            this.clear();
        }

        HEDR(LShrinkArray in) throws Exception {
            this();
            this.parseData((LImport)in, null);
        }

        void setRecords(int num) {
            this.numRecords = num;
        }

        int numRecords() {
            return this.numRecords;
        }

        void addRecords(int num) {
            this.setRecords(this.numRecords() + num);
        }

        int nextID() {
            return this.nextID++;
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.version);
            out.write(this.numRecords);
            out.write(this.nextID);
        }

        @Override
        final void parseData(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
            super.parseData(in, srcMod);
            this.version = in.extract(4);
            this.numRecords = in.extractInt(4);
            this.nextID = in.extractInt(4);
        }

        @Override
        SubRecord getNew(String type) {
            return new HEDR();
        }

        public final void clear() {
            this.version = Ln.parseHexString((String)"D7 A3 70 3F", (int)4);
            this.numRecords = 0;
            this.nextID = firstAvailableID;
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 12;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("HEDR");
        }
    }

    public static enum Mod_Flags {
        MASTER(0),
        STRING_TABLED(7);

        int value;

        private Mod_Flags(int in) {
            this.value = in;
        }
    }

    static class TES4
    extends Record {
        private static final byte[] defaultINTV = Ln.parseHexString((String)"C5 26 01 00", (int)4);
        static final SubPrototype TES4proto = new SubPrototype(){

            @Override
            protected void addRecords() {
                this.add(new HEDR());
                this.add(SubString.getNew("CNAM", true));
                this.add(new SubList(new ModListing(), true));
                this.add(SubString.getNew("SNAM", true));
                this.add(new SubFormArray("ONAM", 0));
                this.add(new SubData("SCRN"));
                this.add(new SubData("INTV"));
                this.add(new SubData("INCC"));
            }
        };
        SubRecordsDerived subRecords = new SubRecordsDerived(TES4proto);
        private LFlags flags = new LFlags(4);
        private int fluff1 = 0;
        private int fluff2 = 0;
        private int fluff3 = 0;

        TES4() {
        }

        TES4(LShrinkArray in) throws Exception {
            this();
            this.parseData((LImport)in, null);
        }

        @Override
        final void parseData(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
            super.parseData(in, srcMod);
            this.flags.set(in.extract(4));
            this.fluff1 = Ln.arrayToInt((int[])in.extractInts(4));
            this.fluff2 = Ln.arrayToInt((int[])in.extractInts(4));
            this.fluff3 = Ln.arrayToInt((int[])in.extractInts(4));
            this.subRecords.importSubRecords(in, srcMod);
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        public String toString() {
            return "HEDR";
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("TES4");
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.flags.export(), 4);
            out.write(this.fluff1);
            out.write(this.fluff2);
            out.write(this.fluff3);
            this.subRecords.export(out);
        }

        void addMaster(ModListing mod) {
            this.subRecords.getSubList("MAST").add(mod);
        }

        void clearMasters() {
            this.subRecords.getSubList("MAST").clear();
        }

        SubList<ModListing, ModListing> getMasters() {
            return this.subRecords.getSubList("MAST");
        }

        void setAuthor(String in) {
            this.subRecords.getSubString("CNAM").setString(in);
        }

        String getAuthor() {
            return this.subRecords.getSubString("CNAM").print();
        }

        void setDescription(String in) {
            this.subRecords.getSubString("SNAM").setString(in);
        }

        String getDescription() {
            return this.subRecords.getSubString("SNAM").print();
        }

        @Override
        int getFluffLength() {
            return 16;
        }

        @Override
        int getContentLength(ModExporter out) {
            return this.subRecords.length(out);
        }

        @Override
        int getSizeLength() {
            return 4;
        }

        void setNumRecords(int num) {
            this.getHEDR().setRecords(num);
        }

        HEDR getHEDR() {
            return (HEDR)this.subRecords.get("HEDR");
        }

        int getNumRecords() {
            return this.getHEDR().numRecords;
        }

        @Override
        Record getNew() {
            return new TES4();
        }

        @Override
        public String print() {
            return this.toString();
        }
    }
}

