/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.AltTextures;
import skyproc.DestructionData;
import skyproc.FormID;
import skyproc.KeywordSet;
import skyproc.MajorRecordNamed;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.ScriptPackage;
import skyproc.SubData;
import skyproc.SubForm;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class MISC
extends MajorRecordNamed {
    static final SubPrototype MISCproto = new SubPrototype(MajorRecordNamed.namedProto){

        @Override
        protected void addRecords() {
            this.after(new ScriptPackage(), "EDID");
            this.add(new SubData("OBND", new byte[12]));
            this.reposition("FULL");
            this.add(new Model());
            this.add(SubString.getNew("ICON", true));
            this.add(new SubForm("YNAM"));
            this.add(new SubForm("ZNAM"));
            this.add(new KeywordSet());
            this.add(new DATA());
            this.add(SubString.getNew("MICO", true));
            this.add(new DestructionData());
        }
    };

    MISC() {
        this.subRecords.setPrototype(MISCproto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("MISC");
    }

    @Override
    Record getNew() {
        return new MISC();
    }

    public void setModel(String path) {
        this.subRecords.getModel().setFileName(path);
    }

    public String getModel() {
        return this.subRecords.getModel().getFileName();
    }

    DATA getDATA() {
        return (DATA)this.subRecords.get("DATA");
    }

    public void setValue(int value) {
        this.getDATA().value = value;
    }

    public int getValue() {
        return this.getDATA().value;
    }

    public void setWeight(float weight) {
        this.getDATA().weight = weight;
    }

    public float getWeight() {
        return this.getDATA().weight;
    }

    public KeywordSet getKeywordSet() {
        return this.subRecords.getKeywords();
    }

    public ScriptPackage getScriptPackage() {
        return this.subRecords.getScripts();
    }

    public ArrayList<AltTextures.AltTexture> getAltTextures() {
        return this.subRecords.getModel().getAltTextures();
    }

    public Model getModelData() {
        return this.subRecords.getModel();
    }

    public void setPickupSound(FormID sound) {
        this.subRecords.setSubForm("YNAM", sound);
    }

    public FormID getPickupSound() {
        return this.subRecords.getSubForm("YNAM").getForm();
    }

    public void setDropSound(FormID sound) {
        this.subRecords.setSubForm("ZNAM", sound);
    }

    public FormID getDropSound() {
        return this.subRecords.getSubForm("ZNAM").getForm();
    }

    public void setInventoryImage(String path) {
        this.subRecords.setSubString("ICON", path);
    }

    public String getInventoryImage() {
        return this.subRecords.getSubString("ICON").print();
    }

    public void setMessageImage(String path) {
        this.subRecords.setSubString("MICO", path);
    }

    public String getMessageImage() {
        return this.subRecords.getSubString("MICO").print();
    }

    static class DATA
    extends SubRecord {
        int value = 0;
        float weight = 0.0f;

        DATA() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.value);
            out.write(this.weight);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.value = in.extractInt(4);
            this.weight = in.extractFloat();
            if (SPGlobal.logMods) {
                DATA.logMod(srcMod, "", "Setting DATA:    Weight: " + this.weight);
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 8;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }
}

