/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.Condition;
import skyproc.FormID;
import skyproc.KeywordSet;
import skyproc.MajorRecordDescription;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.ScriptPackage;
import skyproc.SubData;
import skyproc.SubForm;
import skyproc.SubList;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubStringPointer;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.ActorValue;
import skyproc.genenums.CastType;
import skyproc.genenums.DeliveryType;
import skyproc.genenums.SoundVolume;

public class MGEF
extends MajorRecordDescription {
    static final SubPrototype MGEFproto = new SubPrototype(MajorRecordDescription.descProto){

        @Override
        protected void addRecords() {
            this.add(new ScriptPackage());
            this.reposition("FULL");
            this.add(new SubForm("MDOB"));
            this.add(new KeywordSet());
            this.add(new DATA());
            this.add(new SNDD());
            SubStringPointer dnam = new SubStringPointer("DNAM", SubStringPointer.Files.STRINGS);
            dnam.forceExport = true;
            this.add(dnam);
            this.forceExport("DNAM");
            this.remove("DESC");
            this.add(new SubForm("ESCE"));
            this.add(new SubList(new Condition()));
            this.add(new SubData("OBND"));
        }
    };

    SNDD getSNDD() {
        return (SNDD)this.subRecords.get("SNDD");
    }

    public ArrayList<Sound> getSounds() {
        return this.getSNDD().sounds;
    }

    public void setSounds(ArrayList<Sound> sounds) {
        this.getSNDD().sounds = sounds;
    }

    public void addSound(Sound sound) {
        this.getSNDD().sounds.add(sound);
    }

    public void removeSound(Sound sound) {
        this.getSNDD().sounds.remove(sound);
    }

    public MGEF(String edid, String name) {
        this();
        this.originateFromPatch(edid);
        this.setName(name);
    }

    MGEF() {
        this.subRecords.setPrototype(MGEFproto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("MGEF");
    }

    @Override
    Record getNew() {
        return new MGEF();
    }

    public KeywordSet getKeywordSet() {
        return this.subRecords.getKeywords();
    }

    @Override
    public String getDescription() {
        return this.subRecords.getSubStringPointer("DNAM").print();
    }

    @Override
    public void setDescription(String description) {
        this.subRecords.setSubStringPointer("DNAM", description);
    }

    DATA getDATA() {
        return (DATA)this.subRecords.get("DATA");
    }

    public void set(SpellEffectFlag flag, boolean on) {
        this.getDATA().flags.set(flag.value, on);
    }

    public boolean get(SpellEffectFlag flag) {
        return this.getDATA().flags.get(flag.value);
    }

    public ScriptPackage getScriptPackage() {
        return this.subRecords.getScripts();
    }

    public void setBaseCost(float value) {
        this.getDATA().baseCost = value;
    }

    public float getBaseCost() {
        return this.getDATA().baseCost;
    }

    public void setRelatedID(FormID id) {
        this.getDATA().relatedID = id;
    }

    public FormID getRelatedID() {
        return this.getDATA().relatedID;
    }

    public void setSkillType(ActorValue val) {
        this.getDATA().skillType = val;
    }

    public ActorValue getSkillType() {
        return this.getDATA().skillType;
    }

    public void setResistanceAV(ActorValue val) {
        this.getDATA().resistanceAV = val;
    }

    public ActorValue getResistanceAV() {
        return this.getDATA().resistanceAV;
    }

    public void setCounterEffectCount(int counterEffectCount) {
        this.getDATA().counterEffectCount = counterEffectCount;
    }

    public int getCounterEffectCount() {
        return this.getDATA().counterEffectCount;
    }

    public void setLight(FormID light) {
        this.getDATA().lightID = light;
    }

    public FormID getLight() {
        return this.getDATA().lightID;
    }

    public void setTaperWeight(float value) {
        this.getDATA().taperWeight = value;
    }

    public float getTaperWeight() {
        return this.getDATA().taperWeight;
    }

    public void setHitShader(FormID hitShader) {
        this.getDATA().hitShader = hitShader;
    }

    public FormID getHitShader() {
        return this.getDATA().hitShader;
    }

    public void setEnchantShader(FormID enchantShader) {
        this.getDATA().enchantShader = enchantShader;
    }

    public FormID getEnchantShader() {
        return this.getDATA().enchantShader;
    }

    public void setSkillLevel(int level) {
        this.getDATA().skillLevel = level;
    }

    public int getSkillLevel() {
        return this.getDATA().skillLevel;
    }

    public void setArea(int area) {
        this.getDATA().area = area;
    }

    public int getArea() {
        return this.getDATA().area;
    }

    public void setCastingTime(float value) {
        this.getDATA().castingTime = value;
    }

    public float getCastingTime() {
        return this.getDATA().castingTime;
    }

    public void setTaperCurve(float value) {
        this.getDATA().taperCurve = value;
    }

    public float getTaperCurve() {
        return this.getDATA().taperCurve;
    }

    public void setTaperDuration(float value) {
        this.getDATA().taperDuration = value;
    }

    public float getTaperDuration() {
        return this.getDATA().taperDuration;
    }

    public void setSecondAVWeight(float value) {
        this.getDATA().secondAVWeight = value;
    }

    public float getSecondAVWeight() {
        return this.getDATA().secondAVWeight;
    }

    public void setEffectType(int value) {
        this.getDATA().effectType = value;
    }

    public float getEffectType() {
        return this.getDATA().effectType;
    }

    public void setPrimaryAV(ActorValue val) {
        this.getDATA().primaryAV = val;
    }

    public ActorValue getPrimaryAV() {
        return this.getDATA().primaryAV;
    }

    public void setProjectile(FormID id) {
        this.getDATA().projectileID = id;
    }

    public FormID getProjectile() {
        return this.getDATA().projectileID;
    }

    public void setExplosion(FormID id) {
        this.getDATA().explosionID = id;
    }

    public FormID getExplosion() {
        return this.getDATA().explosionID;
    }

    public void setCastType(CastType cast) {
        this.getDATA().castType = cast;
    }

    public CastType getCastType() {
        return this.getDATA().castType;
    }

    public void setDeliveryType(DeliveryType del) {
        this.getDATA().deliveryType = del;
    }

    public DeliveryType getDeliveryType() {
        return this.getDATA().deliveryType;
    }

    public void setSecondAV(ActorValue val) {
        this.getDATA().secondAV = val;
    }

    public ActorValue getSecondAV() {
        return this.getDATA().secondAV;
    }

    public void setCastingArt(FormID art) {
        this.getDATA().castingArt = art;
    }

    public FormID getCastingArt() {
        return this.getDATA().castingArt;
    }

    public void setHitEffectArt(FormID art) {
        this.getDATA().hitEffectArt = art;
    }

    public FormID getHitEffectArt() {
        return this.getDATA().hitEffectArt;
    }

    public void setImpactData(FormID data) {
        this.getDATA().impactData = data;
    }

    public FormID getImpactData() {
        return this.getDATA().impactData;
    }

    public void setSkillUsageMult(float mult) {
        this.getDATA().skillUsageMult = mult;
    }

    public float getSkillUsageMult() {
        return this.getDATA().skillUsageMult;
    }

    public void setDualCast(FormID id) {
        this.getDATA().dualCastID = id;
    }

    public FormID getDualCast() {
        return this.getDATA().dualCastID;
    }

    public void setDualCastScale(float scale) {
        this.getDATA().dualCastScale = scale;
    }

    public float getDualCastScale() {
        return this.getDATA().dualCastScale;
    }

    public void setEnchantArt(FormID art) {
        this.getDATA().enchantArtID = art;
    }

    public FormID getEnchantArt() {
        return this.getDATA().enchantArtID;
    }

    public void setEquipAbility(FormID id) {
        this.getDATA().equipAbility = id;
    }

    public FormID getEquipAbility() {
        return this.getDATA().equipAbility;
    }

    public void setImageSpaceMod(FormID id) {
        this.getDATA().imageSpaceModID = id;
    }

    public FormID getImageSpaceMod() {
        return this.getDATA().imageSpaceModID;
    }

    public void setPerk(FormID id) {
        this.getDATA().perkID = id;
    }

    public FormID getPerk() {
        return this.getDATA().perkID;
    }

    public void setSoundVolume(SoundVolume vol) {
        this.getDATA().vol = vol;
    }

    public SoundVolume getSoundVolume() {
        return this.getDATA().vol;
    }

    public void setScriptAIDataScore(float score) {
        this.getDATA().scriptAIDataScore = score;
    }

    public float getScriptAIDataScore() {
        return this.getDATA().scriptAIDataScore;
    }

    public void setScriptAIDataTime(float score) {
        this.getDATA().scriptAIDataDelayTime = score;
    }

    public float getScriptAIDataTime() {
        return this.getDATA().scriptAIDataDelayTime;
    }

    public ArrayList<Condition> getConditions() {
        return this.subRecords.getSubList("CTDA").toPublic();
    }

    public void addCondition(Condition c) {
        this.subRecords.getSubList("CTDA").add(c);
    }

    public void removeCondition(Condition c) {
        this.subRecords.getSubList("CTDA").remove(c);
    }

    static class DATA
    extends SubRecord {
        LFlags flags = new LFlags(4);
        float baseCost = 0.0f;
        FormID relatedID = new FormID();
        ActorValue skillType = ActorValue.NONE;
        ActorValue resistanceAV = ActorValue.NONE;
        int counterEffectCount = 0;
        FormID lightID = new FormID();
        float taperWeight = 0.0f;
        FormID hitShader = new FormID();
        FormID enchantShader = new FormID();
        int skillLevel = 0;
        int area = 0;
        float castingTime = 0.0f;
        float taperCurve = 0.0f;
        float taperDuration = 0.0f;
        float secondAVWeight = 0.0f;
        int effectType = 0;
        ActorValue primaryAV = ActorValue.Health;
        FormID projectileID = new FormID();
        FormID explosionID = new FormID();
        CastType castType = CastType.ConstantEffect;
        DeliveryType deliveryType = DeliveryType.Self;
        ActorValue secondAV = ActorValue.NONE;
        FormID castingArt = new FormID();
        FormID hitEffectArt = new FormID();
        FormID impactData = new FormID();
        float skillUsageMult = 0.0f;
        FormID dualCastID = new FormID();
        float dualCastScale = 1.0f;
        FormID enchantArtID = new FormID();
        int nullData = 0;
        int nullData2 = 0;
        FormID equipAbility = new FormID();
        FormID imageSpaceModID = new FormID();
        FormID perkID = new FormID();
        SoundVolume vol = SoundVolume.Normal;
        float scriptAIDataScore = 0.0f;
        float scriptAIDataDelayTime = 0.0f;

        DATA() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.flags.export(), 4);
            out.write(this.baseCost);
            this.relatedID.export(out);
            out.write(ActorValue.value(this.skillType));
            out.write(ActorValue.value(this.resistanceAV));
            out.write(this.counterEffectCount);
            this.lightID.export(out);
            out.write(this.taperWeight);
            this.hitShader.export(out);
            this.enchantShader.export(out);
            out.write(this.skillLevel);
            out.write(this.area);
            out.write(this.castingTime);
            out.write(this.taperCurve);
            out.write(this.taperDuration);
            out.write(this.secondAVWeight);
            out.write(this.effectType);
            out.write(ActorValue.value(this.primaryAV));
            this.projectileID.export(out);
            this.explosionID.export(out);
            out.write(this.castType.ordinal());
            out.write(this.deliveryType.ordinal());
            out.write(ActorValue.value(this.secondAV));
            this.castingArt.export(out);
            this.hitEffectArt.export(out);
            this.impactData.export(out);
            out.write(this.skillUsageMult);
            this.dualCastID.export(out);
            out.write(this.dualCastScale);
            this.enchantArtID.export(out);
            out.write(this.nullData, 4);
            out.write(this.nullData2, 4);
            this.equipAbility.export(out);
            this.imageSpaceModID.export(out);
            this.perkID.export(out);
            out.write(this.vol.ordinal());
            out.write(this.scriptAIDataScore);
            out.write(this.scriptAIDataDelayTime);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.flags.set(in.extract(4));
            this.baseCost = in.extractFloat();
            this.relatedID.parseData(in, srcMod);
            this.skillType = ActorValue.value(in.extractInt(4));
            this.resistanceAV = ActorValue.value(in.extractInt(4));
            this.counterEffectCount = in.extractInt(4);
            this.lightID.parseData(in, srcMod);
            this.taperWeight = in.extractFloat();
            this.hitShader.parseData(in, srcMod);
            this.enchantShader.parseData(in, srcMod);
            this.skillLevel = in.extractInt(4);
            this.area = in.extractInt(4);
            this.castingTime = in.extractFloat();
            this.taperCurve = in.extractFloat();
            this.taperDuration = in.extractFloat();
            this.secondAVWeight = in.extractFloat();
            this.effectType = in.extractInt(4);
            this.primaryAV = ActorValue.value(in.extractInt(4));
            this.projectileID.parseData(in, srcMod);
            this.explosionID.parseData(in, srcMod);
            this.castType = CastType.values()[in.extractInt(4)];
            this.deliveryType = DeliveryType.values()[in.extractInt(4)];
            this.secondAV = ActorValue.value(in.extractInt(4));
            this.castingArt.parseData(in, srcMod);
            this.hitEffectArt.parseData(in, srcMod);
            this.impactData.parseData(in, srcMod);
            this.skillUsageMult = in.extractFloat();
            this.dualCastID.parseData(in, srcMod);
            this.dualCastScale = in.extractFloat();
            this.enchantArtID.parseData(in, srcMod);
            this.nullData = in.extractInt(4);
            this.nullData2 = in.extractInt(4);
            this.equipAbility.parseData(in, srcMod);
            this.imageSpaceModID.parseData(in, srcMod);
            this.perkID.parseData(in, srcMod);
            this.vol = SoundVolume.values()[in.extractInt(4)];
            this.scriptAIDataScore = in.extractFloat();
            this.scriptAIDataDelayTime = in.extractFloat();
            if (SPGlobal.logMods) {
                DATA.logMod(srcMod, "", "DATA:");
                DATA.logMod(srcMod, "", "  Flags: " + this.flags);
                DATA.logMod(srcMod, "", "  Base Cost: " + this.baseCost);
                DATA.logMod(srcMod, "", "  Related ID: " + this.relatedID);
                DATA.logMod(srcMod, "", "  skillType: " + (Object)((Object)this.skillType));
                DATA.logMod(srcMod, "", "  resistanceAV: " + (Object)((Object)this.resistanceAV));
                DATA.logMod(srcMod, "", "  Light: " + this.lightID);
                DATA.logMod(srcMod, "", "  Taper Weight: " + this.taperWeight);
                DATA.logMod(srcMod, "", "  Hit Shader: " + this.hitShader);
                DATA.logMod(srcMod, "", "  Enchant Shader: " + this.enchantShader);
                DATA.logMod(srcMod, "", "  Skill Level: " + this.skillLevel);
                DATA.logMod(srcMod, "", "  Area: " + this.area);
                DATA.logMod(srcMod, "", "  Casting Time: " + this.castingTime);
                DATA.logMod(srcMod, "", "  Taper Curve: " + this.taperCurve);
                DATA.logMod(srcMod, "", "  Taper Duration: " + this.taperDuration);
                DATA.logMod(srcMod, "", "  second AV weight: " + this.secondAVWeight);
                DATA.logMod(srcMod, "", "  Effect Type: " + this.effectType);
                DATA.logMod(srcMod, "", "  Primary AV: " + (Object)((Object)this.primaryAV));
                DATA.logMod(srcMod, "", "  Projectile : " + this.projectileID);
                DATA.logMod(srcMod, "", "  Explosion: " + this.explosionID);
                DATA.logMod(srcMod, "", "  Cast Type: " + (Object)((Object)this.castType));
                DATA.logMod(srcMod, "", "  Delivery Type: " + (Object)((Object)this.deliveryType));
                DATA.logMod(srcMod, "", "  Second AV: " + (Object)((Object)this.secondAV));
                DATA.logMod(srcMod, "", "  Casting Art: " + this.castingArt);
                DATA.logMod(srcMod, "", "  Hit Effect Art: " + this.hitEffectArt);
                DATA.logMod(srcMod, "", "  Impact Data: " + this.impactData);
                DATA.logMod(srcMod, "", "  Skill Usage Mult: " + this.skillUsageMult);
                DATA.logMod(srcMod, "", "  Dual Cast ID: " + this.dualCastID);
                DATA.logMod(srcMod, "", "  Dual Cast Scale: " + this.dualCastScale);
                DATA.logMod(srcMod, "", "  Enchant Art: " + this.enchantArtID);
                DATA.logMod(srcMod, "", "  Equip Ability: " + this.equipAbility);
                DATA.logMod(srcMod, "", "  Image Space Mod ID: " + this.imageSpaceModID);
                DATA.logMod(srcMod, "", "  Perk: " + this.perkID);
                DATA.logMod(srcMod, "", "  Volume: " + (Object)((Object)this.vol));
                DATA.logMod(srcMod, "", "  Script AI Data Score: " + this.scriptAIDataScore);
                DATA.logMod(srcMod, "", "  Script AI Data Delay Time: " + this.scriptAIDataDelayTime);
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 152;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(14);
            out.add(this.relatedID);
            out.add(this.lightID);
            out.add(this.hitShader);
            out.add(this.enchantShader);
            out.add(this.projectileID);
            out.add(this.explosionID);
            out.add(this.castingArt);
            out.add(this.hitEffectArt);
            out.add(this.impactData);
            out.add(this.dualCastID);
            out.add(this.enchantArtID);
            out.add(this.equipAbility);
            out.add(this.imageSpaceModID);
            out.add(this.perkID);
            return out;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }

    static class SNDD
    extends SubRecord {
        ArrayList<Sound> sounds = new ArrayList();

        SNDD() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            for (Sound s : this.sounds) {
                out.write(s.sound.ordinal());
                s.soundID.export(out);
            }
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            while (!in.isDone().booleanValue()) {
                Sound sound = new Sound();
                sound.sound = SoundData.values()[in.extractInt(4)];
                sound.soundID.parseData(in, srcMod);
                this.sounds.add(sound);
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new SNDD();
        }

        @Override
        boolean isValid() {
            return !this.sounds.isEmpty();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 8 * this.sounds.size();
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>();
            for (Sound s : this.sounds) {
                out.add(s.soundID);
            }
            return out;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("SNDD");
        }
    }

    public static class Sound {
        SoundData sound;
        FormID soundID = new FormID();

        private Sound() {
        }

        public Sound(SoundData sound, FormID soundID) {
            this.sound = sound;
            this.soundID = soundID;
        }

        public SoundData getSoundData() {
            return this.sound;
        }

        public void setSoundData(SoundData sound) {
            this.sound = sound;
        }

        public FormID getSoundID() {
            return this.soundID;
        }

        public void setSoundID(FormID soundID) {
            this.soundID = soundID;
        }

        public String toString() {
            return "Sound [sound=" + (Object)((Object)this.sound) + ", soundID=" + this.soundID + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.sound == null ? 0 : this.sound.hashCode());
            result = 31 * result + (this.soundID == null ? 0 : this.soundID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Sound other = (Sound)obj;
            if (this.sound != other.sound) {
                return false;
            }
            return !(this.soundID == null ? other.soundID != null : !this.soundID.equals(other.soundID));
        }
    }

    public static enum SoundData {
        SheathDraw,
        Charge,
        Ready,
        Release,
        ConcentrationCastLoop,
        OnHit;

    }

    public static enum SpellEffectFlag {
        Hostile(0),
        Recover(1),
        Detrimental(2),
        SnapToNavmesh(3),
        NoHitEvent(4),
        Unknown_6(5),
        Unknown_7(6),
        Unknown_8(7),
        DispellEffects(8),
        NoDuration(9),
        NoMagnitude(10),
        NoArea(11),
        FXPersist(12),
        Unknown_14(13),
        GoryVisual(14),
        HideInUI(15),
        Unknown_17(16),
        NoRecast(17),
        Unknown_19(18),
        Unknown_20(19),
        Unknown_21(20),
        PowerAffectsMagnitude(21),
        PowerAffectsDuration(22),
        Unknown_24(23),
        Unknown_25(24),
        Unknown_26(25),
        Painless(26),
        NoHitEffect(27),
        NoDeathDispel(28),
        Unknown_30(29),
        Unknown_31(30),
        Unknown_32(31);

        int value;

        private SpellEffectFlag(int value) {
            this.value = value;
        }
    }
}

