/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Owner;
import skyproc.Record;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubShell;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class LeveledEntry
extends SubShell {
    static final SubPrototype LVLOproto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new LVLOin());
            this.add(new Owner());
        }
    };

    public LeveledEntry(FormID id, int level, int count) {
        this();
        this.setForm(id);
        this.setLevel(level);
        this.setCount(count);
    }

    LeveledEntry() {
        super(LVLOproto);
    }

    @Override
    boolean isValid() {
        return this.subRecords.isAnyValid();
    }

    @Override
    SubRecord getNew(String type) {
        return new LeveledEntry();
    }

    LVLOin getEntry() {
        return (LVLOin)this.subRecords.get("LVLO");
    }

    public int getLevel() {
        return this.getEntry().level;
    }

    public final void setLevel(int in) {
        this.getEntry().level = in;
    }

    public final void setCount(int in) {
        this.getEntry().count = in;
    }

    public int getCount() {
        return this.getEntry().count;
    }

    public final void setForm(FormID id) {
        this.getEntry().entry = id;
    }

    public FormID getForm() {
        return this.getEntry().entry;
    }

    public float getItemCondition() {
        Owner own = (Owner)this.subRecords.get("COED");
        float cond = own.getItemCondition();
        return cond == 0.0f ? 1.0f : cond;
    }

    public void setItemCondition(float itemCondition) {
        Owner own = (Owner)this.subRecords.get("COED");
        own.setItemCondition(itemCondition);
    }

    static class LVLOin
    extends SubRecord {
        int level = 1;
        FormID entry = new FormID();
        int count = 1;

        LVLOin() {
        }

        @Override
        SubRecord getNew(String type) {
            return new LVLOin();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 12;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(1);
            out.add(this.entry);
            return out;
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.level, 4);
            this.entry.export(out);
            out.write(this.count, 4);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.level = in.extractInt(4);
            this.entry.parseData(in, srcMod);
            this.count = in.extractInt(4);
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("LVLO");
        }
    }
}

