/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.AltTextures;
import skyproc.FormID;
import skyproc.MagicItem;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.ScriptPackage;
import skyproc.SubForm;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class INGR
extends MagicItem {
    static final SubPrototype INGRproto = new SubPrototype(MagicItem.magicItemProto){

        @Override
        protected void addRecords() {
            this.after(new ScriptPackage(), "EDID");
            this.remove("DESC");
            this.add(new Model());
            this.add(new SubForm("YNAM"));
            this.add(new SubForm("ZNAM"));
            this.add(new DATA());
            this.add(new ENIT());
            this.reposition("EFID");
            this.add(SubString.getNew("ICON", true));
            this.add(SubString.getNew("MICO", true));
            this.add(new SubForm("ETYP"));
        }
    };

    INGR() {
        this.subRecords.setPrototype(INGRproto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("INGR");
    }

    @Override
    Record getNew() {
        return new INGR();
    }

    public ScriptPackage getScriptPackage() {
        return this.subRecords.getScripts();
    }

    public void setModel(String path) {
        this.subRecords.getModel().setFileName(path);
    }

    public String getModel() {
        return this.subRecords.getModel().getFileName();
    }

    public void setPickupSound(FormID pickupSound) {
        this.subRecords.setSubForm("YNAM", pickupSound);
    }

    public FormID getPickupSound() {
        return this.subRecords.getSubForm("YNAM").getForm();
    }

    public void setDropSound(FormID dropSound) {
        this.subRecords.setSubForm("ZNAM", dropSound);
    }

    public FormID getDropSound() {
        return this.subRecords.getSubForm("ZNAM").getForm();
    }

    DATA getDATA() {
        return (DATA)this.subRecords.get("DATA");
    }

    public void setWeight(float weight) {
        this.getDATA().weight = weight;
    }

    public float getWeight() {
        return this.getDATA().weight;
    }

    public int getValue() {
        return this.getDATA().value;
    }

    public void setValue(int value) {
        this.getDATA().value = value;
    }

    ENIT getENIT() {
        return (ENIT)this.subRecords.get("ENIT");
    }

    public void setBaseCost(int baseCost) {
        this.getENIT().baseCost = baseCost;
    }

    public int getBaseCost() {
        return this.getENIT().baseCost;
    }

    public void set(INGRFlag flag, boolean on) {
        this.getENIT().flags.set(flag.value, on);
    }

    public boolean get(INGRFlag flag) {
        return this.getENIT().flags.get(flag.value);
    }

    public void setInventoryIcon(String filename) {
        this.subRecords.setSubString("ICON", filename);
    }

    public String getInventoryIcon() {
        return this.subRecords.getSubString("ICON").print();
    }

    public void setMessageIcon(String filename) {
        this.subRecords.setSubString("MICO", filename);
    }

    public String getMessageIcon() {
        return this.subRecords.getSubString("MICO").print();
    }

    public void setEquipType(FormID equipType) {
        this.subRecords.setSubForm("ETYP", equipType);
    }

    public FormID getEquipType() {
        return this.subRecords.getSubForm("ETYP").getForm();
    }

    public ArrayList<AltTextures.AltTexture> getAltTextures() {
        return this.subRecords.getModel().getAltTextures();
    }

    public Model getModelData() {
        return this.subRecords.getModel();
    }

    static class DATA
    extends SubRecord {
        int value = 0;
        float weight = 0.0f;

        DATA() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.value);
            out.write(this.weight);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.value = in.extractInt(4);
            this.weight = in.extractFloat();
            if (SPGlobal.logMods) {
                DATA.logMod(srcMod, "", "Setting DATA:    Weight: " + this.weight);
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 8;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }

    static class ENIT
    extends SubRecord {
        int baseCost = 0;
        LFlags flags = new LFlags(4);

        ENIT() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.baseCost);
            out.write(this.flags.export(), 4);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.baseCost = in.extractInt(4);
            this.flags.set(in.extract(4));
            if (SPGlobal.logMods) {
                ENIT.logMod(srcMod, "", "Base cost: " + this.baseCost + ", flags: " + this.flags);
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new ENIT();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 8;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("ENIT");
        }
    }

    public static enum INGRFlag {
        ManualCalc(0),
        Food(1),
        ReferencesPersist(8);

        int value;

        private INGRFlag(int value) {
            this.value = value;
        }
    }
}

