/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.AltTextures;
import skyproc.FormID;
import skyproc.MajorRecordNamed;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.Record;
import skyproc.SubForm;
import skyproc.SubInt;
import skyproc.SubList;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.SubShell;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.HeadPartFlags;

public class HDPT
extends MajorRecordNamed {
    static final SubPrototype HDPTproto = new SubPrototype(MajorRecordNamed.namedProto){

        @Override
        protected void addRecords() {
            this.add(new Model());
            this.add(new HDPT_Flags("DATA"));
            this.add(new SubInt("PNAM"));
            this.add(new SubList(new SubForm("HNAM")));
            this.add(new SubList(new SubShell(new SubPrototype(){

                @Override
                protected void addRecords() {
                    this.add(new SubInt("NAM0"));
                    this.add(SubString.getNew("NAM1", true));
                }
            })));
            this.add(new SubForm("CNAM"));
            this.add(new SubForm("TNAM"));
            this.add(new SubForm("RNAM"));
        }
    };

    HDPT() {
        this.subRecords.setPrototype(HDPTproto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("HDPT");
    }

    @Override
    Record getNew() {
        return new HDPT();
    }

    public void setModel(String path) {
        this.subRecords.getModel().setFileName(path);
    }

    public String getModel() {
        return this.subRecords.getModel().getFileName();
    }

    public ArrayList<FormID> getHeadParts() {
        return this.subRecords.getSubList("HNAM").toPublic();
    }

    public void addHeadPart(FormID id) {
        this.subRecords.getSubList("HNAM").add(id);
    }

    public void removeHeadPart(FormID id) {
        this.subRecords.getSubList("HNAM").remove(id);
    }

    public void clearHeadParts() {
        this.subRecords.getSubList("HNAM").clear();
    }

    public void setBaseTexture(FormID txst) {
        this.subRecords.setSubForm("TNAM", txst);
    }

    public FormID getBaseTexture() {
        return this.subRecords.getSubForm("TNAM").getForm();
    }

    public void setResourceList(FormID id) {
        this.subRecords.setSubForm("RNAM", id);
    }

    public FormID getResourceList() {
        return this.subRecords.getSubForm("RNAM").getForm();
    }

    public ArrayList<AltTextures.AltTexture> getAltTextures() {
        return this.subRecords.getModel().getAltTextures();
    }

    public Model getModelData() {
        return this.subRecords.getModel();
    }

    public boolean getHeadPartFlag(HeadPartFlags flag) {
        HDPT_Flags h = (HDPT_Flags)this.subRecords.get("DATA");
        return h.flags.get(flag.ordinal());
    }

    public void setHeadPartFlag(HeadPartFlags flag, boolean on) {
        HDPT_Flags h = (HDPT_Flags)this.subRecords.get("DATA");
        h.flags.set(flag.ordinal(), on);
    }

    public HDPT_Type getHDPT_Type() {
        int i = this.subRecords.getSubInt("PNAM").get();
        return HDPT_Type.values()[i];
    }

    public void setHDPT_Type(HDPT_Type t) {
        int i = t.ordinal();
        this.subRecords.getSubInt("PNAM").set(i);
    }

    static class HDPT_Flags
    extends SubRecordTyped {
        LFlags flags = new LFlags(1);

        HDPT_Flags(String type) {
            super(type);
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.flags.export(), 1);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.flags = new LFlags(in.extract(1));
        }

        @Override
        SubRecord getNew(String type) {
            return new HDPT_Flags(type);
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 1;
        }
    }

    public static enum HDPT_Type {
        Misc,
        Face,
        Eyes,
        Hair,
        Facial_Hair,
        Scar,
        Eyebrows;

    }
}

