/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import lev.LMergeMap;

public class EmbeddedScripts {
    static void parseScriptDataGibMe() throws FileNotFoundException, IOException {
        String dir = "Validation Files/";
        BufferedReader in = new BufferedReader(new FileReader(String.valueOf(dir) + "EmbeddedScriptSourceGib.txt"));
        BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(dir) + "EmbeddedScriptGibOut.txt"));
        BufferedWriter log = new BufferedWriter(new FileWriter(String.valueOf(dir) + "EmbeddedScriptGibOutLog.txt"));
        ArrayList<String> enumStrings = new ArrayList<String>();
        int curIndex = -1;
        while (in.ready()) {
            String line = in.readLine();
            log.write("Read Line: " + line + "\n");
            Scanner tokenizer = new Scanner(line);
            try {
                int index = Integer.valueOf(tokenizer.next());
                log.write("  Index: " + index + "\n");
                if (index < 4096) {
                    log.write("  Skipped.\n");
                    continue;
                }
                index -= 4096;
                String name = tokenizer.next();
                if (name.contains("ref.")) {
                    name = tokenizer.next();
                }
                log.write("  Ref: " + name + "\n");
                ArrayList<ParamType> parameterMask = new ArrayList<ParamType>();
                tokenizer.useDelimiter(",");
                while (tokenizer.hasNext()) {
                    String parameter = tokenizer.next();
                    if (parameter.toUpperCase().contains("NAME")) {
                        parameterMask.add(ParamType.String);
                        log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.String) + "\n");
                        continue;
                    }
                    if (parameter.toUpperCase().contains("AXIS")) {
                        parameterMask.add(ParamType.Axis);
                        log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.Axis) + "\n");
                        continue;
                    }
                    if (parameter.toUpperCase().contains("UNK") || parameter.toUpperCase().contains("QUEST") || parameter.toUpperCase().contains("ACTOR") || parameter.toUpperCase().contains("CONTAINER")) {
                        parameterMask.add(ParamType.FormID);
                        log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.FormID) + "\n");
                        continue;
                    }
                    parameterMask.add(ParamType.Int);
                    log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.Int) + "\n");
                }
                if (parameterMask.size() > 3) {
                    log.write("  Skipped.\n");
                    continue;
                }
                String enumString = String.valueOf(name) + " (";
                boolean first = true;
                for (ParamType b : parameterMask) {
                    if (first) {
                        first = false;
                    } else {
                        enumString = String.valueOf(enumString) + ", ";
                    }
                    enumString = String.valueOf(enumString) + "ParamType." + (Object)((Object)b);
                }
                enumString = String.valueOf(enumString) + "), //" + index;
                while (++curIndex < index) {
                    enumStrings.add("UNKNOWN" + curIndex + " (),");
                }
                enumStrings.add(enumString);
            }
            catch (NumberFormatException ex) {
                log.write("  Skipped\n");
            }
        }
        for (String s : enumStrings) {
            out.write(String.valueOf(s) + "\n");
        }
        in.close();
        out.close();
        log.close();
    }

    static ArrayList<ScriptDef> parseScriptData() throws IOException {
        String dir = "Validation Files/";
        ArrayList<ScriptDef> out = new ArrayList<ScriptDef>();
        BufferedReader in = new BufferedReader(new FileReader(String.valueOf(dir) + "EmbeddedScriptSource.txt"));
        BufferedWriter log = new BufferedWriter(new FileWriter(String.valueOf(dir) + "EmbeddedScriptOutLog.txt"));
        BufferedWriter error = new BufferedWriter(new FileWriter(String.valueOf(dir) + "EmbeddedScriptOutError.txt"));
        while (in.ready()) {
            String line = in.readLine();
            log.write("Read Line: " + line + "\n");
            Scanner tokenizer = new Scanner(line);
            tokenizer.useDelimiter(",");
            try {
                int index = Integer.valueOf(tokenizer.next().trim());
                log.write("  Index: " + index + "\n");
                String name = tokenizer.next().trim();
                log.write("  Ref: " + name + "\n");
                ArrayList<ParamType> parameterMask = new ArrayList<ParamType>();
                while (tokenizer.hasNext()) {
                    String parameter = tokenizer.next().trim().toUpperCase();
                    if (parameter.equals("")) continue;
                    if (parameter.contains("?")) {
                        error.write(String.valueOf(name) + " Unknown Param: " + parameter + "\n");
                        log.write("Unknown: " + parameter + "\n");
                        continue;
                    }
                    if (parameter.contains("STRING")) {
                        parameterMask.add(ParamType.String);
                        log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.String) + "\n");
                        continue;
                    }
                    if (parameter.contains("AXIS")) {
                        parameterMask.add(ParamType.Axis);
                        log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.Axis) + "\n");
                        continue;
                    }
                    if (parameter.contains("FORMID")) {
                        parameterMask.add(ParamType.FormID);
                        log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.FormID) + "\n");
                        continue;
                    }
                    if (parameter.contains("SEX")) {
                        parameterMask.add(ParamType.Gender);
                        log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.Gender) + "\n");
                        continue;
                    }
                    if (parameter.contains("CRIME")) {
                        parameterMask.add(ParamType.CrimeType);
                        log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.CrimeType) + "\n");
                        continue;
                    }
                    if (parameter.contains("CASTING SOURCE")) {
                        parameterMask.add(ParamType.CastingSource);
                        log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.CastingSource) + "\n");
                        continue;
                    }
                    if (parameter.contains("WARD STATE")) {
                        parameterMask.add(ParamType.WardState);
                        log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.WardState) + "\n");
                        continue;
                    }
                    if (parameter.contains("FLOAT")) {
                        parameterMask.add(ParamType.Float);
                        log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.Float) + "\n");
                        continue;
                    }
                    if (parameter.contains("INT")) {
                        parameterMask.add(ParamType.Int);
                        log.write("  Parameter " + parameter + " " + (Object)((Object)ParamType.Int) + "\n");
                        continue;
                    }
                    error.write(String.valueOf(name) + " Unknown Param: " + parameter + "\n");
                    log.write("Unknown: " + parameter + "\n");
                }
                if (parameterMask.size() > 3) {
                    log.write("  Skipped.\n");
                    error.write("Skipped: " + line + ".  Had more than 3 params.\n");
                    continue;
                }
                ScriptDef def = new ScriptDef();
                def.name = name;
                def.index = index;
                def.params = parameterMask;
                out.add(def);
            }
            catch (NumberFormatException ex) {
                log.write("  Skipped\n");
            }
        }
        in.close();
        log.close();
        error.close();
        return out;
    }

    public static void generateEnum() throws IOException {
        ArrayList<ScriptDef> scripts = EmbeddedScripts.parseScriptData();
        String dir = "Validation Files/";
        BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(dir) + "EmbeddedScriptOut.txt"));
        for (ScriptDef d : scripts) {
            out.write(d.print());
        }
        out.close();
    }

    public static void generateEnums() throws IOException {
        ArrayList<ScriptDef> scripts = EmbeddedScripts.parseScriptData();
        String dir = "Validation Files/";
        BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(dir) + "EmbeddedScriptOut.txt"));
        ArrayList enumStrings = new ArrayList();
        LMergeMap enumBins = new LMergeMap(Boolean.valueOf(false));
        for (ScriptDef d : scripts) {
            String category = "";
            boolean first = true;
            for (ParamType t : d.params) {
                if (first) {
                    first = false;
                } else {
                    category = String.valueOf(category) + "_";
                }
                category = String.valueOf(category) + t.toString();
            }
            if (category.equals("")) {
                category = "NoParams";
            }
            category = "P_" + category;
            enumBins.put((Object)category, (Object)d);
        }
        for (String enumName : enumBins.keySet()) {
            ArrayList scriptDefs = enumBins.get((Object)enumName);
            out.write("public enum " + enumName + " {\n");
            int i = 0;
            while (i < scriptDefs.size()) {
                out.write("\t" + ((ScriptDef)scriptDefs.get((int)i)).name + "(" + ((ScriptDef)scriptDefs.get((int)i)).index + ")");
                if (i < scriptDefs.size() - 1) {
                    out.write(",");
                } else {
                    out.write(";");
                }
                out.write("\n");
                ++i;
            }
            out.write("\n\tint index;\n\n");
            out.write("\t" + enumName + "(int index) {\n" + "\t\tthis.index = index;\n" + "\t}\n\n");
            ScriptDef d = (ScriptDef)scriptDefs.get(0);
            out.write("\tpublic ParamType getType(Param p) {\n");
            out.write("\t\tswitch (p){\n");
            Param[] paramArray = Param.values();
            int n = paramArray.length;
            int n2 = 0;
            while (n2 < n) {
                Param p = paramArray[n2];
                ParamType t = p.ordinal() < d.params.size() ? d.params.get(p.ordinal()) : ParamType.NULL;
                out.write("\t\t\tcase " + (Object)((Object)p) + ":\n");
                out.write("\t\t\t\treturn ParamType." + (Object)((Object)t) + ";\n");
                ++n2;
            }
            out.write("\t\t\tdefault:\n");
            out.write("\t\t\t\treturn ParamType.NULL;\n");
            out.write("\t\t}\n");
            out.write("\t}\n");
            out.write("}\n\n");
        }
        for (String enumName : enumBins.keySet()) {
            out.write("\t\tfor (" + enumName + " e : " + enumName + ".values()){\n");
            out.write("\t\t\tscriptMap.put(e.index, e);\n");
            out.write("\t\t}\n\n");
        }
        out.close();
    }

    public static enum Param {
        One,
        Two,
        Three;

    }

    public static enum ParamType {
        FormID,
        Int,
        String,
        Axis,
        Gender,
        CrimeType,
        CastingSource,
        WardState,
        Float,
        NULL;

    }

    static class ScriptDef {
        int index;
        String name;
        ArrayList<ParamType> params = new ArrayList();

        ScriptDef() {
        }

        String print() {
            String out = String.valueOf(this.name) + " (" + this.index;
            for (ParamType b : this.params) {
                out = String.valueOf(out) + ", ParamType." + (Object)((Object)b);
            }
            out = String.valueOf(out) + "),\n";
            return out;
        }
    }
}

