/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.FormID;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class ECZN
extends MajorRecord {
    static final SubPrototype ECZNproto = new SubPrototype(MajorRecord.majorProto){

        @Override
        protected void addRecords() {
            this.add(new DATA());
        }
    };

    ECZN() {
        this.subRecords.setPrototype(ECZNproto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("ECZN");
    }

    @Override
    Record getNew() {
        return new ECZN();
    }

    DATA getDATA() {
        return (DATA)this.subRecords.get("DATA");
    }

    public boolean get(ECZNFlags flag) {
        return this.getDATA().flags.get(flag.value);
    }

    public void set(ECZNFlags flag, boolean on) {
        this.getDATA().flags.set(flag.value, on);
    }

    public FormID getLocation() {
        return this.getDATA().location;
    }

    public void setLocation(FormID location) {
        this.getDATA().location = location;
    }

    public int getMaxLevel() {
        return this.getDATA().maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.getDATA().maxLevel = maxLevel;
    }

    public int getMinLevel() {
        return this.getDATA().minLevel;
    }

    public void setMinLevel(int minLevel) {
        this.getDATA().minLevel = minLevel;
    }

    public FormID getOwner() {
        return this.getDATA().owner;
    }

    public void setOwner(FormID owner) {
        this.getDATA().owner = owner;
    }

    public int getRank() {
        return this.getDATA().rank;
    }

    public void setRank(int rank) {
        this.getDATA().rank = rank;
    }

    static final class DATA
    extends SubRecord
    implements Serializable {
        private FormID owner = new FormID();
        private FormID location = new FormID();
        private int rank = 0;
        private int minLevel = 0;
        LFlags flags = new LFlags(1);
        private int maxLevel = 0;
        private boolean valid = false;

        DATA() {
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        final void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.owner.parseData(in, srcMod);
            this.location.parseData(in, srcMod);
            if (!in.isDone().booleanValue()) {
                this.rank = in.extractInt(1);
                this.minLevel = in.extractInt(1);
                this.flags.set(in.extract(1));
                this.maxLevel = in.extractInt(1);
            }
            if (SPGlobal.logMods) {
                DATA.logMod(srcMod, "", "DATA record: ");
                DATA.logMod(srcMod, "", "  Owner: " + this.owner.getFormStr() + ", Location: " + this.location.getFormStr());
                DATA.logMod(srcMod, "", "  Required Rank: " + this.rank + ", Minimum Level: " + this.minLevel);
                DATA.logMod(srcMod, "", "  Max Level: " + this.maxLevel + ", Flags: " + this.flags);
            }
            this.valid = true;
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            if (this.isValid()) {
                this.owner.export(out);
                this.location.export(out);
                out.write(this.rank, 1);
                out.write(this.minLevel, 1);
                out.write(this.flags.export(), 1);
                out.write(this.maxLevel, 1);
            }
        }

        @Override
        boolean isValid() {
            return this.valid;
        }

        @Override
        int getContentLength(ModExporter out) {
            if (this.isValid()) {
                return 12;
            }
            return 0;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(2);
            out.add(this.owner);
            out.add(this.location);
            return out;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }

    public static enum ECZNFlags {
        NeverResets(1),
        MatchPCBelowMin(2),
        DisableCombatBoundary(4);

        int value;

        private ECZNFlags(int value) {
            this.value = value;
        }
    }
}

