/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.AltTextures;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SubData;
import skyproc.SubList;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.SubShell;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class DestructionData
extends SubShell {
    static SubPrototype destructionProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new SubData("DEST"));
            this.add(new SubList(new SubShell(new SubPrototype(){

                @Override
                protected void addRecords() {
                    this.add(new DSTD());
                    this.add(SubString.getNew("DMDL", true));
                    this.add(new AltTextures("DMDS"));
                    this.add(new SubData("DSTF"));
                }
            })));
        }
    };

    DestructionData() {
        super(destructionProto);
    }

    @Override
    SubRecord getNew(String type) {
        return new DestructionData();
    }

    @Override
    boolean isValid() {
        return true;
    }

    static class DSTD
    extends SubRecordTyped {
        byte healthPct = 0;
        byte index = 0;
        byte modelDmgStage = 0;
        LFlags flags = new LFlags(1);
        int selfDmgPerSec = 0;
        FormID explosion = new FormID();
        FormID debree = new FormID();
        int debreeCount = 0;

        DSTD() {
            super("DSTD");
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.healthPct);
            out.write(this.index);
            out.write(this.modelDmgStage);
            out.write(this.flags.export());
            out.write(this.selfDmgPerSec);
            this.explosion.export(out);
            this.debree.export(out);
            out.write(this.debreeCount);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
            super.parseData(in, srcMod);
            this.healthPct = in.extract(1)[0];
            this.index = in.extract(1)[0];
            this.modelDmgStage = in.extract(1)[0];
            this.flags.set(in.extract(1));
            this.selfDmgPerSec = in.extractInt(4);
            this.explosion.parseData(in, srcMod);
            this.debree.parseData(in, srcMod);
            this.debreeCount = in.extractInt(4);
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(2);
            out.add(this.explosion);
            out.add(this.debree);
            return out;
        }

        @Override
        SubRecord getNew(String type) {
            return new DSTD();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 20;
        }
    }
}

