/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import lev.Ln;
import skyproc.Condition;
import skyproc.ConditionOption;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class ConditionBase
extends SubRecord {
    Condition.Operator operator = Condition.Operator.EqualTo;
    LFlags flags = new LFlags(1);
    byte[] fluff = new byte[3];
    FormID comparisonValueForm = new FormID();
    float comparisonValueFloat = 0.0f;
    byte[] padding = new byte[2];
    ConditionOption option;

    ConditionBase() {
    }

    @Override
    void export(ModExporter out) throws IOException {
        super.export(out);
        int operatorInt = this.operator.ordinal();
        LFlags tmp = new LFlags(Ln.toByteArray((int)(operatorInt *= 32), (int)1));
        int i = 0;
        while (i < 5) {
            tmp.set(i, this.flags.get(i));
            ++i;
        }
        out.write(tmp.export(), 1);
        out.write(this.fluff, 3);
        if (this.get(Condition.CondFlag.UseGlobal)) {
            this.comparisonValueForm.adjustMasterIndex(out.getExportMod());
            out.write(this.comparisonValueForm.getInternal(true));
        } else {
            out.write(this.comparisonValueFloat);
        }
        out.write(this.option.index, 2);
        out.write(this.padding, 2);
        this.option.export(out);
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.flags.set(in.extract(1));
        int operatorInt = this.flags.export()[0];
        operatorInt &= 0xE0;
        this.operator = Condition.Operator.values()[operatorInt /= 32];
        this.fluff = in.extract(3);
        if (this.get(Condition.CondFlag.UseGlobal)) {
            this.comparisonValueForm = new FormID();
            this.comparisonValueForm.set(Ln.reverse((byte[])in.extract(4)));
            this.comparisonValueForm.standardize(srcMod);
        } else {
            this.comparisonValueFloat = in.extractFloat();
        }
        this.option = ConditionOption.getOption(in.extractInt(2));
        this.padding = in.extract(2);
        if (SPGlobal.logMods) {
            ConditionBase.logMod(srcMod, "", "New Condition.  Function: " + this.option.script.toString() + ", index: " + this.option.index);
            ConditionBase.logMod(srcMod, "", "  Operator: " + (Object)((Object)this.operator) + ", flags: " + this.flags + " useGlobal: " + this.get(Condition.CondFlag.UseGlobal));
            ConditionBase.logMod(srcMod, "", "  Comparison Val: " + this.comparisonValueForm + "|" + this.comparisonValueFloat);
        }
        this.option.parseData(in, srcMod);
    }

    @Override
    ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> out = new ArrayList<FormID>(5);
        if (this.comparisonValueForm != null) {
            out.add(this.comparisonValueForm);
        }
        out.addAll(this.option.allFormIDs());
        return out;
    }

    @Override
    SubRecord getNew(String type) {
        return new ConditionBase();
    }

    @Override
    boolean isValid() {
        return true;
    }

    @Override
    int getContentLength(ModExporter out) {
        return 32;
    }

    public boolean get(Condition.CondFlag flag) {
        return this.flags.get(flag.value);
    }

    public void set(Condition.CondFlag flag, boolean on) {
        this.flags.set(flag.value, on);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("CTDA");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionBase other = (ConditionBase)obj;
        if (this.operator != other.operator) {
            return false;
        }
        if (!Objects.equals(this.flags, other.flags)) {
            return false;
        }
        if (!Arrays.equals(this.fluff, other.fluff)) {
            return false;
        }
        if (!Objects.equals(this.comparisonValueForm, other.comparisonValueForm)) {
            return false;
        }
        if (Float.floatToIntBits(this.comparisonValueFloat) != Float.floatToIntBits(other.comparisonValueFloat)) {
            return false;
        }
        if (!Arrays.equals(this.padding, other.padding)) {
            return false;
        }
        return this.option.equals(other.option);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.operator != null ? this.operator.hashCode() : 0);
        hash = 97 * hash + Objects.hashCode(this.flags);
        hash = 97 * hash + Arrays.hashCode(this.fluff);
        hash = 97 * hash + Objects.hashCode(this.comparisonValueForm);
        hash = 97 * hash + Float.floatToIntBits(this.comparisonValueFloat);
        hash = 97 * hash + Arrays.hashCode(this.padding);
        hash = 97 * hash + Objects.hashCode(this.option);
        return hash;
    }

    @Override
    boolean subRecordEquals(SubRecord subRecord) {
        return this.equals(subRecord);
    }
}

