/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.AltTextures;
import skyproc.DestructionData;
import skyproc.FormID;
import skyproc.KeywordSet;
import skyproc.MajorRecordDescription;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.Record;
import skyproc.ScriptPackage;
import skyproc.SubData;
import skyproc.SubForm;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubString;
import skyproc.SubStringPointer;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.ActorValue;

public class BOOK
extends MajorRecordDescription {
    static final SubPrototype BOOKprototype = new SubPrototype(MajorRecordDescription.descProto){

        @Override
        protected void addRecords() {
            this.add(new ScriptPackage());
            this.add(new SubData("OBND", new byte[12]));
            this.reposition("FULL");
            this.add(new Model());
            this.add(new SubString("ICON"));
            this.add(new SubString("MICO"));
            this.reposition("DESC");
            this.add(new DestructionData());
            this.add(new SubForm("YNAM"));
            this.add(new SubForm("ZNAM"));
            this.add(new KeywordSet());
            this.add(new DATA());
            this.add(new SubForm("INAM"));
            SubStringPointer cnam = new SubStringPointer("CNAM", SubStringPointer.Files.DLSTRINGS);
            cnam.forceExport = true;
            this.add(cnam);
        }
    };

    BOOK() {
        this.subRecords.setPrototype(BOOKprototype);
    }

    @Override
    Record getNew() {
        return new BOOK();
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("BOOK");
    }

    public ScriptPackage getScriptPackage() {
        return this.subRecords.getScripts();
    }

    public void setModel(String path) {
        this.subRecords.getModel().setFileName(path);
    }

    public String getModel() {
        return this.subRecords.getModel().getFileName();
    }

    public void setInventoryImage(String path) {
        this.subRecords.setSubString("ICON", path);
    }

    public String getInventoryImage() {
        return this.subRecords.getSubString("ICON").print();
    }

    public void setMessageImage(String path) {
        this.subRecords.setSubString("MICO", path);
    }

    public String getMessageImage() {
        return this.subRecords.getSubString("MICO").print();
    }

    public void setPickupSound(FormID sound) {
        this.subRecords.setSubForm("YNAM", sound);
    }

    public FormID getPickupSound() {
        return this.subRecords.getSubForm("YNAM").getForm();
    }

    public void setDropSound(FormID sound) {
        this.subRecords.setSubForm("ZNAM", sound);
    }

    public FormID getDropSound() {
        return this.subRecords.getSubForm("ZNAM").getForm();
    }

    public KeywordSet getKeywordSet() {
        return this.subRecords.getKeywords();
    }

    DATA getDATA() {
        return (DATA)this.subRecords.get("DATA");
    }

    public void setValue(int gold) {
        this.getDATA().value = gold;
    }

    public int getValue() {
        return this.getDATA().value;
    }

    public void setWeight(float weight) {
        this.getDATA().weight = weight;
    }

    public float getWeight() {
        return this.getDATA().weight;
    }

    public void set(BookFlag flag, boolean on) {
        this.getDATA().flags.set(flag.ordinal(), on);
    }

    public boolean get(BookFlag flag) {
        return this.getDATA().flags.get(flag.ordinal());
    }

    public void setTeachesAV(ActorValue val) {
        this.getDATA().teachesAV = val;
    }

    public ActorValue getTeachesAV() {
        return this.getDATA().teachesAV;
    }

    public void setTeachesSpell(FormID spell) {
        this.getDATA().teachesSpell = spell;
    }

    public FormID getTeachesSpell() {
        return this.getDATA().teachesSpell;
    }

    public void setInventoryArt(FormID id) {
        this.subRecords.setSubForm("INAM", id);
    }

    public FormID getInventoryArt() {
        return this.subRecords.getSubForm("INAM").getForm();
    }

    @Override
    public String getDescription() {
        return this.subRecords.getSubStringPointer("CNAM").print();
    }

    @Override
    public void setDescription(String description) {
        this.subRecords.setSubStringPointer("CNAM", description);
    }

    public String getText() {
        return this.subRecords.getSubStringPointer("DESC").print();
    }

    public void setText(String text) {
        this.subRecords.setSubStringPointer("DESC", text);
    }

    public ArrayList<AltTextures.AltTexture> getAltTextures() {
        return this.subRecords.getModel().getAltTextures();
    }

    public Model getModelData() {
        return this.subRecords.getModel();
    }

    public static enum BookFlag {
        TeachesSkill,
        CantBeTaken,
        TeachesSpell,
        Read;

    }

    static final class DATA
    extends SubRecord {
        LFlags flags = new LFlags(4);
        ActorValue teachesAV = ActorValue.AbsorbChance;
        FormID teachesSpell = new FormID();
        int value = 0;
        float weight = 0.0f;

        DATA() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.flags.export());
            if (this.flags.get(BookFlag.TeachesSkill.ordinal())) {
                out.write(ActorValue.value(this.teachesAV));
            } else if (this.flags.get(BookFlag.TeachesSpell.ordinal())) {
                this.teachesSpell.export(out);
            } else {
                out.write(-1);
            }
            out.write(this.value);
            out.write(this.weight);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.flags.set(in.extract(4));
            if (this.flags.get(BookFlag.TeachesSpell.ordinal())) {
                this.teachesSpell.parseData(in, srcMod);
            } else {
                this.teachesAV = ActorValue.value(in.extractInt(4));
            }
            this.value = in.extractInt(4);
            this.weight = in.extractFloat();
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 16;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(1);
            out.add(this.teachesSpell);
            return out;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }
}

