/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.AltTextures;
import skyproc.DestructionData;
import skyproc.FormID;
import skyproc.MagicItem;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.Record;
import skyproc.SubFloat;
import skyproc.SubForm;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class ALCH
extends MagicItem {
    static final SubPrototype ALCHproto = new SubPrototype(MagicItem.magicItemProto){

        @Override
        protected void addRecords() {
            this.remove("DESC");
            this.add(new Model());
            this.add(new DestructionData());
            this.add(SubString.getNew("ICON", true));
            this.add(SubString.getNew("MICO", true));
            this.add(new SubForm("YNAM"));
            this.add(new SubForm("ZNAM"));
            this.add(new SubForm("ETYP"));
            this.add(new SubFloat("DATA"));
            this.add(new ENIT());
            this.reposition("EFID");
        }
    };

    ALCH() {
        this.subRecords.setPrototype(ALCHproto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("ALCH");
    }

    @Override
    Record getNew() {
        return new ALCH();
    }

    public void setModel(String groundModel) {
        this.subRecords.getModel().setFileName(groundModel);
    }

    public String getModel() {
        return this.subRecords.getModel().getFileName();
    }

    public void setPickupSound(FormID pickupSound) {
        this.subRecords.setSubForm("YNAM", pickupSound);
    }

    public FormID getPickupSound() {
        return this.subRecords.getSubForm("YNAM").getForm();
    }

    public void setDropSound(FormID dropSound) {
        this.subRecords.setSubForm("ZNAM", dropSound);
    }

    public FormID getDropSound() {
        return this.subRecords.getSubForm("ZNAM").getForm();
    }

    ENIT getEnit() {
        return (ENIT)this.subRecords.get("ENIT");
    }

    public void setValue(int value) {
        this.getEnit().value = value;
    }

    public int getValue() {
        return this.getEnit().value;
    }

    public void set(ALCHFlag flag, boolean on) {
        this.getEnit().flags.set(flag.value, on);
    }

    public boolean get(ALCHFlag flag) {
        return this.getEnit().flags.get(flag.value);
    }

    public void setAddiction(FormID addiction) {
        this.getEnit().addiction = addiction;
    }

    public FormID getAddiction() {
        return this.getEnit().addiction;
    }

    public void setUseSound(FormID useSound) {
        this.getEnit().useSound = useSound;
    }

    public FormID getUseSound() {
        return this.getEnit().useSound;
    }

    public void setWeight(float weight) {
        this.subRecords.setSubFloat("DATA", weight);
    }

    public float getWeight() {
        return this.subRecords.getSubFloat("DATA").get();
    }

    public void setInventoryIcon(String filename) {
        this.subRecords.setSubString("ICON", filename);
    }

    public String getInventoryIcon() {
        return this.subRecords.getSubString("ICON").print();
    }

    public void setMessageIcon(String filename) {
        this.subRecords.setSubString("MICO", filename);
    }

    public String getMessageIcon() {
        return this.subRecords.getSubString("MICO").print();
    }

    public void setEquipType(FormID equipType) {
        this.subRecords.setSubForm("ETYP", equipType);
    }

    public FormID getEquipType() {
        return this.subRecords.getSubForm("ETYP").getForm();
    }

    public ArrayList<AltTextures.AltTexture> getAltTextures() {
        return this.subRecords.getModel().getAltTextures();
    }

    public Model getModelData() {
        return this.subRecords.getModel();
    }

    public static enum ALCHFlag {
        ManualCalc(0),
        Food(1),
        Medicine(16),
        Poison(17);

        int value;

        private ALCHFlag(int in) {
            this.value = in;
        }
    }

    static final class ENIT
    extends SubRecord {
        int value = 0;
        LFlags flags = new LFlags(4);
        FormID addiction = new FormID();
        byte[] addictionChance = new byte[4];
        FormID useSound = new FormID();

        ENIT() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.value);
            out.write(this.flags.export());
            this.addiction.export(out);
            out.write(this.addictionChance, 4);
            this.useSound.export(out);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.value = in.extractInt(4);
            this.flags.set(in.extract(4));
            this.addiction.parseData(in, srcMod);
            this.addictionChance = in.extract(4);
            this.useSound.parseData(in, srcMod);
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(2);
            out.add(this.addiction);
            out.add(this.useSound);
            return out;
        }

        @Override
        SubRecord getNew(String type) {
            return new ENIT();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 20;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("ENIT");
        }
    }
}

