/*
 * Decompiled with CFR 0.152.
 */
package lev.gui;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;

public class SortedListModel<T>
extends AbstractListModel {
    protected SortedSet<T> model = new TreeSet<T>();

    @Override
    public int getSize() {
        return this.model.size();
    }

    @Override
    public T getElementAt(int index) {
        return (T)this.model.toArray()[index];
    }

    public void add(T element) {
        if (this.model.add(element)) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    public void addAll(T[] elements) {
        List<T> c = Arrays.asList(elements);
        this.model.addAll(c);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void clear() {
        this.model.clear();
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public boolean contains(T element) {
        return this.model.contains(element);
    }

    public T firstElement() {
        return this.model.first();
    }

    public Iterator iterator() {
        return this.model.iterator();
    }

    public T lastElement() {
        return this.model.last();
    }

    public boolean removeElement(T element) {
        boolean removed = this.model.remove(element);
        if (removed) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
        return removed;
    }
}

