/*
 * Decompiled with CFR 0.152.
 */
package lev.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import lev.gui.LComponent;

public class LTextPane
extends LComponent {
    protected JScrollPane scroll;
    protected JTextPane pane = new JTextPane();
    protected Document doc = this.pane.getDocument();

    public LTextPane(Color c) {
        this();
        this.setForeground(c);
    }

    public LTextPane() {
        this.pane.setOpaque(false);
        this.setVisible(true);
        this.add(this.pane);
    }

    public LTextPane(int x, int y, Color c) {
        this(c);
        this.setSize(x, y);
    }

    public LTextPane(Dimension size, Color c) {
        this(c);
        this.setSize(size);
    }

    @Override
    public void setSize(Dimension size) {
        this.setSize(size.width, size.height);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.scroll == null) {
            this.pane.setSize(width, height);
        } else {
            this.scroll.setSize(width, height);
        }
    }

    public void setSize(int x) {
        this.setSize(x, this.getHeight(x));
    }

    public int getHeight(int width) {
        View v = this.pane.getUI().getRootView(this.pane);
        v.setSize(width, 2.1474836E9f);
        int preferredHeight = (int)v.getPreferredSpan(1);
        return preferredHeight;
    }

    @Override
    public void setForeground(Color c) {
        this.pane.setForeground(c);
    }

    public void setText(String in) {
        this.clearText();
        try {
            this.doc.insertString(0, in, null);
        }
        catch (BadLocationException ex) {
            this.badText();
        }
    }

    public String getText() {
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException ex) {
            return "ERROR";
        }
    }

    public void badText() {
        try {
            this.doc.insertString(0, "Bad Error", null);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(LTextPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void clearText() {
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void append(String in) {
        try {
            this.doc.insertString(this.doc.getLength(), in, null);
        }
        catch (BadLocationException ex) {
            this.badText();
        }
    }

    public void setOpaque(Boolean b) {
        this.pane.setOpaque(b);
    }

    public void setCentered() {
        StyledDocument doc = this.pane.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
    }

    @Override
    public void setFont(Font f) {
        this.pane.setFont(f);
    }

    public boolean isEmpty() {
        return this.doc.getLength() == 0;
    }

    @Override
    public void setBackground(Color c) {
        this.pane.setBackground(c);
    }

    public void setCaretColor(Color c) {
        this.pane.setCaretColor(c);
    }

    public void centerText() {
        StyledDocument doc = this.pane.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
    }

    public void setContentType(String s) {
        this.pane.setContentType(s);
    }

    public void addScroll() {
        this.removeAll();
        this.scroll = new JScrollPane(this.pane);
        this.scroll.setSize(this.pane.getSize());
        this.scroll.setOpaque(false);
        this.scroll.getViewport().setOpaque(false);
        this.scroll.setBorder(null);
        this.scroll.setVisible(true);
        this.add(this.scroll);
    }

    public void setEditable(boolean b) {
        this.pane.setEditable(b);
    }

    public void setFontSize(float size) {
        this.pane.setFont(this.pane.getFont().deriveFont(size));
    }

    @Override
    public Dimension getPreferredSize() {
        return this.pane.getPreferredSize();
    }
}

