/*
 * Decompiled with CFR 0.152.
 */
package lev.gui;

import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class LSwingTreeNode
extends DefaultMutableTreeNode {
    public boolean contains(LSwingTreeNode node) {
        return this.get(node) != null;
    }

    public LSwingTreeNode get(LSwingTreeNode node) {
        if (this.children != null) {
            for (Object rhs : this.children) {
                if (!node.equals(rhs)) continue;
                return (LSwingTreeNode)rhs;
            }
        }
        return null;
    }

    public ArrayList<LSwingTreeNode> getAllObjects() {
        return this.getAllObjects(false);
    }

    public ArrayList<LSwingTreeNode> getAllObjects(boolean recursive) {
        ArrayList<LSwingTreeNode> out = new ArrayList<LSwingTreeNode>();
        if (this.children != null) {
            for (Object o : this.children) {
                LSwingTreeNode n = (LSwingTreeNode)o;
                out.add(n);
                if (!recursive) continue;
                out.addAll(n.getAllObjects(recursive));
            }
        }
        return out;
    }

    public void print(int depth) {
        for (LSwingTreeNode o : this.getAllObjects()) {
            if (!(o instanceof LSwingTreeNode)) continue;
            LSwingTreeNode n = o;
            n.print(depth + 1);
        }
    }

    public void mergeIn(LSwingTreeNode node) {
        LSwingTreeNode existing = this.get(node);
        if (existing != null) {
            for (LSwingTreeNode o : node.getAllObjects()) {
                if (!(o instanceof LSwingTreeNode)) continue;
                existing.mergeIn(o);
            }
        } else {
            this.add(node);
        }
    }
}

