/*
 * Decompiled with CFR 0.152.
 */
package lev.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.Map;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import lev.gui.LHelpComponent;
import lev.gui.LUserSetting;
import lev.gui.Setting;

public class LSpinner
extends LUserSetting<Integer> {
    protected JSpinner spinner;

    public LSpinner(String title, int init, int min, int max, int step, int width) {
        super(title);
        SpinnerNumberModel model = new SpinnerNumberModel(init, min, max, step);
        this.spinner = new JSpinner(model);
        JFormattedTextField textField = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
        textField.setAlignmentX(4.0f);
        textField.setColumns(width);
        this.spinner.setSize(this.spinner.getPreferredSize());
        this.add(this.spinner);
        this.setSize(this.spinner.getPreferredSize());
    }

    @Override
    protected void addUpdateHandlers() {
        this.spinner.addChangeListener(new LUserSetting.UpdateChangeHandler(this));
    }

    @Override
    public boolean revertTo(Map<Enum, Setting> m) {
        if (this.isTied().booleanValue()) {
            int cur = this.getValue();
            this.setValue(m.get(this.saveTie).getInt());
            if (cur != this.getValue()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Integer getValue() {
        return (Integer)this.spinner.getValue();
    }

    @Override
    protected void addHelpHandler(boolean hoverListener) {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.spinner.getEditor();
        editor.getTextField().addFocusListener(new LHelpComponent.HelpFocusHandler());
        if (hoverListener) {
            LHelpComponent.HelpMouseHandler m = new LHelpComponent.HelpMouseHandler();
            if (this.titleLabel != null) {
                this.titleLabel.addMouseListener(m);
            }
            editor.getTextField().addMouseListener(m);
            for (Component c : this.spinner.getComponents()) {
                c.addMouseListener(m);
            }
        }
    }

    public void setValue(int in) {
        this.spinner.setValue(in);
    }

    @Override
    public synchronized void addFocusListener(FocusListener arg0) {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.spinner.getEditor();
        editor.getTextField().addFocusListener(arg0);
    }

    public void addChangeListener(ChangeListener c) {
        this.spinner.addChangeListener(c);
    }

    @Override
    public void highlightChanged() {
        ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setBackground(new Color(224, 121, 147));
    }

    @Override
    public void clearHighlight() {
        ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setBackground(Color.WHITE);
    }
}

