/*
 * Decompiled with CFR 0.152.
 */
package lev.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import lev.gui.LImagePane;
import lev.gui.LLabel;
import lev.gui.LProgressBar;
import lev.gui.LProgressBarInterface;
import lev.gui.resources.LImages;

public class LProgressBarFrame
extends JFrame
implements LProgressBarInterface {
    protected LProgressBar bar;
    protected LLabel title;
    protected Dimension correctLocation = new Dimension(0, 0);
    protected Dimension GUIsize = new Dimension(250, 100);
    protected LImagePane backgroundPanel;
    protected JFrame guiRef;

    public LProgressBarFrame(Font header, Color headerC, Font footer, Color footerC) {
        this.bar = new LProgressBar(150, 15, footer, footerC);
        this.addComponents(header, headerC);
        this.moveToCorrectLocation();
        this.setDefaultCloseOperation(2);
    }

    final void addComponents(Font header, Color headerC) {
        this.backgroundPanel = new LImagePane(LImages.multipurpose());
        this.backgroundPanel.setVisible(true);
        super.add(this.backgroundPanel);
        this.setSize(this.GUIsize);
        this.setResizable(false);
        this.setLayout(null);
        this.title = new LLabel("Please wait...", header, headerC);
        this.setSize(250, 72);
        this.bar.setLocation(this.getWidth() / 2 - this.bar.getWidth() / 2, this.getHeight() / 2 - this.bar.getHeight() / 2 + 10);
        this.title.setLocation(this.getWidth() / 2 - this.title.getWidth() / 2, 2);
        this.setSize(250, 100);
        this.backgroundPanel.add(this.bar);
        this.backgroundPanel.add(this.title);
        this.setResizable(false);
    }

    public void setExitOnClose() {
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void setMax(int max, String reason) {
        this.bar.setMax(max, reason);
    }

    @Override
    public void incrementBar() {
        this.bar.incrementBar();
    }

    public void setCorrectLocation(int x, int y) {
        this.correctLocation = new Dimension(x, y);
    }

    public final void moveToCorrectLocation() {
        if (this.guiRef != null) {
            Rectangle r = this.guiRef.getBounds();
            this.setLocation(r.x + this.correctLocation.width, r.y + this.correctLocation.height);
        } else {
            this.setLocation(this.correctLocation.width, this.correctLocation.height);
        }
    }

    @Override
    public void setStatus(String input_) {
        this.bar.setStatus(input_);
    }

    public void open() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LProgressBarFrame.this.moveToCorrectLocation();
                LProgressBarFrame.this.setVisible(true);
            }
        });
    }

    public void open(ChangeListener c) {
        this.open();
        this.setDoneListener(c);
    }

    void setDoneListener(ChangeListener c) {
        this.bar.setDoneListener(c);
    }

    public void close() {
        this.setVisible(false);
    }

    public void setGUIref(JFrame ref) {
        this.guiRef = ref;
    }

    @Override
    public void setMax(int in) {
        this.bar.setMax(in);
    }

    @Override
    public void reset() {
        this.bar.reset();
    }

    @Override
    public void setBar(int in) {
        this.bar.setBar(in);
    }

    @Override
    public int getBar() {
        return this.bar.getBar();
    }

    @Override
    public int getMax() {
        return this.bar.getMax();
    }

    @Override
    public void setStatusNumbered(int min, int max, String status) {
        this.bar.setStatusNumbered(min, max, status);
    }

    @Override
    public void setStatusNumbered(String status) {
        this.bar.setStatusNumbered(status);
    }

    @Override
    public void pause(boolean on) {
        this.bar.pause(on);
    }

    @Override
    public boolean paused() {
        return this.bar.paused();
    }

    @Override
    public void done() {
        this.bar.done();
    }

    @Override
    public Component add(Component c) {
        this.backgroundPanel.add(c);
        return c;
    }
}

