/*
 * Decompiled with CFR 0.152.
 */
package lev.gui;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import lev.gui.LComponent;

public class LPanel
extends JPanel
implements Scrollable {
    protected Point last;
    protected int spacing = 12;
    protected Align align = Align.Left;

    public LPanel() {
        this.setLayout(null);
        super.setSize(1, 1);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        super.setVisible(true);
        this.last = new Point(this.spacing, 0);
    }

    public LPanel(Rectangle r) {
        this();
        this.setBounds(r);
    }

    public LPanel(int x, int y) {
        this();
        this.setLocation(x, y);
    }

    public void Add(Component input) {
        input.setVisible(true);
        this.add(input);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(300, 300);
    }

    public void remeasure(Dimension size) {
        this.setSize(size);
    }

    protected static AlphaComposite makeAlphaComposite(float alpha) {
        return AlphaComposite.getInstance(3, alpha);
    }

    public Point setPlacement(Component c) {
        return this.setPlacement(c, this.last.x, this.last.y);
    }

    public Point setPlacement(Component c, int x, int y) {
        switch (this.align) {
            case Right: {
                c.setLocation(x - c.getWidth(), y + this.spacing);
                break;
            }
            case Left: {
                c.setLocation(x, y + this.spacing);
                break;
            }
            case Center: {
                if (c instanceof LComponent) {
                    LComponent lc = (LComponent)c;
                    c.setLocation(lc.getCenter(), y + this.spacing);
                    break;
                }
                c.setLocation(x - c.getWidth() / 2, y + this.spacing);
            }
        }
        this.updateLast(c);
        return this.last;
    }

    public void placeAdd(Component c) {
        this.setPlacement(c);
        this.Add(c);
    }

    public void align(Align align) {
        this.align = align;
    }

    public void updateLast(Component c) {
        this.last = new Point(this.last.x, c.getY() + c.getHeight());
    }

    public static enum Align {
        Left,
        Center,
        Right;

    }
}

