/*
 * Decompiled with CFR 0.152.
 */
package lev.gui;

import java.awt.Color;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import lev.gui.LHelpComponent;

public class LList<T>
extends LHelpComponent
implements Iterable<T> {
    protected DefaultListModel<T> model = new DefaultListModel();
    protected JList<T> list = new JList<T>(this.model);
    protected JScrollPane scroll = new JScrollPane(this.list);
    protected boolean unique;
    protected Comparator compare;
    protected static int spacing = 15;

    public LList(String title) {
        super(title);
        this.scroll.setVisible(true);
        this.add(this.scroll);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.scroll.setSize(width, height);
    }

    public void addElement(T o) {
        if (!this.unique || !this.model.contains(o)) {
            this.model.addElement(o);
        }
    }

    public void addElements(Collection<T> in) {
        for (T t : in) {
            this.addElement(t);
        }
    }

    public List<T> getSelectedElements() {
        return this.list.getSelectedValuesList();
    }

    public T getSelectedElement() {
        return this.list.getSelectedValue();
    }

    public void setSelectedElement(int index) {
        this.list.setSelectedIndex(index);
    }

    public void removeSelected() {
        for (T o : this.list.getSelectedValuesList()) {
            this.model.removeElement(o);
        }
    }

    public int numItems() {
        return this.model.size();
    }

    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    public void clear() {
        this.model.clear();
    }

    public void setUnique(boolean on) {
        this.unique = on;
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.list.addListSelectionListener(l);
    }

    @Override
    public void addMouseListener(MouseListener m) {
        super.addMouseListener(m);
        this.scroll.addMouseListener(m);
        this.list.addMouseListener(m);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getAll().iterator();
    }

    public void highlightChanged() {
        this.list.setBackground(new Color(224, 121, 147));
    }

    public void clearHighlight() {
        this.list.setBackground(Color.white);
    }

    public ArrayList<T> getAll() {
        ArrayList<Object> out = new ArrayList<Object>(this.model.size());
        for (Object o : this.model.toArray()) {
            out.add(o);
        }
        return out;
    }

    @Override
    protected void addHelpHandler(boolean hoverListener) {
        this.addMouseListener(new LHelpComponent.HelpMouseHandler());
    }
}

