/*
 * Decompiled with CFR 0.152.
 */
package lev.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import lev.Ln;

public class LFileTree {
    protected DefaultTreeModel tree;
    protected DefaultMutableTreeNode root = new DefaultMutableTreeNode("");

    public LFileTree() {
        this.tree = new DefaultTreeModel(this.root);
    }

    public void addFile(File f) {
        this.addFile(f.getPath());
    }

    public void addFile(String path) {
        ArrayList<String> list = new ArrayList<String>();
        path = Ln.standardizeFilePath(path);
        list.addAll(Arrays.asList(path.split("/")));
        this.addFile(this.root, list);
    }

    void addFile(DefaultMutableTreeNode node, ArrayList<String> path) {
        if (path.isEmpty()) {
            return;
        }
        String target = path.get(0);
        path.remove(0);
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode nodeC = (DefaultMutableTreeNode)e.nextElement();
            if (!nodeC.toString().equalsIgnoreCase(target)) continue;
            this.addFile(nodeC, path);
            return;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(target);
        node.add(newNode);
        this.addFile(newNode, path);
    }

    public ArrayList<String> getList() {
        ArrayList<String> out = new ArrayList<String>();
        Enumeration<TreeNode> e = this.root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode nodeC = (DefaultMutableTreeNode)e.nextElement();
            out.add(nodeC.toString());
        }
        return out;
    }

    public String print(String fluff) {
        String out = "";
        Enumeration<TreeNode> e = this.root.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode nodeC = (DefaultMutableTreeNode)e.nextElement();
            out = out + this.print(nodeC, 0, fluff);
        }
        return out;
    }

    String print(DefaultMutableTreeNode node, int depth, String fluff) {
        String out = "";
        for (int i = 0; i < depth; ++i) {
            out = out + fluff;
        }
        out = out + node.toString();
        if (!node.isLeaf()) {
            out = out + "/";
        }
        out = out + "\n";
        ++depth;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode nodeC = (DefaultMutableTreeNode)e.nextElement();
            out = out + this.print(nodeC, depth, fluff);
        }
        return out;
    }
}

