/*
 * Decompiled with CFR 0.152.
 */
package lev.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import lev.gui.LButton;
import lev.gui.LCheckBox;
import lev.gui.LHelpComponent;
import lev.gui.LHelpPanel;
import lev.gui.LSaveFile;
import lev.gui.LUserSetting;

public class LCheckBoxConfig
extends LUserSetting {
    protected LSpecialCheckBox cbox;
    protected LButton button;
    public static String buttonText = "Open";
    public static int spacing = 18;

    protected LCheckBoxConfig(String title_) {
        super(title_);
    }

    public LCheckBoxConfig(String title_, int size, int style, Color shade, LHelpPanel help_, LSaveFile save_, Enum setting) {
        super(title_);
        this.help = help_;
        this.save = save_;
        this.saveTie = setting;
        this.button = new LButton(buttonText);
        this.button.addActionListener(new UpdateHelpActionHandler());
        this.cbox = new LSpecialCheckBox(title_, new Font("Serif", size, style), shade, this);
        this.cbox.tie(setting, save_, this.help, false);
        this.button.setLocation(this.cbox.getWidth() + spacing, 0);
        this.add(this.button);
        this.add(this.cbox);
        this.setSize(this.cbox.getWidth() + this.button.getWidth() + spacing, this.cbox.getHeight());
    }

    @Override
    public void updateHelp() {
        this.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LCheckBoxConfig.this.updateHelpHelper();
                            }
                        });
                    }
                });
            }
        });
    }

    private void updateHelpHelper() {
        super.updateHelp();
        if (this.help != null) {
            this.help.setDefaultPos();
            this.help.hideArrow();
        }
    }

    @Override
    protected void addUpdateHandlers() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean revertTo(Map m) {
        return this.cbox.revertTo(m);
    }

    public Object getValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void addHelpHandler(boolean hoverHandler) {
    }

    public void setButtonOffset(int in) {
        this.button.setLocation(this.button.getX(), this.cbox.getY() + in);
        this.setSize(this.getWidth(), this.button.getHeight() + in);
    }

    public void setOffset(int in) {
        this.cbox.setOffset(in);
    }

    public void addShadow() {
        this.cbox.addShadow();
    }

    public JComponent getSource() {
        return this.button.getSource();
    }

    public void addActionListener(ActionListener a) {
        this.button.addActionListener(a);
    }

    @Override
    public void highlightChanged() {
        this.cbox.highlightChanged();
    }

    @Override
    public void clearHighlight() {
        this.cbox.clearHighlight();
    }

    public class UpdateHelpActionHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LCheckBoxConfig.this.updateHelp();
                }
            });
        }
    }

    protected class LSpecialCheckBox
    extends LCheckBox {
        LHelpComponent forwardTo;

        public LSpecialCheckBox(String text, Font font, Color shade, LHelpComponent forwardTo_) {
            super(text, font, shade);
            this.forwardTo = forwardTo_;
        }

        @Override
        public void updateHelp() {
            this.forwardTo.updateHelp();
        }
    }
}

