/*
 * Decompiled with CFR 0.152.
 */
package lev.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lev.gui.LComponent;
import lev.gui.LHelpComponent;
import lev.gui.LUserSetting;
import lev.gui.Setting;

public class LCheckBox
extends LUserSetting<Boolean> {
    protected JCheckBox cbox;
    protected ArrayList<LComponent> underlings = new ArrayList(0);

    public LCheckBox(String text, Font font, Color shade) {
        super(text, font, shade);
        int spacing = 5;
        this.titleLabel.addMouseListener(new ClickText());
        this.cbox = new JCheckBox();
        this.cbox.setSize(this.cbox.getPreferredSize());
        this.cbox.setOpaque(false);
        this.cbox.setLocation(this.titleLabel.getWidth() + spacing, 0);
        this.cbox.addChangeListener(new underlingChangeHandler());
        this.cbox.addActionListener(new underlingActionHandler());
        this.setSize(this.titleLabel.getWidth() + this.cbox.getWidth() + spacing, this.titleLabel.getHeight());
        this.setVisible(true);
        this.add(this.cbox);
    }

    @Override
    public int getCenter() {
        return this.titleLabel.getWidth() + 3;
    }

    public void addShadow() {
        this.titleLabel.addShadow();
    }

    @Override
    public void setFocusable(boolean focusable) {
        super.setFocusable(focusable);
        this.cbox.setFocusable(focusable);
    }

    public void setOffset(int offset) {
        this.cbox.setLocation(this.cbox.getX(), offset);
    }

    public void setSelected(Boolean b) {
        this.cbox.setSelected(b);
    }

    public Boolean isSelected() {
        return this.cbox.isSelected();
    }

    @Override
    public boolean revertTo(Map<Enum, Setting> m) {
        if (this.isTied().booleanValue()) {
            boolean cur = this.cbox.isSelected();
            this.cbox.setSelected(m.get(this.saveTie).getBool());
            if (cur != this.cbox.isSelected()) {
                return false;
            }
        }
        return true;
    }

    public void addActionListener(ActionListener l) {
        this.cbox.addActionListener(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.cbox.addChangeListener(l);
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.titleLabel.addMouseListener(l);
        this.cbox.addMouseListener(l);
    }

    @Override
    public Boolean getValue() {
        return this.cbox.isSelected();
    }

    public void addAsUnderling(LComponent c) {
        this.underlings.add(c);
        this.visibilityUpdate();
    }

    private void visibilityUpdate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (LComponent c : LCheckBox.this.underlings) {
                    c.setVisible(LCheckBox.this.isSelected());
                }
            }
        });
    }

    @Override
    public void highlightChanged() {
    }

    @Override
    public void clearHighlight() {
    }

    @Override
    public void addHelpHandler(boolean hoverListener) {
        this.cbox.addFocusListener(new LHelpComponent.HelpFocusHandler(this));
        if (hoverListener) {
            this.cbox.addMouseListener(new LHelpComponent.HelpMouseHandler(this));
            this.titleLabel.addMouseListener(new LHelpComponent.HelpMouseHandler(this));
        }
    }

    @Override
    protected final void addUpdateHandlers() {
        this.cbox.addActionListener(new LUserSetting.UpdateHandler(this));
        this.cbox.addChangeListener(new LUserSetting.UpdateChangeHandler(this));
    }

    public void removeChangeListener(ChangeListener c) {
        this.cbox.removeChangeListener(c);
    }

    public void setColor(Color c) {
        this.titleLabel.setForeground(c);
    }

    class ClickText
    implements MouseListener {
        ClickText() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            LCheckBox.this.cbox.requestFocusInWindow();
            if (LCheckBox.this.cbox.isSelected()) {
                LCheckBox.this.cbox.setSelected(false);
            } else {
                LCheckBox.this.cbox.setSelected(true);
            }
        }
    }

    private class underlingActionHandler
    implements ActionListener {
        private underlingActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            LCheckBox.this.visibilityUpdate();
        }
    }

    private class underlingChangeHandler
    implements ChangeListener {
        private underlingChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            LCheckBox.this.visibilityUpdate();
        }
    }
}

