/*
 * Decompiled with CFR 0.152.
 */
package lev.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.util.ArrayList;
import lev.gui.LChart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class LAreaChart
extends LChart {
    ArrayList<XYSeries> series = new ArrayList();
    public XYPlot plot;
    XYSeriesCollection collection = new XYSeriesCollection();

    public LAreaChart(String title_, Dimension size_, Color titleColor, Color seriesColor, String XLabel, String YLabel) {
        super(title_, size_);
        this.chart = ChartFactory.createXYAreaChart(null, (String)XLabel, (String)YLabel, (XYDataset)this.collection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.plot = this.chart.getXYPlot();
        this.plot.setBackgroundPaint((Paint)Color.lightGray);
        this.plot.setBackgroundAlpha(0.0f);
        this.plot.setForegroundAlpha(0.7f);
        this.plot.setDomainGridlinePaint((Paint)Color.white);
        this.plot.setRangeGridlinePaint((Paint)Color.white);
        this.plot.getDomainAxis().setLabelPaint((Paint)Color.lightGray);
        this.plot.getRangeAxis().setLabelPaint((Paint)Color.lightGray);
        this.plot.getRangeAxis().setTickLabelsVisible(false);
        this.plot.getDomainAxis().setTickLabelPaint((Paint)Color.lightGray);
        this.plot.getDomainAxis().setAutoRange(false);
        this.plot.getDomainAxis().setRange(-15.0, 15.0);
        this.plot.setDomainGridlinesVisible(false);
        this.plot.setRangeGridlinesVisible(false);
        this.plot.setOutlineVisible(false);
        this.plot.getRangeAxis().setAxisLineVisible(false);
        this.plot.getRangeAxis().setTickMarksVisible(false);
        this.addSeries(seriesColor);
        this.init(title_, size_, titleColor);
        this.cPanel.setSize(this.cPanel.getWidth() - 12, this.cPanel.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(new Color(50, 180, 180));
        g.drawLine(this.getSize().width / 2 + 4, 30, this.getSize().width / 2 + 4, this.getSize().height - 36);
    }

    public void clear() {
        for (XYSeries s : this.series) {
            s.clear();
        }
    }

    public void putPoint(int nthSeries, double x, double y) {
        this.series.get(nthSeries).add(x, y);
    }

    public final void addSeries(Color seriesColor) {
        XYSeries seriesNew = new XYSeries((Comparable)((Object)"Series"));
        this.series.add(seriesNew);
        this.collection.addSeries(seriesNew);
        XYItemRenderer renderer = this.plot.getRenderer();
        renderer.setSeriesPaint(this.series.size() - 1, (Paint)seriesColor);
    }

    public void resetDomain() {
        Range domain = this.plot.getDataRange(this.plot.getDomainAxis());
        double set = domain.getLowerBound();
        if (domain.getUpperBound() > Math.abs(set)) {
            set = domain.getUpperBound();
        }
        if (Math.abs(set) < 15.0) {
            set = 15.0;
        }
        this.plot.getDomainAxis().setRange(-Math.abs(set), Math.abs(set));
    }
}

