/*
 * Decompiled with CFR 0.152.
 */
package lev.debug;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lev.Ln;
import lev.debug.LDebug;

public class LLogger {
    protected String debugPath;
    protected LDebug main;
    protected LDebug synced;
    protected boolean syncing = false;
    protected LDebug asynced;
    protected boolean logging = true;
    protected boolean loggingSync = true;
    protected boolean loggingAsync = true;
    protected static boolean mainLogSwitch = true;
    protected Map<Enum, LDebug> special = new HashMap<Enum, LDebug>();

    public LLogger(String debugPath) {
        this.debugPath = debugPath;
        Ln.deleteDirectory(new File(debugPath));
        this.main = new LDebug(debugPath + "=--Debug Overview--=.txt", 50);
        this.asynced = new LDebug(debugPath + "Asynchronous log.txt", 50);
        this.synced = new LDebug();
    }

    public void addSpecial(Enum key, String filePath) {
        if (this.special.containsKey(key)) {
            this.special.get(key).closeDebugFile();
        }
        this.special.put(key, new LDebug(this.debugPath + filePath, 50));
    }

    public void logSync(String header, String ... log) {
        if (this.loggingSync() || this.syncing && this.loggingAsync()) {
            if (this.syncing) {
                this.synced.w(header, log);
            } else {
                this.log(header, log);
            }
        }
    }

    public void newSyncLog(String filePath) {
        if (this.logging()) {
            this.synced.openDebug(this.debugPath + filePath, 50);
        }
    }

    public void sync(boolean on) {
        this.syncing = on;
    }

    public boolean sync() {
        return this.syncing;
    }

    public void logMain(String header, String ... log) {
        this.main.w(header, log);
        this.main.flushDebug();
    }

    public void logError(String header, String ... log) {
        LDebug logger = this.sync() ? this.synced : this.asynced;
        this.logMain("ERROR", " /=== ERROR!");
        this.logMain("ERROR", "(==== File: " + logger.getOpenPath());
        this.logMain("ERROR", " \\=== Line: " + logger.line());
        String message = "  \\== Message: ";
        for (String s : log) {
            message = message + s;
        }
        this.logMain("ERROR", message);
        this.logMain("ERROR", "   \\========================================>");
        this.logSync(header, log);
        this.flush();
    }

    public boolean logging() {
        return this.logging && mainLogSwitch;
    }

    public void logging(Boolean on) {
        this.logging = on;
    }

    public boolean loggingSync() {
        return this.loggingSync && this.logging && mainLogSwitch;
    }

    public void loggingSync(Boolean on) {
        this.loggingSync = on;
    }

    public boolean loggingAsync() {
        return this.loggingAsync && this.logging && mainLogSwitch;
    }

    public void loggingAsync(Boolean on) {
        this.loggingAsync = on;
    }

    void logException(String dump) {
        this.main.writeException(dump);
    }

    public void logException(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        this.logSync("EXCEPTION", sw.toString());
        this.logException(sw.toString());
    }

    public void setAllLogging(boolean in) {
        mainLogSwitch = in;
    }

    public void flush() {
        if (this.logging()) {
            this.main.flushDebug();
            this.asynced.flushDebug();
            this.synced.flushDebug();
            for (LDebug d : this.special.values()) {
                d.flushDebug();
            }
        }
    }

    public void logSpecial(Enum e, String header, String ... log) {
        LDebug spec;
        if (this.logging() && (spec = this.special.get(e)) != null) {
            spec.w(header, log);
        }
    }

    public void log(String header, String ... log) {
        if (this.loggingAsync()) {
            this.asynced.w(header, log);
        }
    }

    public void newLog(String filePath) {
        this.asynced.openDebug(this.debugPath + filePath, 50);
    }

    public void close() {
        for (LDebug d : this.allDebugs()) {
            d.closeDebugFile();
        }
    }

    public ArrayList<LDebug> allDebugs() {
        ArrayList<LDebug> out = new ArrayList<LDebug>(this.special.values());
        out.add(this.main);
        out.add(this.asynced);
        out.add(this.synced);
        return out;
    }
}

